/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.Amount;
import com.adyen.model.transferwebhooks.BalanceMutation;
import com.adyen.model.transferwebhooks.CounterpartyV3;
import com.adyen.model.transferwebhooks.JSON;
import com.adyen.model.transferwebhooks.PaymentInstrument;
import com.adyen.model.transferwebhooks.RelayedAuthorisationData;
import com.adyen.model.transferwebhooks.ResourceReference;
import com.adyen.model.transferwebhooks.TransactionRulesResult;
import com.adyen.model.transferwebhooks.TransferEvent;
import com.adyen.model.transferwebhooks.TransferNotificationTransferTracking;
import com.adyen.model.transferwebhooks.TransferNotificationValidationFact;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransferNotificationData {
    public static final String SERIALIZED_NAME_ACCOUNT_HOLDER = "accountHolder";
    @SerializedName(value="accountHolder")
    private ResourceReference accountHolder;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT = "balanceAccount";
    @SerializedName(value="balanceAccount")
    private ResourceReference balanceAccount;
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT_ID = "balanceAccountId";
    @Deprecated
    @SerializedName(value="balanceAccountId")
    private String balanceAccountId;
    public static final String SERIALIZED_NAME_BALANCE_PLATFORM = "balancePlatform";
    @SerializedName(value="balancePlatform")
    private String balancePlatform;
    public static final String SERIALIZED_NAME_BALANCES = "balances";
    @SerializedName(value="balances")
    private List<BalanceMutation> balances = null;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
    @SerializedName(value="counterparty")
    private CounterpartyV3 counterparty;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private OffsetDateTime creationDate;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DIRECTION = "direction";
    @SerializedName(value="direction")
    private DirectionEnum direction;
    public static final String SERIALIZED_NAME_EVENTS = "events";
    @SerializedName(value="events")
    private List<TransferEvent> events = null;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_MODIFICATION_MERCHANT_REFERENCE = "modificationMerchantReference";
    @Deprecated
    @SerializedName(value="modificationMerchantReference")
    private String modificationMerchantReference;
    public static final String SERIALIZED_NAME_MODIFICATION_PSP_REFERENCE = "modificationPspReference";
    @Deprecated
    @SerializedName(value="modificationPspReference")
    private String modificationPspReference;
    public static final String SERIALIZED_NAME_PAN_ENTRY_MODE = "panEntryMode";
    @Deprecated
    @SerializedName(value="panEntryMode")
    private PanEntryModeEnum panEntryMode;
    public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENT = "paymentInstrument";
    @SerializedName(value="paymentInstrument")
    private PaymentInstrument paymentInstrument;
    public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    @Deprecated
    @SerializedName(value="paymentInstrumentId")
    private String paymentInstrumentId;
    public static final String SERIALIZED_NAME_PAYMENT_MERCHANT_REFERENCE = "paymentMerchantReference";
    @Deprecated
    @SerializedName(value="paymentMerchantReference")
    private String paymentMerchantReference;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private PriorityEnum priority;
    public static final String SERIALIZED_NAME_PROCESSING_TYPE = "processingType";
    @Deprecated
    @SerializedName(value="processingType")
    private ProcessingTypeEnum processingType;
    public static final String SERIALIZED_NAME_PSP_PAYMENT_REFERENCE = "pspPaymentReference";
    @Deprecated
    @SerializedName(value="pspPaymentReference")
    private String pspPaymentReference;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private ReasonEnum reason;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    @SerializedName(value="referenceForBeneficiary")
    private String referenceForBeneficiary;
    public static final String SERIALIZED_NAME_RELAYED_AUTHORISATION_DATA = "relayedAuthorisationData";
    @SerializedName(value="relayedAuthorisationData")
    private RelayedAuthorisationData relayedAuthorisationData;
    public static final String SERIALIZED_NAME_SEQUENCE_NUMBER = "sequenceNumber";
    @SerializedName(value="sequenceNumber")
    private Integer sequenceNumber;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TRACKING = "tracking";
    @SerializedName(value="tracking")
    private TransferNotificationTransferTracking tracking;
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transactionId";
    @Deprecated
    @SerializedName(value="transactionId")
    private String transactionId;
    public static final String SERIALIZED_NAME_TRANSACTION_RULES_RESULT = "transactionRulesResult";
    @SerializedName(value="transactionRulesResult")
    private TransactionRulesResult transactionRulesResult;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_VALIDATION_FACTS = "validationFacts";
    @Deprecated
    @SerializedName(value="validationFacts")
    private List<TransferNotificationValidationFact> validationFacts = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public TransferNotificationData accountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    @ApiModelProperty(value="")
    public ResourceReference getAccountHolder() {
        return this.accountHolder;
    }

    public void setAccountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
    }

    public TransferNotificationData amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public TransferNotificationData balanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
        return this;
    }

    @ApiModelProperty(value="")
    public ResourceReference getBalanceAccount() {
        return this.balanceAccount;
    }

    public void setBalanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
    }

    @Deprecated
    public TransferNotificationData balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The unique identifier of the source [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).")
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    @Deprecated
    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public TransferNotificationData balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance platform.")
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public TransferNotificationData balances(List<BalanceMutation> balances) {
        this.balances = balances;
        return this;
    }

    public TransferNotificationData addBalancesItem(BalanceMutation balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<BalanceMutation>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @ApiModelProperty(value="The list of the latest balance statuses in the transfer.")
    public List<BalanceMutation> getBalances() {
        return this.balances;
    }

    public void setBalances(List<BalanceMutation> balances) {
        this.balances = balances;
    }

    public TransferNotificationData category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of transfer.  Possible values:   - **bank**: Transfer to a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id) or a bank account.  - **internal**: Transfer to another [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  - **issuedCard**: Transfer initiated by a Adyen-issued card.  - **platformPayment**: Fund movements related to payments that are acquired for your users.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public TransferNotificationData counterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(value="")
    public CounterpartyV3 getCounterparty() {
        return this.counterparty;
    }

    public void setCounterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
    }

    public TransferNotificationData creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public TransferNotificationData description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the transfer. It is used by most banks as the transfer description. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.  Supported characters: **[a-z] [A-Z] [0-9] / - ?** **: ( ) . , ' + Space**  Supported characters for **regular** and **fast** transfers to a US counterparty: **[a-z] [A-Z] [0-9] & $ % # @** **~ = + - _ ' \" ! ?**")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransferNotificationData direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @ApiModelProperty(value="The direction of the transfer.  Possible values: **incoming**, **outgoing**.")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public TransferNotificationData events(List<TransferEvent> events) {
        this.events = events;
        return this;
    }

    public TransferNotificationData addEventsItem(TransferEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<TransferEvent>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(value="The list of events leading up to the current status of the transfer.")
    public List<TransferEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<TransferEvent> events) {
        this.events = events;
    }

    public TransferNotificationData id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the resource.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Deprecated
    public TransferNotificationData modificationMerchantReference(String modificationMerchantReference) {
        this.modificationMerchantReference = modificationMerchantReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The capture's merchant reference included in the transfer.")
    public String getModificationMerchantReference() {
        return this.modificationMerchantReference;
    }

    @Deprecated
    public void setModificationMerchantReference(String modificationMerchantReference) {
        this.modificationMerchantReference = modificationMerchantReference;
    }

    @Deprecated
    public TransferNotificationData modificationPspReference(String modificationPspReference) {
        this.modificationPspReference = modificationPspReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The capture reference included in the transfer.")
    public String getModificationPspReference() {
        return this.modificationPspReference;
    }

    @Deprecated
    public void setModificationPspReference(String modificationPspReference) {
        this.modificationPspReference = modificationPspReference;
    }

    @Deprecated
    public TransferNotificationData panEntryMode(PanEntryModeEnum panEntryMode) {
        this.panEntryMode = panEntryMode;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Indicates the method used for entering the PAN to initiate a transaction.  Possible values: **manual**, **chip**, **magstripe**, **contactless**, **cof**, **ecommerce**, **token**.")
    public PanEntryModeEnum getPanEntryMode() {
        return this.panEntryMode;
    }

    @Deprecated
    public void setPanEntryMode(PanEntryModeEnum panEntryMode) {
        this.panEntryMode = panEntryMode;
    }

    public TransferNotificationData paymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    public PaymentInstrument getPaymentInstrument() {
        return this.paymentInstrument;
    }

    public void setPaymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
    }

    @Deprecated
    public TransferNotificationData paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The unique identifier of the [payment instrument](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) used in the transfer.")
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    @Deprecated
    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    @Deprecated
    public TransferNotificationData paymentMerchantReference(String paymentMerchantReference) {
        this.paymentMerchantReference = paymentMerchantReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The payment's merchant reference included in the transfer.")
    public String getPaymentMerchantReference() {
        return this.paymentMerchantReference;
    }

    @Deprecated
    public void setPaymentMerchantReference(String paymentMerchantReference) {
        this.paymentMerchantReference = paymentMerchantReference;
    }

    public TransferNotificationData priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(value="The priority for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. Required for transfers with `category` **bank**.  Possible values:  * **regular**: For normal, low-value transactions.  * **fast**: Faster way to transfer funds but has higher fees. Recommended for high-priority, low-value transactions.  * **wire**: Fastest way to transfer funds but has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: Instant way to transfer funds in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: High-value transfer to a recipient in a different country.  * **internal**: Transfer to an Adyen-issued business bank account (by bank account number/IBAN).")
    public PriorityEnum getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    @Deprecated
    public TransferNotificationData processingType(ProcessingTypeEnum processingType) {
        this.processingType = processingType;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Contains information about how the payment was processed. For example, **ecommerce** for online or **pos** for in-person payments.")
    public ProcessingTypeEnum getProcessingType() {
        return this.processingType;
    }

    @Deprecated
    public void setProcessingType(ProcessingTypeEnum processingType) {
        this.processingType = processingType;
    }

    @Deprecated
    public TransferNotificationData pspPaymentReference(String pspPaymentReference) {
        this.pspPaymentReference = pspPaymentReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The payment reference included in the transfer.")
    public String getPspPaymentReference() {
        return this.pspPaymentReference;
    }

    @Deprecated
    public void setPspPaymentReference(String pspPaymentReference) {
        this.pspPaymentReference = pspPaymentReference;
    }

    public TransferNotificationData reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="Additional information about the status of the transfer.")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public TransferNotificationData reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the transfer, used internally within your platform. If you don't provide this in the request, Adyen generates a unique reference.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public TransferNotificationData referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        return this;
    }

    @ApiModelProperty(value=" A reference that is sent to the recipient. This reference is also sent in all webhooks related to the transfer, so you can use it to track statuses for both the source and recipient of funds.   Supported characters: **a-z**, **A-Z**, **0-9**. The maximum length depends on the `category`.  - **internal**: 80 characters  - **bank**: 35 characters when transferring to an IBAN, 15 characters for others.")
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
    }

    public TransferNotificationData relayedAuthorisationData(RelayedAuthorisationData relayedAuthorisationData) {
        this.relayedAuthorisationData = relayedAuthorisationData;
        return this;
    }

    @ApiModelProperty(value="")
    public RelayedAuthorisationData getRelayedAuthorisationData() {
        return this.relayedAuthorisationData;
    }

    public void setRelayedAuthorisationData(RelayedAuthorisationData relayedAuthorisationData) {
        this.relayedAuthorisationData = relayedAuthorisationData;
    }

    public TransferNotificationData sequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    @ApiModelProperty(value="The sequence number of the transfer notification. The numbers start from 1 and increase with each new notification for a specific transfer.  It can help you restore the correct sequence of events even if they arrive out of order.")
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public TransferNotificationData status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The result of the transfer.   For example, **authorised**, **refused**, or **error**.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TransferNotificationData tracking(TransferNotificationTransferTracking tracking) {
        this.tracking = tracking;
        return this;
    }

    @ApiModelProperty(value="")
    public TransferNotificationTransferTracking getTracking() {
        return this.tracking;
    }

    public void setTracking(TransferNotificationTransferTracking tracking) {
        this.tracking = tracking;
    }

    @Deprecated
    public TransferNotificationData transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The ID of the transaction that is created based on the transfer.")
    public String getTransactionId() {
        return this.transactionId;
    }

    @Deprecated
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransferNotificationData transactionRulesResult(TransactionRulesResult transactionRulesResult) {
        this.transactionRulesResult = transactionRulesResult;
        return this;
    }

    @ApiModelProperty(value="")
    public TransactionRulesResult getTransactionRulesResult() {
        return this.transactionRulesResult;
    }

    public void setTransactionRulesResult(TransactionRulesResult transactionRulesResult) {
        this.transactionRulesResult = transactionRulesResult;
    }

    public TransferNotificationData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of transfer or transaction. For example, **refund**, **payment**, **internalTransfer**, **bankTransfer**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    @Deprecated
    public TransferNotificationData validationFacts(List<TransferNotificationValidationFact> validationFacts) {
        this.validationFacts = validationFacts;
        return this;
    }

    public TransferNotificationData addValidationFactsItem(TransferNotificationValidationFact validationFactsItem) {
        if (this.validationFacts == null) {
            this.validationFacts = new ArrayList<TransferNotificationValidationFact>();
        }
        this.validationFacts.add(validationFactsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The evaluation of the validation facts. See [validation checks](https://docs.adyen.com/issuing/validation-checks) for more information.")
    public List<TransferNotificationValidationFact> getValidationFacts() {
        return this.validationFacts;
    }

    @Deprecated
    public void setValidationFacts(List<TransferNotificationValidationFact> validationFacts) {
        this.validationFacts = validationFacts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferNotificationData transferNotificationData = (TransferNotificationData)o;
        return Objects.equals(this.accountHolder, transferNotificationData.accountHolder) && Objects.equals(this.amount, transferNotificationData.amount) && Objects.equals(this.balanceAccount, transferNotificationData.balanceAccount) && Objects.equals(this.balanceAccountId, transferNotificationData.balanceAccountId) && Objects.equals(this.balancePlatform, transferNotificationData.balancePlatform) && Objects.equals(this.balances, transferNotificationData.balances) && Objects.equals((Object)this.category, (Object)transferNotificationData.category) && Objects.equals(this.counterparty, transferNotificationData.counterparty) && Objects.equals(this.creationDate, transferNotificationData.creationDate) && Objects.equals(this.description, transferNotificationData.description) && Objects.equals((Object)this.direction, (Object)transferNotificationData.direction) && Objects.equals(this.events, transferNotificationData.events) && Objects.equals(this.id, transferNotificationData.id) && Objects.equals(this.modificationMerchantReference, transferNotificationData.modificationMerchantReference) && Objects.equals(this.modificationPspReference, transferNotificationData.modificationPspReference) && Objects.equals((Object)this.panEntryMode, (Object)transferNotificationData.panEntryMode) && Objects.equals(this.paymentInstrument, transferNotificationData.paymentInstrument) && Objects.equals(this.paymentInstrumentId, transferNotificationData.paymentInstrumentId) && Objects.equals(this.paymentMerchantReference, transferNotificationData.paymentMerchantReference) && Objects.equals((Object)this.priority, (Object)transferNotificationData.priority) && Objects.equals((Object)this.processingType, (Object)transferNotificationData.processingType) && Objects.equals(this.pspPaymentReference, transferNotificationData.pspPaymentReference) && Objects.equals((Object)this.reason, (Object)transferNotificationData.reason) && Objects.equals(this.reference, transferNotificationData.reference) && Objects.equals(this.referenceForBeneficiary, transferNotificationData.referenceForBeneficiary) && Objects.equals(this.relayedAuthorisationData, transferNotificationData.relayedAuthorisationData) && Objects.equals(this.sequenceNumber, transferNotificationData.sequenceNumber) && Objects.equals((Object)this.status, (Object)transferNotificationData.status) && Objects.equals(this.tracking, transferNotificationData.tracking) && Objects.equals(this.transactionId, transferNotificationData.transactionId) && Objects.equals(this.transactionRulesResult, transferNotificationData.transactionRulesResult) && Objects.equals((Object)this.type, (Object)transferNotificationData.type) && Objects.equals(this.validationFacts, transferNotificationData.validationFacts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolder, this.amount, this.balanceAccount, this.balanceAccountId, this.balancePlatform, this.balances, this.category, this.counterparty, this.creationDate, this.description, this.direction, this.events, this.id, this.modificationMerchantReference, this.modificationPspReference, this.panEntryMode, this.paymentInstrument, this.paymentInstrumentId, this.paymentMerchantReference, this.priority, this.processingType, this.pspPaymentReference, this.reason, this.reference, this.referenceForBeneficiary, this.relayedAuthorisationData, this.sequenceNumber, this.status, this.tracking, this.transactionId, this.transactionRulesResult, this.type, this.validationFacts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferNotificationData {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccount: ").append(this.toIndentedString(this.balanceAccount)).append("\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    modificationMerchantReference: ").append(this.toIndentedString(this.modificationMerchantReference)).append("\n");
        sb.append("    modificationPspReference: ").append(this.toIndentedString(this.modificationPspReference)).append("\n");
        sb.append("    panEntryMode: ").append(this.toIndentedString((Object)this.panEntryMode)).append("\n");
        sb.append("    paymentInstrument: ").append(this.toIndentedString(this.paymentInstrument)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    paymentMerchantReference: ").append(this.toIndentedString(this.paymentMerchantReference)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    processingType: ").append(this.toIndentedString((Object)this.processingType)).append("\n");
        sb.append("    pspPaymentReference: ").append(this.toIndentedString(this.pspPaymentReference)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    relayedAuthorisationData: ").append(this.toIndentedString(this.relayedAuthorisationData)).append("\n");
        sb.append("    sequenceNumber: ").append(this.toIndentedString(this.sequenceNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tracking: ").append(this.toIndentedString(this.tracking)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionRulesResult: ").append(this.toIndentedString(this.transactionRulesResult)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    validationFacts: ").append(this.toIndentedString(this.validationFacts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvalidationFacts;
        JsonArray jsonArrayevents;
        JsonArray jsonArraybalances;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TransferNotificationData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `TransferNotificationData` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_HOLDER) != null) {
            ResourceReference.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_HOLDER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BALANCE_ACCOUNT) != null) {
            ResourceReference.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BALANCE_ACCOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `balanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `balancePlatform` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).toString()));
        }
        if ((jsonArraybalances = jsonObj.getAsJsonArray(SERIALIZED_NAME_BALANCES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BALANCES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `balances` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCES).toString()));
            }
            for (int i = 0; i < jsonArraybalances.size(); ++i) {
                BalanceMutation.validateJsonObject(jsonArraybalances.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CATEGORY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CATEGORY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `category` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CATEGORY).toString()));
            }
            CategoryEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CATEGORY).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY) != null) {
            CounterpartyV3.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DIRECTION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DIRECTION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `direction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIRECTION).toString()));
            }
            DirectionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_DIRECTION).getAsString());
        }
        if ((jsonArrayevents = jsonObj.getAsJsonArray(SERIALIZED_NAME_EVENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EVENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `events` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENTS).toString()));
            }
            for (int i = 0; i < jsonArrayevents.size(); ++i) {
                TransferEvent.validateJsonObject(jsonArrayevents.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODIFICATION_MERCHANT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_MODIFICATION_MERCHANT_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `modificationMerchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODIFICATION_MERCHANT_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODIFICATION_PSP_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_MODIFICATION_PSP_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `modificationPspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MODIFICATION_PSP_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAN_ENTRY_MODE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PAN_ENTRY_MODE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `panEntryMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAN_ENTRY_MODE).toString()));
            }
            PanEntryModeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_PAN_ENTRY_MODE).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYMENT_INSTRUMENT) != null) {
            PaymentInstrument.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYMENT_INSTRUMENT));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentInstrumentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_MERCHANT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_MERCHANT_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `paymentMerchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_MERCHANT_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIORITY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PRIORITY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `priority` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIORITY).toString()));
            }
            PriorityEnum.fromValue(jsonObj.get(SERIALIZED_NAME_PRIORITY).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `processingType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE).toString()));
            }
            ProcessingTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_PROCESSING_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_PSP_PAYMENT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PSP_PAYMENT_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `pspPaymentReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PSP_PAYMENT_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
            }
            ReasonEnum.fromValue(jsonObj.get(SERIALIZED_NAME_REASON).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `referenceForBeneficiary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RELAYED_AUTHORISATION_DATA) != null) {
            RelayedAuthorisationData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RELAYED_AUTHORISATION_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TRACKING) != null) {
            TransferNotificationTransferTracking.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TRACKING));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `transactionId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSACTION_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TRANSACTION_RULES_RESULT) != null) {
            TransactionRulesResult.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TRANSACTION_RULES_RESULT));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
        if ((jsonArrayvalidationFacts = jsonObj.getAsJsonArray(SERIALIZED_NAME_VALIDATION_FACTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VALIDATION_FACTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `validationFacts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALIDATION_FACTS).toString()));
            }
            for (int i = 0; i < jsonArrayvalidationFacts.size(); ++i) {
                TransferNotificationValidationFact.validateJsonObject(jsonArrayvalidationFacts.get(i).getAsJsonObject());
            }
        }
    }

    public static TransferNotificationData fromJson(String jsonString) throws IOException {
        return (TransferNotificationData)JSON.getGson().fromJson(jsonString, TransferNotificationData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_HOLDER);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_BALANCE_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_BALANCES);
        openapiFields.add(SERIALIZED_NAME_CATEGORY);
        openapiFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_DIRECTION);
        openapiFields.add(SERIALIZED_NAME_EVENTS);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_MODIFICATION_MERCHANT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_MODIFICATION_PSP_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_PAN_ENTRY_MODE);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_INSTRUMENT);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_MERCHANT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_PRIORITY);
        openapiFields.add(SERIALIZED_NAME_PROCESSING_TYPE);
        openapiFields.add(SERIALIZED_NAME_PSP_PAYMENT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY);
        openapiFields.add(SERIALIZED_NAME_RELAYED_AUTHORISATION_DATA);
        openapiFields.add(SERIALIZED_NAME_SEQUENCE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TRACKING);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_ID);
        openapiFields.add(SERIALIZED_NAME_TRANSACTION_RULES_RESULT);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_VALIDATION_FACTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_CATEGORY);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        log = Logger.getLogger(TransferNotificationData.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TransferNotificationData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TransferNotificationData.class));
            return new TypeAdapter<TransferNotificationData>(){

                public void write(JsonWriter out, TransferNotificationData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TransferNotificationData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TransferNotificationData.validateJsonObject(jsonObj);
                    return (TransferNotificationData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSAL("atmWithdrawalReversal"),
        BALANCEADJUSTMENT("balanceAdjustment"),
        BALANCEROLLOVER("balanceRollover"),
        BANKTRANSFER("bankTransfer"),
        CAPTURE("capture"),
        CAPTUREREVERSAL("captureReversal"),
        CHARGEBACK("chargeback"),
        CHARGEBACKREVERSAL("chargebackReversal"),
        DEPOSITCORRECTION("depositCorrection"),
        FEE("fee"),
        GRANT("grant"),
        INSTALLMENT("installment"),
        INSTALLMENTREVERSAL("installmentReversal"),
        INTERNALTRANSFER("internalTransfer"),
        INVOICEDEDUCTION("invoiceDeduction"),
        LEFTOVER("leftover"),
        MANUALCORRECTION("manualCorrection"),
        MISCCOST("miscCost"),
        PAYMENT("payment"),
        PAYMENTCOST("paymentCost"),
        REFUND("refund"),
        REFUNDREVERSAL("refundReversal"),
        REPAYMENT("repayment"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        SECONDCHARGEBACK("secondChargeback");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        APPROVALPENDING("approvalPending"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSALPENDING("atmWithdrawalReversalPending"),
        ATMWITHDRAWALREVERSED("atmWithdrawalReversed"),
        AUTHADJUSTMENTAUTHORISED("authAdjustmentAuthorised"),
        AUTHADJUSTMENTERROR("authAdjustmentError"),
        AUTHADJUSTMENTREFUSED("authAdjustmentRefused"),
        AUTHORISED("authorised"),
        BANKTRANSFER("bankTransfer"),
        BANKTRANSFERPENDING("bankTransferPending"),
        BOOKED("booked"),
        BOOKINGPENDING("bookingPending"),
        CANCELLED("cancelled"),
        CAPTUREPENDING("capturePending"),
        CAPTUREREVERSALPENDING("captureReversalPending"),
        CAPTUREREVERSED("captureReversed"),
        CAPTURED("captured"),
        CHARGEBACK("chargeback"),
        CHARGEBACKPENDING("chargebackPending"),
        CHARGEBACKREVERSALPENDING("chargebackReversalPending"),
        CHARGEBACKREVERSED("chargebackReversed"),
        CREDITED("credited"),
        DEPOSITCORRECTION("depositCorrection"),
        DEPOSITCORRECTIONPENDING("depositCorrectionPending"),
        DISPUTE("dispute"),
        DISPUTECLOSED("disputeClosed"),
        DISPUTEEXPIRED("disputeExpired"),
        DISPUTENEEDSREVIEW("disputeNeedsReview"),
        ERROR("error"),
        EXPIRED("expired"),
        FAILED("failed"),
        FEE("fee"),
        FEEPENDING("feePending"),
        INTERNALTRANSFER("internalTransfer"),
        INTERNALTRANSFERPENDING("internalTransferPending"),
        INVOICEDEDUCTION("invoiceDeduction"),
        INVOICEDEDUCTIONPENDING("invoiceDeductionPending"),
        MANUALCORRECTIONPENDING("manualCorrectionPending"),
        MANUALLYCORRECTED("manuallyCorrected"),
        MATCHEDSTATEMENT("matchedStatement"),
        MATCHEDSTATEMENTPENDING("matchedStatementPending"),
        MERCHANTPAYIN("merchantPayin"),
        MERCHANTPAYINPENDING("merchantPayinPending"),
        MERCHANTPAYINREVERSED("merchantPayinReversed"),
        MERCHANTPAYINREVERSEDPENDING("merchantPayinReversedPending"),
        MISCCOST("miscCost"),
        MISCCOSTPENDING("miscCostPending"),
        PAYMENTCOST("paymentCost"),
        PAYMENTCOSTPENDING("paymentCostPending"),
        RECEIVED("received"),
        REFUNDPENDING("refundPending"),
        REFUNDREVERSALPENDING("refundReversalPending"),
        REFUNDREVERSED("refundReversed"),
        REFUNDED("refunded"),
        REFUSED("refused"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        RESERVEADJUSTMENTPENDING("reserveAdjustmentPending"),
        RETURNED("returned"),
        SECONDCHARGEBACK("secondChargeback"),
        SECONDCHARGEBACKPENDING("secondChargebackPending"),
        UNDEFINED("undefined");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReasonEnum {
        AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
        APPROVED("approved"),
        COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
        COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
        COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
        COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
        COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
        COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
        ERROR("error"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
        ROUTENOTFOUND("routeNotFound"),
        UNKNOWN("unknown");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReasonEnum> {
            public void write(JsonWriter jsonWriter, ReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReasonEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProcessingTypeEnum {
        ATMWITHDRAW("atmWithdraw"),
        BALANCEINQUIRY("balanceInquiry"),
        ECOMMERCE("ecommerce"),
        MOTO("moto"),
        POS("pos"),
        PURCHASEWITHCASHBACK("purchaseWithCashback"),
        RECURRING("recurring"),
        TOKEN("token");

        private String value;

        private ProcessingTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProcessingTypeEnum fromValue(String value) {
            for (ProcessingTypeEnum b : ProcessingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ProcessingTypeEnum> {
            public void write(JsonWriter jsonWriter, ProcessingTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProcessingTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProcessingTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PriorityEnum {
        CROSSBORDER("crossBorder"),
        DIRECTDEBIT("directDebit"),
        FAST("fast"),
        INSTANT("instant"),
        INTERNAL("internal"),
        REGULAR("regular"),
        WIRE("wire");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PriorityEnum> {
            public void write(JsonWriter jsonWriter, PriorityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PriorityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PriorityEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PanEntryModeEnum {
        CHIP("chip"),
        COF("cof"),
        CONTACTLESS("contactless"),
        ECOMMERCE("ecommerce"),
        MAGSTRIPE("magstripe"),
        MANUAL("manual"),
        TOKEN("token");

        private String value;

        private PanEntryModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PanEntryModeEnum fromValue(String value) {
            for (PanEntryModeEnum b : PanEntryModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PanEntryModeEnum> {
            public void write(JsonWriter jsonWriter, PanEntryModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PanEntryModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PanEntryModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectionEnum {
        INCOMING("incoming"),
        OUTGOING("outgoing");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DirectionEnum> {
            public void write(JsonWriter jsonWriter, DirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        BANK("bank"),
        INTERNAL("internal"),
        ISSUEDCARD("issuedCard"),
        PLATFORMPAYMENT("platformPayment");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }
}

