/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transferwebhooks;

import com.adyen.model.transferwebhooks.Amount;
import com.adyen.model.transferwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmountAdjustment {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_AMOUNT_ADJUSTMENT_TYPE = "amountAdjustmentType";
    @SerializedName(value="amountAdjustmentType")
    private AmountAdjustmentTypeEnum amountAdjustmentType;
    public static final String SERIALIZED_NAME_BASEPOINTS = "basepoints";
    @SerializedName(value="basepoints")
    private Integer basepoints;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public AmountAdjustment amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public AmountAdjustment amountAdjustmentType(AmountAdjustmentTypeEnum amountAdjustmentType) {
        this.amountAdjustmentType = amountAdjustmentType;
        return this;
    }

    @ApiModelProperty(value="The type of markup that is applied to an authorised payment.  Possible values: **exchange**, **forexMarkup**, **authHoldReserve**, **atmMarkup**.")
    public AmountAdjustmentTypeEnum getAmountAdjustmentType() {
        return this.amountAdjustmentType;
    }

    public void setAmountAdjustmentType(AmountAdjustmentTypeEnum amountAdjustmentType) {
        this.amountAdjustmentType = amountAdjustmentType;
    }

    public AmountAdjustment basepoints(Integer basepoints) {
        this.basepoints = basepoints;
        return this;
    }

    @ApiModelProperty(value="The basepoints associated with the applied markup.")
    public Integer getBasepoints() {
        return this.basepoints;
    }

    public void setBasepoints(Integer basepoints) {
        this.basepoints = basepoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmountAdjustment amountAdjustment = (AmountAdjustment)o;
        return Objects.equals(this.amount, amountAdjustment.amount) && Objects.equals((Object)this.amountAdjustmentType, (Object)amountAdjustment.amountAdjustmentType) && Objects.equals(this.basepoints, amountAdjustment.basepoints);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.amountAdjustmentType, this.basepoints});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AmountAdjustment {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    amountAdjustmentType: ").append(this.toIndentedString((Object)this.amountAdjustmentType)).append("\n");
        sb.append("    basepoints: ").append(this.toIndentedString(this.basepoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AmountAdjustment is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `AmountAdjustment` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_AMOUNT_ADJUSTMENT_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_AMOUNT_ADJUSTMENT_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `amountAdjustmentType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AMOUNT_ADJUSTMENT_TYPE).toString()));
            }
            AmountAdjustmentTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_AMOUNT_ADJUSTMENT_TYPE).getAsString());
        }
    }

    public static AmountAdjustment fromJson(String jsonString) throws IOException {
        return (AmountAdjustment)JSON.getGson().fromJson(jsonString, AmountAdjustment.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_AMOUNT_ADJUSTMENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_BASEPOINTS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(AmountAdjustment.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AmountAdjustment.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AmountAdjustment.class));
            return new TypeAdapter<AmountAdjustment>(){

                public void write(JsonWriter out, AmountAdjustment value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AmountAdjustment read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AmountAdjustment.validateJsonObject(jsonObj);
                    return (AmountAdjustment)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AmountAdjustmentTypeEnum {
        ATMMARKUP("atmMarkup"),
        AUTHHOLDRESERVE("authHoldReserve"),
        EXCHANGE("exchange"),
        FOREXMARKUP("forexMarkup");

        private String value;

        private AmountAdjustmentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AmountAdjustmentTypeEnum fromValue(String value) {
            for (AmountAdjustmentTypeEnum b : AmountAdjustmentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AmountAdjustmentTypeEnum> {
            public void write(JsonWriter jsonWriter, AmountAdjustmentTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AmountAdjustmentTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AmountAdjustmentTypeEnum.fromValue(value);
            }
        }
    }
}

