/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.storedvalue;

import com.adyen.model.storedvalue.Amount;
import com.adyen.model.storedvalue.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StoredValueStatusChangeResponse {
    public static final String SERIALIZED_NAME_AUTH_CODE = "authCode";
    @SerializedName(value="authCode")
    private String authCode;
    public static final String SERIALIZED_NAME_CURRENT_BALANCE = "currentBalance";
    @SerializedName(value="currentBalance")
    private Amount currentBalance;
    public static final String SERIALIZED_NAME_PSP_REFERENCE = "pspReference";
    @SerializedName(value="pspReference")
    private String pspReference;
    public static final String SERIALIZED_NAME_REFUSAL_REASON = "refusalReason";
    @SerializedName(value="refusalReason")
    private String refusalReason;
    public static final String SERIALIZED_NAME_RESULT_CODE = "resultCode";
    @SerializedName(value="resultCode")
    private ResultCodeEnum resultCode;
    public static final String SERIALIZED_NAME_THIRD_PARTY_REFUSAL_REASON = "thirdPartyRefusalReason";
    @SerializedName(value="thirdPartyRefusalReason")
    private String thirdPartyRefusalReason;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public StoredValueStatusChangeResponse authCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    @ApiModelProperty(value="Authorisation code: * When the payment is authorised, this field holds the authorisation code for the payment. * When the payment is not authorised, this field is empty.")
    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public StoredValueStatusChangeResponse currentBalance(Amount currentBalance) {
        this.currentBalance = currentBalance;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getCurrentBalance() {
        return this.currentBalance;
    }

    public void setCurrentBalance(Amount currentBalance) {
        this.currentBalance = currentBalance;
    }

    public StoredValueStatusChangeResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="Adyen's 16-character string reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.")
    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public StoredValueStatusChangeResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @ApiModelProperty(value="If the transaction is refused or an error occurs, this field holds Adyen's mapped reason for the refusal or a description of the error.  When a transaction fails, the authorisation response includes `resultCode` and `refusalReason` values.")
    public String getRefusalReason() {
        return this.refusalReason;
    }

    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public StoredValueStatusChangeResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result of the payment. Possible values:  * **Success** \u2013 The operation has been completed successfully.  * **Refused** \u2013 The operation was refused. The reason is given in the `refusalReason` field.  * **Error** \u2013 There was an error when the operation was processed. The reason is given in the `refusalReason` field.  * **NotEnoughBalance** \u2013 The amount on the payment method is lower than the amount given in the request. Only applicable to balance checks.  ")
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public StoredValueStatusChangeResponse thirdPartyRefusalReason(String thirdPartyRefusalReason) {
        this.thirdPartyRefusalReason = thirdPartyRefusalReason;
        return this;
    }

    @ApiModelProperty(value="Raw refusal reason received from the third party, where available")
    public String getThirdPartyRefusalReason() {
        return this.thirdPartyRefusalReason;
    }

    public void setThirdPartyRefusalReason(String thirdPartyRefusalReason) {
        this.thirdPartyRefusalReason = thirdPartyRefusalReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredValueStatusChangeResponse storedValueStatusChangeResponse = (StoredValueStatusChangeResponse)o;
        return Objects.equals(this.authCode, storedValueStatusChangeResponse.authCode) && Objects.equals(this.currentBalance, storedValueStatusChangeResponse.currentBalance) && Objects.equals(this.pspReference, storedValueStatusChangeResponse.pspReference) && Objects.equals(this.refusalReason, storedValueStatusChangeResponse.refusalReason) && Objects.equals((Object)this.resultCode, (Object)storedValueStatusChangeResponse.resultCode) && Objects.equals(this.thirdPartyRefusalReason, storedValueStatusChangeResponse.thirdPartyRefusalReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authCode, this.currentBalance, this.pspReference, this.refusalReason, this.resultCode, this.thirdPartyRefusalReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredValueStatusChangeResponse {\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    currentBalance: ").append(this.toIndentedString(this.currentBalance)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    thirdPartyRefusalReason: ").append(this.toIndentedString(this.thirdPartyRefusalReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StoredValueStatusChangeResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `StoredValueStatusChangeResponse` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTH_CODE) != null && !jsonObj.get(SERIALIZED_NAME_AUTH_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `authCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTH_CODE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CURRENT_BALANCE) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CURRENT_BALANCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `pspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `refusalReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESULT_CODE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESULT_CODE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `resultCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULT_CODE).toString()));
            }
            ResultCodeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_RESULT_CODE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_THIRD_PARTY_REFUSAL_REASON) != null && !jsonObj.get(SERIALIZED_NAME_THIRD_PARTY_REFUSAL_REASON).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `thirdPartyRefusalReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THIRD_PARTY_REFUSAL_REASON).toString()));
        }
    }

    public static StoredValueStatusChangeResponse fromJson(String jsonString) throws IOException {
        return (StoredValueStatusChangeResponse)JSON.getGson().fromJson(jsonString, StoredValueStatusChangeResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUTH_CODE);
        openapiFields.add(SERIALIZED_NAME_CURRENT_BALANCE);
        openapiFields.add(SERIALIZED_NAME_PSP_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFUSAL_REASON);
        openapiFields.add(SERIALIZED_NAME_RESULT_CODE);
        openapiFields.add(SERIALIZED_NAME_THIRD_PARTY_REFUSAL_REASON);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(StoredValueStatusChangeResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StoredValueStatusChangeResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StoredValueStatusChangeResponse.class));
            return new TypeAdapter<StoredValueStatusChangeResponse>(){

                public void write(JsonWriter out, StoredValueStatusChangeResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StoredValueStatusChangeResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StoredValueStatusChangeResponse.validateJsonObject(jsonObj);
                    return (StoredValueStatusChangeResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResultCodeEnum {
        SUCCESS("Success"),
        REFUSED("Refused"),
        ERROR("Error"),
        NOTENOUGHBALANCE("NotEnoughBalance");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ResultCodeEnum> {
            public void write(JsonWriter jsonWriter, ResultCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResultCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResultCodeEnum.fromValue(value);
            }
        }
    }
}

