/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.JSON;
import com.adyen.model.recurring.RecurringDetailWrapper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecurringDetailsResult {
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private OffsetDateTime creationDate;
    public static final String SERIALIZED_NAME_DETAILS = "details";
    @SerializedName(value="details")
    private List<RecurringDetailWrapper> details = null;
    public static final String SERIALIZED_NAME_LAST_KNOWN_SHOPPER_EMAIL = "lastKnownShopperEmail";
    @SerializedName(value="lastKnownShopperEmail")
    private String lastKnownShopperEmail;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public RecurringDetailsResult creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date when the recurring details were created.")
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public RecurringDetailsResult details(List<RecurringDetailWrapper> details) {
        this.details = details;
        return this;
    }

    public RecurringDetailsResult addDetailsItem(RecurringDetailWrapper detailsItem) {
        if (this.details == null) {
            this.details = new ArrayList<RecurringDetailWrapper>();
        }
        this.details.add(detailsItem);
        return this;
    }

    @ApiModelProperty(value="Payment details stored for recurring payments.")
    public List<RecurringDetailWrapper> getDetails() {
        return this.details;
    }

    public void setDetails(List<RecurringDetailWrapper> details) {
        this.details = details;
    }

    public RecurringDetailsResult lastKnownShopperEmail(String lastKnownShopperEmail) {
        this.lastKnownShopperEmail = lastKnownShopperEmail;
        return this;
    }

    @ApiModelProperty(value="The most recent email for this shopper (if available).")
    public String getLastKnownShopperEmail() {
        return this.lastKnownShopperEmail;
    }

    public void setLastKnownShopperEmail(String lastKnownShopperEmail) {
        this.lastKnownShopperEmail = lastKnownShopperEmail;
    }

    public RecurringDetailsResult shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="The reference you use to uniquely identify the shopper (e.g. user ID or account ID).")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringDetailsResult recurringDetailsResult = (RecurringDetailsResult)o;
        return Objects.equals(this.creationDate, recurringDetailsResult.creationDate) && Objects.equals(this.details, recurringDetailsResult.details) && Objects.equals(this.lastKnownShopperEmail, recurringDetailsResult.lastKnownShopperEmail) && Objects.equals(this.shopperReference, recurringDetailsResult.shopperReference);
    }

    public int hashCode() {
        return Objects.hash(this.creationDate, this.details, this.lastKnownShopperEmail, this.shopperReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurringDetailsResult {\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    lastKnownShopperEmail: ").append(this.toIndentedString(this.lastKnownShopperEmail)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RecurringDetailsResult is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `RecurringDetailsResult` properties.", entry.getKey()));
        }
        JsonArray jsonArraydetails = jsonObj.getAsJsonArray(SERIALIZED_NAME_DETAILS);
        if (jsonArraydetails != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DETAILS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `details` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DETAILS).toString()));
            }
            for (int i = 0; i < jsonArraydetails.size(); ++i) {
                RecurringDetailWrapper.validateJsonObject(jsonArraydetails.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_KNOWN_SHOPPER_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_LAST_KNOWN_SHOPPER_EMAIL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `lastKnownShopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_KNOWN_SHOPPER_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
    }

    public static RecurringDetailsResult fromJson(String jsonString) throws IOException {
        return (RecurringDetailsResult)JSON.getGson().fromJson(jsonString, RecurringDetailsResult.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_DETAILS);
        openapiFields.add(SERIALIZED_NAME_LAST_KNOWN_SHOPPER_EMAIL);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(RecurringDetailsResult.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!RecurringDetailsResult.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RecurringDetailsResult.class));
            return new TypeAdapter<RecurringDetailsResult>(){

                public void write(JsonWriter out, RecurringDetailsResult value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public RecurringDetailsResult read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RecurringDetailsResult.validateJsonObject(jsonObj);
                    return (RecurringDetailsResult)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

