/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResponseAdditionalDataCard {
    public static final String SERIALIZED_NAME_CARD_BIN = "cardBin";
    @SerializedName(value="cardBin")
    private String cardBin;
    public static final String SERIALIZED_NAME_CARD_HOLDER_NAME = "cardHolderName";
    @SerializedName(value="cardHolderName")
    private String cardHolderName;
    public static final String SERIALIZED_NAME_CARD_ISSUING_BANK = "cardIssuingBank";
    @SerializedName(value="cardIssuingBank")
    private String cardIssuingBank;
    public static final String SERIALIZED_NAME_CARD_ISSUING_COUNTRY = "cardIssuingCountry";
    @SerializedName(value="cardIssuingCountry")
    private String cardIssuingCountry;
    public static final String SERIALIZED_NAME_CARD_ISSUING_CURRENCY = "cardIssuingCurrency";
    @SerializedName(value="cardIssuingCurrency")
    private String cardIssuingCurrency;
    public static final String SERIALIZED_NAME_CARD_PAYMENT_METHOD = "cardPaymentMethod";
    @SerializedName(value="cardPaymentMethod")
    private String cardPaymentMethod;
    public static final String SERIALIZED_NAME_CARD_SUMMARY = "cardSummary";
    @SerializedName(value="cardSummary")
    private String cardSummary;
    public static final String SERIALIZED_NAME_ISSUER_BIN = "issuerBin";
    @SerializedName(value="issuerBin")
    private String issuerBin;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ResponseAdditionalDataCard cardBin(String cardBin) {
        this.cardBin = cardBin;
        return this;
    }

    @ApiModelProperty(value="The first six digits of the card number.  This is the [Bank Identification Number (BIN)](https://docs.adyen.com/get-started-with-adyen/payment-glossary#bank-identification-number-bin) for card numbers with a six-digit BIN.  Example: 521234")
    public String getCardBin() {
        return this.cardBin;
    }

    public void setCardBin(String cardBin) {
        this.cardBin = cardBin;
    }

    public ResponseAdditionalDataCard cardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
        return this;
    }

    @ApiModelProperty(value="The cardholder name passed in the payment request.")
    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public ResponseAdditionalDataCard cardIssuingBank(String cardIssuingBank) {
        this.cardIssuingBank = cardIssuingBank;
        return this;
    }

    @ApiModelProperty(value="The bank or the financial institution granting lines of credit through card association branded payment cards. This information can be included when available.")
    public String getCardIssuingBank() {
        return this.cardIssuingBank;
    }

    public void setCardIssuingBank(String cardIssuingBank) {
        this.cardIssuingBank = cardIssuingBank;
    }

    public ResponseAdditionalDataCard cardIssuingCountry(String cardIssuingCountry) {
        this.cardIssuingCountry = cardIssuingCountry;
        return this;
    }

    @ApiModelProperty(value="The country where the card was issued.  Example: US")
    public String getCardIssuingCountry() {
        return this.cardIssuingCountry;
    }

    public void setCardIssuingCountry(String cardIssuingCountry) {
        this.cardIssuingCountry = cardIssuingCountry;
    }

    public ResponseAdditionalDataCard cardIssuingCurrency(String cardIssuingCurrency) {
        this.cardIssuingCurrency = cardIssuingCurrency;
        return this;
    }

    @ApiModelProperty(value="The currency in which the card is issued, if this information is available. Provided as the currency code or currency number from the ISO-4217 standard.   Example: USD")
    public String getCardIssuingCurrency() {
        return this.cardIssuingCurrency;
    }

    public void setCardIssuingCurrency(String cardIssuingCurrency) {
        this.cardIssuingCurrency = cardIssuingCurrency;
    }

    public ResponseAdditionalDataCard cardPaymentMethod(String cardPaymentMethod) {
        this.cardPaymentMethod = cardPaymentMethod;
        return this;
    }

    @ApiModelProperty(value="The card payment method used for the transaction.  Example: amex")
    public String getCardPaymentMethod() {
        return this.cardPaymentMethod;
    }

    public void setCardPaymentMethod(String cardPaymentMethod) {
        this.cardPaymentMethod = cardPaymentMethod;
    }

    public ResponseAdditionalDataCard cardSummary(String cardSummary) {
        this.cardSummary = cardSummary;
        return this;
    }

    @ApiModelProperty(value="The last four digits of a card number.  > Returned only in case of a card payment.")
    public String getCardSummary() {
        return this.cardSummary;
    }

    public void setCardSummary(String cardSummary) {
        this.cardSummary = cardSummary;
    }

    public ResponseAdditionalDataCard issuerBin(String issuerBin) {
        this.issuerBin = issuerBin;
        return this;
    }

    @ApiModelProperty(value="The first eight digits of the card number. Only returned if the card number is 16 digits or more.  This is the [Bank Identification Number (BIN)](https://docs.adyen.com/get-started-with-adyen/payment-glossary#bank-identification-number-bin) for card numbers with an eight-digit BIN.  Example: 52123423")
    public String getIssuerBin() {
        return this.issuerBin;
    }

    public void setIssuerBin(String issuerBin) {
        this.issuerBin = issuerBin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseAdditionalDataCard responseAdditionalDataCard = (ResponseAdditionalDataCard)o;
        return Objects.equals(this.cardBin, responseAdditionalDataCard.cardBin) && Objects.equals(this.cardHolderName, responseAdditionalDataCard.cardHolderName) && Objects.equals(this.cardIssuingBank, responseAdditionalDataCard.cardIssuingBank) && Objects.equals(this.cardIssuingCountry, responseAdditionalDataCard.cardIssuingCountry) && Objects.equals(this.cardIssuingCurrency, responseAdditionalDataCard.cardIssuingCurrency) && Objects.equals(this.cardPaymentMethod, responseAdditionalDataCard.cardPaymentMethod) && Objects.equals(this.cardSummary, responseAdditionalDataCard.cardSummary) && Objects.equals(this.issuerBin, responseAdditionalDataCard.issuerBin);
    }

    public int hashCode() {
        return Objects.hash(this.cardBin, this.cardHolderName, this.cardIssuingBank, this.cardIssuingCountry, this.cardIssuingCurrency, this.cardPaymentMethod, this.cardSummary, this.issuerBin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseAdditionalDataCard {\n");
        sb.append("    cardBin: ").append(this.toIndentedString(this.cardBin)).append("\n");
        sb.append("    cardHolderName: ").append(this.toIndentedString(this.cardHolderName)).append("\n");
        sb.append("    cardIssuingBank: ").append(this.toIndentedString(this.cardIssuingBank)).append("\n");
        sb.append("    cardIssuingCountry: ").append(this.toIndentedString(this.cardIssuingCountry)).append("\n");
        sb.append("    cardIssuingCurrency: ").append(this.toIndentedString(this.cardIssuingCurrency)).append("\n");
        sb.append("    cardPaymentMethod: ").append(this.toIndentedString(this.cardPaymentMethod)).append("\n");
        sb.append("    cardSummary: ").append(this.toIndentedString(this.cardSummary)).append("\n");
        sb.append("    issuerBin: ").append(this.toIndentedString(this.issuerBin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ResponseAdditionalDataCard is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ResponseAdditionalDataCard` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_BIN) != null && !jsonObj.get(SERIALIZED_NAME_CARD_BIN).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cardBin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_BIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_HOLDER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_CARD_HOLDER_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cardHolderName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_HOLDER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_ISSUING_BANK) != null && !jsonObj.get(SERIALIZED_NAME_CARD_ISSUING_BANK).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cardIssuingBank` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_ISSUING_BANK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_ISSUING_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_CARD_ISSUING_COUNTRY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cardIssuingCountry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_ISSUING_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_ISSUING_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CARD_ISSUING_CURRENCY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cardIssuingCurrency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_ISSUING_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_PAYMENT_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_CARD_PAYMENT_METHOD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cardPaymentMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_PAYMENT_METHOD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_SUMMARY) != null && !jsonObj.get(SERIALIZED_NAME_CARD_SUMMARY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cardSummary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_SUMMARY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER_BIN) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER_BIN).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `issuerBin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER_BIN).toString()));
        }
    }

    public static ResponseAdditionalDataCard fromJson(String jsonString) throws IOException {
        return (ResponseAdditionalDataCard)JSON.getGson().fromJson(jsonString, ResponseAdditionalDataCard.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CARD_BIN);
        openapiFields.add(SERIALIZED_NAME_CARD_HOLDER_NAME);
        openapiFields.add(SERIALIZED_NAME_CARD_ISSUING_BANK);
        openapiFields.add(SERIALIZED_NAME_CARD_ISSUING_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_CARD_ISSUING_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_CARD_PAYMENT_METHOD);
        openapiFields.add(SERIALIZED_NAME_CARD_SUMMARY);
        openapiFields.add(SERIALIZED_NAME_ISSUER_BIN);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ResponseAdditionalDataCard.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ResponseAdditionalDataCard.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ResponseAdditionalDataCard.class));
            return new TypeAdapter<ResponseAdditionalDataCard>(){

                public void write(JsonWriter out, ResponseAdditionalDataCard value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ResponseAdditionalDataCard read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ResponseAdditionalDataCard.validateJsonObject(jsonObj);
                    return (ResponseAdditionalDataCard)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

