/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.AbstractOpenApiSchema;
import com.adyen.model.balanceplatform.IbanAccountIdentification;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.USLocalAccountIdentification;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PaymentInstrumentBankAccount
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(PaymentInstrumentBankAccount.class.getName());
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public PaymentInstrumentBankAccount() {
        super("oneOf", Boolean.FALSE);
    }

    public PaymentInstrumentBankAccount(IbanAccountIdentification o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public PaymentInstrumentBankAccount(USLocalAccountIdentification o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof IbanAccountIdentification) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof USLocalAccountIdentification) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be IbanAccountIdentification, USLocalAccountIdentification");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public IbanAccountIdentification getIbanAccountIdentification() throws ClassCastException {
        return (IbanAccountIdentification)super.getActualInstance();
    }

    public USLocalAccountIdentification getUSLocalAccountIdentification() throws ClassCastException {
        return (USLocalAccountIdentification)super.getActualInstance();
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            Logger.getLogger(IbanAccountIdentification.class.getName()).setLevel(Level.OFF);
            IbanAccountIdentification.validateJsonObject(jsonObj);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for IbanAccountIdentification failed with `%s`.", e.getMessage()));
        }
        try {
            Logger.getLogger(USLocalAccountIdentification.class.getName()).setLevel(Level.OFF);
            USLocalAccountIdentification.validateJsonObject(jsonObj);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for USLocalAccountIdentification failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for PaymentInstrumentBankAccount with oneOf schemas: IbanAccountIdentification, USLocalAccountIdentification. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonObj.toString()));
        }
    }

    public static PaymentInstrumentBankAccount fromJson(String jsonString) throws IOException {
        return (PaymentInstrumentBankAccount)JSON.getGson().fromJson(jsonString, PaymentInstrumentBankAccount.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("IbanAccountIdentification", (GenericType)new GenericType<IbanAccountIdentification>(){});
        schemas.put("USLocalAccountIdentification", (GenericType)new GenericType<USLocalAccountIdentification>(){});
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentInstrumentBankAccount.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterIbanAccountIdentification = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IbanAccountIdentification.class));
            final TypeAdapter adapterUSLocalAccountIdentification = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(USLocalAccountIdentification.class));
            return new TypeAdapter<PaymentInstrumentBankAccount>(){

                public void write(JsonWriter out, PaymentInstrumentBankAccount value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof IbanAccountIdentification) {
                        JsonObject obj = adapterIbanAccountIdentification.toJsonTree((Object)((IbanAccountIdentification)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    if (value.getActualInstance() instanceof USLocalAccountIdentification) {
                        JsonObject obj = adapterUSLocalAccountIdentification.toJsonTree((Object)((USLocalAccountIdentification)value.getActualInstance())).getAsJsonObject();
                        elementAdapter.write(out, (Object)obj);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: IbanAccountIdentification, USLocalAccountIdentification");
                }

                public PaymentInstrumentBankAccount read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonObject jsonObject = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        IbanAccountIdentification.validateJsonObject(jsonObject);
                        actualAdapter = adapterIbanAccountIdentification;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'IbanAccountIdentification'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for IbanAccountIdentification failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'IbanAccountIdentification'", e);
                    }
                    try {
                        USLocalAccountIdentification.validateJsonObject(jsonObject);
                        actualAdapter = adapterUSLocalAccountIdentification;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'USLocalAccountIdentification'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for USLocalAccountIdentification failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'USLocalAccountIdentification'", e);
                    }
                    if (match == 1) {
                        PaymentInstrumentBankAccount ret = new PaymentInstrumentBankAccount();
                        ret.setActualInstance(actualAdapter.fromJsonTree((JsonElement)jsonObject));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for PaymentInstrumentBankAccount: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonObject.toString()));
                }
            }.nullSafe();
        }
    }
}

