/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.Amount;
import com.adyen.model.payment.JSON;
import com.adyen.model.payment.PlatformChargebackLogic;
import com.adyen.model.payment.Split;
import com.adyen.model.payment.ThreeDSecureData;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CaptureRequest {
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_MODIFICATION_AMOUNT = "modificationAmount";
    @SerializedName(value="modificationAmount")
    private Amount modificationAmount;
    public static final String SERIALIZED_NAME_MPI_DATA = "mpiData";
    @SerializedName(value="mpiData")
    private ThreeDSecureData mpiData;
    public static final String SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE = "originalMerchantReference";
    @SerializedName(value="originalMerchantReference")
    private String originalMerchantReference;
    public static final String SERIALIZED_NAME_ORIGINAL_REFERENCE = "originalReference";
    @SerializedName(value="originalReference")
    private String originalReference;
    public static final String SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    @SerializedName(value="platformChargebackLogic")
    private PlatformChargebackLogic platformChargebackLogic;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SPLITS = "splits";
    @SerializedName(value="splits")
    private List<Split> splits = null;
    public static final String SERIALIZED_NAME_TENDER_REFERENCE = "tenderReference";
    @SerializedName(value="tenderReference")
    private String tenderReference;
    public static final String SERIALIZED_NAME_UNIQUE_TERMINAL_ID = "uniqueTerminalId";
    @SerializedName(value="uniqueTerminalId")
    private String uniqueTerminalId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CaptureRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public CaptureRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular modification request.  The additionalData object consists of entries, each of which includes the key and value.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public CaptureRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account that is used to process the payment.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CaptureRequest modificationAmount(Amount modificationAmount) {
        this.modificationAmount = modificationAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getModificationAmount() {
        return this.modificationAmount;
    }

    public void setModificationAmount(Amount modificationAmount) {
        this.modificationAmount = modificationAmount;
    }

    public CaptureRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public CaptureRequest originalMerchantReference(String originalMerchantReference) {
        this.originalMerchantReference = originalMerchantReference;
        return this;
    }

    @ApiModelProperty(value="The original merchant reference to cancel.")
    public String getOriginalMerchantReference() {
        return this.originalMerchantReference;
    }

    public void setOriginalMerchantReference(String originalMerchantReference) {
        this.originalMerchantReference = originalMerchantReference;
    }

    public CaptureRequest originalReference(String originalReference) {
        this.originalReference = originalReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The original pspReference of the payment to modify. This reference is returned in: * authorisation response * authorisation notification  ")
    public String getOriginalReference() {
        return this.originalReference;
    }

    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
    }

    public CaptureRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        return this;
    }

    @ApiModelProperty(value="")
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
    }

    public CaptureRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public CaptureRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public CaptureRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="An array of objects specifying how the amount should be split between accounts when using Adyen for Platforms. For details, refer to [Providing split information](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information).")
    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public CaptureRequest tenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
        return this;
    }

    @ApiModelProperty(value="The transaction reference provided by the PED. For point-of-sale integrations only.")
    public String getTenderReference() {
        return this.tenderReference;
    }

    public void setTenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
    }

    public CaptureRequest uniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
        return this;
    }

    @ApiModelProperty(value="Unique terminal ID for the PED that originally processed the request. For point-of-sale integrations only.")
    public String getUniqueTerminalId() {
        return this.uniqueTerminalId;
    }

    public void setUniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaptureRequest captureRequest = (CaptureRequest)o;
        return Objects.equals(this.additionalData, captureRequest.additionalData) && Objects.equals(this.merchantAccount, captureRequest.merchantAccount) && Objects.equals(this.modificationAmount, captureRequest.modificationAmount) && Objects.equals(this.mpiData, captureRequest.mpiData) && Objects.equals(this.originalMerchantReference, captureRequest.originalMerchantReference) && Objects.equals(this.originalReference, captureRequest.originalReference) && Objects.equals(this.platformChargebackLogic, captureRequest.platformChargebackLogic) && Objects.equals(this.reference, captureRequest.reference) && Objects.equals(this.splits, captureRequest.splits) && Objects.equals(this.tenderReference, captureRequest.tenderReference) && Objects.equals(this.uniqueTerminalId, captureRequest.uniqueTerminalId);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.merchantAccount, this.modificationAmount, this.mpiData, this.originalMerchantReference, this.originalReference, this.platformChargebackLogic, this.reference, this.splits, this.tenderReference, this.uniqueTerminalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaptureRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    modificationAmount: ").append(this.toIndentedString(this.modificationAmount)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    originalMerchantReference: ").append(this.toIndentedString(this.originalMerchantReference)).append("\n");
        sb.append("    originalReference: ").append(this.toIndentedString(this.originalReference)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    tenderReference: ").append(this.toIndentedString(this.tenderReference)).append("\n");
        sb.append("    uniqueTerminalId: ").append(this.toIndentedString(this.uniqueTerminalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CaptureRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CaptureRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MODIFICATION_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MODIFICATION_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MPI_DATA) != null) {
            ThreeDSecureData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MPI_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `originalMerchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIGINAL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_ORIGINAL_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `originalReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIGINAL_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC) != null) {
            PlatformChargebackLogic.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        JsonArray jsonArraysplits = jsonObj.getAsJsonArray(SERIALIZED_NAME_SPLITS);
        if (jsonArraysplits != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SPLITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `splits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPLITS).toString()));
            }
            for (int i = 0; i < jsonArraysplits.size(); ++i) {
                Split.validateJsonObject(jsonArraysplits.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TENDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_TENDER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tenderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TENDER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNIQUE_TERMINAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_UNIQUE_TERMINAL_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uniqueTerminalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNIQUE_TERMINAL_ID).toString()));
        }
    }

    public static CaptureRequest fromJson(String jsonString) throws IOException {
        return (CaptureRequest)JSON.getGson().fromJson(jsonString, CaptureRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MODIFICATION_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_MPI_DATA);
        openapiFields.add(SERIALIZED_NAME_ORIGINAL_MERCHANT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_ORIGINAL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_PLATFORM_CHARGEBACK_LOGIC);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SPLITS);
        openapiFields.add(SERIALIZED_NAME_TENDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_UNIQUE_TERMINAL_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_MODIFICATION_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_ORIGINAL_REFERENCE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CaptureRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CaptureRequest.class));
            return new TypeAdapter<CaptureRequest>(){

                public void write(JsonWriter out, CaptureRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CaptureRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CaptureRequest.validateJsonObject(jsonObj);
                    return (CaptureRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

