/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TestOutput {
    public static final String SERIALIZED_NAME_MERCHANT_ID = "merchantId";
    @SerializedName(value="merchantId")
    private String merchantId;
    public static final String SERIALIZED_NAME_OUTPUT = "output";
    @SerializedName(value="output")
    private String output;
    public static final String SERIALIZED_NAME_REQUEST_SENT = "requestSent";
    @SerializedName(value="requestSent")
    private String requestSent;
    public static final String SERIALIZED_NAME_RESPONSE_CODE = "responseCode";
    @SerializedName(value="responseCode")
    private String responseCode;
    public static final String SERIALIZED_NAME_RESPONSE_TIME = "responseTime";
    @SerializedName(value="responseTime")
    private String responseTime;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TestOutput merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the merchant account that the notification is about.")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public TestOutput output(String output) {
        this.output = output;
        return this;
    }

    @ApiModelProperty(value="The response your server returned for the test webhook.  Your server must respond with **[accepted]** for the test webhook to be successful (`data.status`: **success**). Find out more about [accepting notifications](https://docs.adyen.com/development-resources/webhooks#accept-notifications)  You can use the value of this field together with the [`responseCode`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/merchants/{merchantId}/webhooks/{id}/test__resParam_data-responseCode) value to troubleshoot unsuccessful test webhooks.")
    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public TestOutput requestSent(String requestSent) {
        this.requestSent = requestSent;
        return this;
    }

    @ApiModelProperty(value="The [body of the notification webhook](https://docs.adyen.com/development-resources/webhooks/understand-notifications#notification-structure) that was sent to your server.")
    public String getRequestSent() {
        return this.requestSent;
    }

    public void setRequestSent(String requestSent) {
        this.requestSent = requestSent;
    }

    public TestOutput responseCode(String responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    @ApiModelProperty(example="200", value="The HTTP response code for your server's response to the test webhook.  You can use the value of this field together with the the [`output`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/merchants/{merchantId}/webhooks/{id}/test__resParam_data-output) field value to troubleshoot failed test webhooks.")
    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }

    public TestOutput responseTime(String responseTime) {
        this.responseTime = responseTime;
        return this;
    }

    @ApiModelProperty(value="The time between sending the test webhook and receiving the response from your server. You can use it as an indication of how long your server takes to process a webhook notification. Measured in milliseconds, for example **304 ms**.")
    public String getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(String responseTime) {
        this.responseTime = responseTime;
    }

    public TestOutput status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the test request. Possible values are: * **success**, if `data.output`: **[accepted]** and `data.responseCode`: **200**. * **failed**, in all other cases.  You can use the value of the [`output`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/merchants/{merchantId}/webhooks/{id}/test__resParam_data-output) field together with the [`responseCode`](https://docs.adyen.com/api-explorer/#/ManagementService/v1/post/merchants/{merchantId}/webhooks/{id}/test__resParam_data-responseCode) value to troubleshoot failed test webhooks.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestOutput testOutput = (TestOutput)o;
        return Objects.equals(this.merchantId, testOutput.merchantId) && Objects.equals(this.output, testOutput.output) && Objects.equals(this.requestSent, testOutput.requestSent) && Objects.equals(this.responseCode, testOutput.responseCode) && Objects.equals(this.responseTime, testOutput.responseTime) && Objects.equals(this.status, testOutput.status);
    }

    public int hashCode() {
        return Objects.hash(this.merchantId, this.output, this.requestSent, this.responseCode, this.responseTime, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestOutput {\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        sb.append("    requestSent: ").append(this.toIndentedString(this.requestSent)).append("\n");
        sb.append("    responseCode: ").append(this.toIndentedString(this.responseCode)).append("\n");
        sb.append("    responseTime: ").append(this.toIndentedString(this.responseTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in TestOutput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TestOutput` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ID) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OUTPUT) != null && !jsonObj.get(SERIALIZED_NAME_OUTPUT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `output` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OUTPUT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUEST_SENT) != null && !jsonObj.get(SERIALIZED_NAME_REQUEST_SENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `requestSent` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUEST_SENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESPONSE_CODE) != null && !jsonObj.get(SERIALIZED_NAME_RESPONSE_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `responseCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESPONSE_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESPONSE_TIME) != null && !jsonObj.get(SERIALIZED_NAME_RESPONSE_TIME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `responseTime` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESPONSE_TIME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
    }

    public static TestOutput fromJson(String jsonString) throws IOException {
        return (TestOutput)JSON.getGson().fromJson(jsonString, TestOutput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ID);
        openapiFields.add(SERIALIZED_NAME_OUTPUT);
        openapiFields.add(SERIALIZED_NAME_REQUEST_SENT);
        openapiFields.add(SERIALIZED_NAME_RESPONSE_CODE);
        openapiFields.add(SERIALIZED_NAME_RESPONSE_TIME);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TestOutput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TestOutput.class));
            return new TypeAdapter<TestOutput>(){

                public void write(JsonWriter out, TestOutput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TestOutput read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TestOutput.validateJsonObject(jsonObj);
                    return (TestOutput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

