/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Url;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class NotificationUrl {
    public static final String SERIALIZED_NAME_LOCAL_URLS = "localUrls";
    @SerializedName(value="localUrls")
    private List<Url> localUrls = null;
    public static final String SERIALIZED_NAME_PUBLIC_URLS = "publicUrls";
    @SerializedName(value="publicUrls")
    private List<Url> publicUrls = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public NotificationUrl localUrls(List<Url> localUrls) {
        this.localUrls = localUrls;
        return this;
    }

    public NotificationUrl addLocalUrlsItem(Url localUrlsItem) {
        if (this.localUrls == null) {
            this.localUrls = new ArrayList<Url>();
        }
        this.localUrls.add(localUrlsItem);
        return this;
    }

    @ApiModelProperty(value="One or more local URLs to send notifications to when using Terminal API.")
    public List<Url> getLocalUrls() {
        return this.localUrls;
    }

    public void setLocalUrls(List<Url> localUrls) {
        this.localUrls = localUrls;
    }

    public NotificationUrl publicUrls(List<Url> publicUrls) {
        this.publicUrls = publicUrls;
        return this;
    }

    public NotificationUrl addPublicUrlsItem(Url publicUrlsItem) {
        if (this.publicUrls == null) {
            this.publicUrls = new ArrayList<Url>();
        }
        this.publicUrls.add(publicUrlsItem);
        return this;
    }

    @ApiModelProperty(value="One or more public URLs to send notifications to when using Terminal API.")
    public List<Url> getPublicUrls() {
        return this.publicUrls;
    }

    public void setPublicUrls(List<Url> publicUrls) {
        this.publicUrls = publicUrls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationUrl notificationUrl = (NotificationUrl)o;
        return Objects.equals(this.localUrls, notificationUrl.localUrls) && Objects.equals(this.publicUrls, notificationUrl.publicUrls);
    }

    public int hashCode() {
        return Objects.hash(this.localUrls, this.publicUrls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationUrl {\n");
        sb.append("    localUrls: ").append(this.toIndentedString(this.localUrls)).append("\n");
        sb.append("    publicUrls: ").append(this.toIndentedString(this.publicUrls)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraypublicUrls;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in NotificationUrl is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `NotificationUrl` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        JsonArray jsonArraylocalUrls = jsonObj.getAsJsonArray(SERIALIZED_NAME_LOCAL_URLS);
        if (jsonArraylocalUrls != null) {
            if (!jsonObj.get(SERIALIZED_NAME_LOCAL_URLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `localUrls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOCAL_URLS).toString()));
            }
            for (int i = 0; i < jsonArraylocalUrls.size(); ++i) {
                Url.validateJsonObject(jsonArraylocalUrls.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraypublicUrls = jsonObj.getAsJsonArray(SERIALIZED_NAME_PUBLIC_URLS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PUBLIC_URLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `publicUrls` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PUBLIC_URLS).toString()));
            }
            for (int i = 0; i < jsonArraypublicUrls.size(); ++i) {
                Url.validateJsonObject(jsonArraypublicUrls.get(i).getAsJsonObject());
            }
        }
    }

    public static NotificationUrl fromJson(String jsonString) throws IOException {
        return (NotificationUrl)JSON.getGson().fromJson(jsonString, NotificationUrl.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LOCAL_URLS);
        openapiFields.add(SERIALIZED_NAME_PUBLIC_URLS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!NotificationUrl.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(NotificationUrl.class));
            return new TypeAdapter<NotificationUrl>(){

                public void write(JsonWriter out, NotificationUrl value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public NotificationUrl read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    NotificationUrl.validateJsonObject(jsonObj);
                    return (NotificationUrl)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

