/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GooglePayInfo {
    public static final String SERIALIZED_NAME_MERCHANT_ID = "merchantId";
    @SerializedName(value="merchantId")
    private String merchantId;
    public static final String SERIALIZED_NAME_REUSE_MERCHANT_ID = "reuseMerchantId";
    @SerializedName(value="reuseMerchantId")
    private Boolean reuseMerchantId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GooglePayInfo merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(required=true, value="Google Pay [Merchant ID](https://support.google.com/paymentscenter/answer/7163092?hl=en). Character length and limitations: 16 alphanumeric characters or 20 numeric characters.")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public GooglePayInfo reuseMerchantId(Boolean reuseMerchantId) {
        this.reuseMerchantId = reuseMerchantId;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the Google Pay Merchant ID is used for several merchant accounts. Default value: **false**.")
    public Boolean getReuseMerchantId() {
        return this.reuseMerchantId;
    }

    public void setReuseMerchantId(Boolean reuseMerchantId) {
        this.reuseMerchantId = reuseMerchantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GooglePayInfo googlePayInfo = (GooglePayInfo)o;
        return Objects.equals(this.merchantId, googlePayInfo.merchantId) && Objects.equals(this.reuseMerchantId, googlePayInfo.reuseMerchantId);
    }

    public int hashCode() {
        return Objects.hash(this.merchantId, this.reuseMerchantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GooglePayInfo {\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    reuseMerchantId: ").append(this.toIndentedString(this.reuseMerchantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GooglePayInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GooglePayInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ID) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).toString()));
        }
    }

    public static GooglePayInfo fromJson(String jsonString) throws IOException {
        return (GooglePayInfo)JSON.getGson().fromJson(jsonString, GooglePayInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ID);
        openapiFields.add(SERIALIZED_NAME_REUSE_MERCHANT_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GooglePayInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(GooglePayInfo.class));
            return new TypeAdapter<GooglePayInfo>(){

                public void write(JsonWriter out, GooglePayInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public GooglePayInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GooglePayInfo.validateJsonObject(jsonObj);
                    return (GooglePayInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

