/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AllowedOrigin;
import com.adyen.model.management.ApiCredentialLinks;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CreateApiCredentialResponse {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private ApiCredentialLinks links;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_ALLOWED_IP_ADDRESSES = "allowedIpAddresses";
    @SerializedName(value="allowedIpAddresses")
    private List<String> allowedIpAddresses = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ALLOWED_ORIGINS = "allowedOrigins";
    @SerializedName(value="allowedOrigins")
    private List<AllowedOrigin> allowedOrigins = null;
    public static final String SERIALIZED_NAME_API_KEY = "apiKey";
    @SerializedName(value="apiKey")
    private String apiKey;
    public static final String SERIALIZED_NAME_CLIENT_KEY = "clientKey";
    @SerializedName(value="clientKey")
    private String clientKey;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_ROLES = "roles";
    @SerializedName(value="roles")
    private List<String> roles = new ArrayList<String>();
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateApiCredentialResponse links(ApiCredentialLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public ApiCredentialLinks getLinks() {
        return this.links;
    }

    public void setLinks(ApiCredentialLinks links) {
        this.links = links;
    }

    public CreateApiCredentialResponse active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the API credential is enabled. Must be set to **true** to use the credential in your integration.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public CreateApiCredentialResponse allowedIpAddresses(List<String> allowedIpAddresses) {
        this.allowedIpAddresses = allowedIpAddresses;
        return this;
    }

    public CreateApiCredentialResponse addAllowedIpAddressesItem(String allowedIpAddressesItem) {
        this.allowedIpAddresses.add(allowedIpAddressesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of IP addresses from which your client can make requests.  If the list is empty, we allow requests from any IP. If the list is not empty and we get a request from an IP which is not on the list, you get a security error.")
    public List<String> getAllowedIpAddresses() {
        return this.allowedIpAddresses;
    }

    public void setAllowedIpAddresses(List<String> allowedIpAddresses) {
        this.allowedIpAddresses = allowedIpAddresses;
    }

    public CreateApiCredentialResponse allowedOrigins(List<AllowedOrigin> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public CreateApiCredentialResponse addAllowedOriginsItem(AllowedOrigin allowedOriginsItem) {
        if (this.allowedOrigins == null) {
            this.allowedOrigins = new ArrayList<AllowedOrigin>();
        }
        this.allowedOrigins.add(allowedOriginsItem);
        return this;
    }

    @ApiModelProperty(value="List containing the [allowed origins](https://docs.adyen.com/development-resources/client-side-authentication#allowed-origins) linked to the API credential.")
    public List<AllowedOrigin> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List<AllowedOrigin> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public CreateApiCredentialResponse apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @ApiModelProperty(required=true, value="The API key for the API credential that was created.")
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public CreateApiCredentialResponse clientKey(String clientKey) {
        this.clientKey = clientKey;
        return this;
    }

    @ApiModelProperty(required=true, value="Public key used for [client-side authentication](https://docs.adyen.com/development-resources/client-side-authentication). The client key is required for Drop-in and Components integrations.")
    public String getClientKey() {
        return this.clientKey;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public CreateApiCredentialResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the API credential.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateApiCredentialResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the API credential.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CreateApiCredentialResponse password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(required=true, value="The password for the API credential that was created.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CreateApiCredentialResponse roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public CreateApiCredentialResponse addRolesItem(String rolesItem) {
        this.roles.add(rolesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of [roles](https://docs.adyen.com/development-resources/api-credentials#roles-1) for the API credential.")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public CreateApiCredentialResponse username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the [API credential](https://docs.adyen.com/development-resources/api-credentials), for example **ws@Company.TestCompany**.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateApiCredentialResponse createApiCredentialResponse = (CreateApiCredentialResponse)o;
        return Objects.equals(this.links, createApiCredentialResponse.links) && Objects.equals(this.active, createApiCredentialResponse.active) && Objects.equals(this.allowedIpAddresses, createApiCredentialResponse.allowedIpAddresses) && Objects.equals(this.allowedOrigins, createApiCredentialResponse.allowedOrigins) && Objects.equals(this.apiKey, createApiCredentialResponse.apiKey) && Objects.equals(this.clientKey, createApiCredentialResponse.clientKey) && Objects.equals(this.description, createApiCredentialResponse.description) && Objects.equals(this.id, createApiCredentialResponse.id) && Objects.equals(this.password, createApiCredentialResponse.password) && Objects.equals(this.roles, createApiCredentialResponse.roles) && Objects.equals(this.username, createApiCredentialResponse.username);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.active, this.allowedIpAddresses, this.allowedOrigins, this.apiKey, this.clientKey, this.description, this.id, this.password, this.roles, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateApiCredentialResponse {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    allowedIpAddresses: ").append(this.toIndentedString(this.allowedIpAddresses)).append("\n");
        sb.append("    allowedOrigins: ").append(this.toIndentedString(this.allowedOrigins)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    clientKey: ").append(this.toIndentedString(this.clientKey)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateApiCredentialResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateApiCredentialResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS) != null) {
            ApiCredentialLinks.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowedIpAddresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES).toString()));
        }
        JsonArray jsonArrayallowedOrigins = jsonObj.getAsJsonArray(SERIALIZED_NAME_ALLOWED_ORIGINS);
        if (jsonArrayallowedOrigins != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ALLOWED_ORIGINS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `allowedOrigins` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_ORIGINS).toString()));
            }
            for (int i = 0; i < jsonArrayallowedOrigins.size(); ++i) {
                AllowedOrigin.validateJsonObject(jsonArrayallowedOrigins.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_API_KEY) != null && !jsonObj.get(SERIALIZED_NAME_API_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `clientKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_ROLES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `roles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
    }

    public static CreateApiCredentialResponse fromJson(String jsonString) throws IOException {
        return (CreateApiCredentialResponse)JSON.getGson().fromJson(jsonString, CreateApiCredentialResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_ALLOWED_ORIGINS);
        openapiFields.add(SERIALIZED_NAME_API_KEY);
        openapiFields.add(SERIALIZED_NAME_CLIENT_KEY);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_ROLES);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACTIVE);
        openapiRequiredFields.add(SERIALIZED_NAME_ALLOWED_IP_ADDRESSES);
        openapiRequiredFields.add(SERIALIZED_NAME_API_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_CLIENT_KEY);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PASSWORD);
        openapiRequiredFields.add(SERIALIZED_NAME_ROLES);
        openapiRequiredFields.add(SERIALIZED_NAME_USERNAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateApiCredentialResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateApiCredentialResponse.class));
            return new TypeAdapter<CreateApiCredentialResponse>(){

                public void write(JsonWriter out, CreateApiCredentialResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateApiCredentialResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateApiCredentialResponse.validateJsonObject(jsonObj);
                    return (CreateApiCredentialResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

