/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class StockData {
    public static final String SERIALIZED_NAME_MARKET_IDENTIFIER = "marketIdentifier";
    @SerializedName(value="marketIdentifier")
    private String marketIdentifier;
    public static final String SERIALIZED_NAME_STOCK_NUMBER = "stockNumber";
    @SerializedName(value="stockNumber")
    private String stockNumber;
    public static final String SERIALIZED_NAME_TICKER_SYMBOL = "tickerSymbol";
    @SerializedName(value="tickerSymbol")
    private String tickerSymbol;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public StockData marketIdentifier(String marketIdentifier) {
        this.marketIdentifier = marketIdentifier;
        return this;
    }

    @ApiModelProperty(value="The four-digit [Market Identifier Code](https://en.wikipedia.org/wiki/Market_Identifier_Code) of the stock market where the organization's stocks are traded.")
    public String getMarketIdentifier() {
        return this.marketIdentifier;
    }

    public void setMarketIdentifier(String marketIdentifier) {
        this.marketIdentifier = marketIdentifier;
    }

    public StockData stockNumber(String stockNumber) {
        this.stockNumber = stockNumber;
        return this;
    }

    @ApiModelProperty(value="The 12-digit International Securities Identification Number (ISIN) of the company, without dashes (-).")
    public String getStockNumber() {
        return this.stockNumber;
    }

    public void setStockNumber(String stockNumber) {
        this.stockNumber = stockNumber;
    }

    public StockData tickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
        return this;
    }

    @ApiModelProperty(value="The stock ticker symbol.")
    public String getTickerSymbol() {
        return this.tickerSymbol;
    }

    public void setTickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StockData stockData = (StockData)o;
        return Objects.equals(this.marketIdentifier, stockData.marketIdentifier) && Objects.equals(this.stockNumber, stockData.stockNumber) && Objects.equals(this.tickerSymbol, stockData.tickerSymbol);
    }

    public int hashCode() {
        return Objects.hash(this.marketIdentifier, this.stockNumber, this.tickerSymbol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StockData {\n");
        sb.append("    marketIdentifier: ").append(this.toIndentedString(this.marketIdentifier)).append("\n");
        sb.append("    stockNumber: ").append(this.toIndentedString(this.stockNumber)).append("\n");
        sb.append("    tickerSymbol: ").append(this.toIndentedString(this.tickerSymbol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in StockData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `StockData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MARKET_IDENTIFIER) != null && !jsonObj.get(SERIALIZED_NAME_MARKET_IDENTIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `marketIdentifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MARKET_IDENTIFIER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STOCK_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_STOCK_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `stockNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STOCK_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TICKER_SYMBOL) != null && !jsonObj.get(SERIALIZED_NAME_TICKER_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `tickerSymbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TICKER_SYMBOL).toString()));
        }
    }

    public static StockData fromJson(String jsonString) throws IOException {
        return (StockData)JSON.getGson().fromJson(jsonString, StockData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MARKET_IDENTIFIER);
        openapiFields.add(SERIALIZED_NAME_STOCK_NUMBER);
        openapiFields.add(SERIALIZED_NAME_TICKER_SYMBOL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StockData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StockData.class));
            return new TypeAdapter<StockData>(){

                public void write(JsonWriter out, StockData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public StockData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    StockData.validateJsonObject(jsonObj);
                    return (StockData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

