/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CALocalAccountIdentification {
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "accountNumber";
    @SerializedName(value="accountNumber")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "accountType";
    @SerializedName(value="accountType")
    private AccountTypeEnum accountType = AccountTypeEnum.CHECKING;
    public static final String SERIALIZED_NAME_INSTITUTION_NUMBER = "institutionNumber";
    @SerializedName(value="institutionNumber")
    private String institutionNumber;
    public static final String SERIALIZED_NAME_TRANSIT_NUMBER = "transitNumber";
    @SerializedName(value="transitNumber")
    private String transitNumber;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.CALOCAL;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CALocalAccountIdentification accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The 5- to 12-digit bank account number, without separators or whitespace.")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public CALocalAccountIdentification accountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(value="The bank account type.  Possible values: **checking** or **savings**. Defaults to **checking**.")
    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public CALocalAccountIdentification institutionNumber(String institutionNumber) {
        this.institutionNumber = institutionNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The 3-digit institution number, without separators or whitespace.")
    public String getInstitutionNumber() {
        return this.institutionNumber;
    }

    public void setInstitutionNumber(String institutionNumber) {
        this.institutionNumber = institutionNumber;
    }

    public CALocalAccountIdentification transitNumber(String transitNumber) {
        this.transitNumber = transitNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The 5-digit transit number, without separators or whitespace.")
    public String getTransitNumber() {
        return this.transitNumber;
    }

    public void setTransitNumber(String transitNumber) {
        this.transitNumber = transitNumber;
    }

    public CALocalAccountIdentification type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="**caLocal**")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CALocalAccountIdentification caLocalAccountIdentification = (CALocalAccountIdentification)o;
        return Objects.equals(this.accountNumber, caLocalAccountIdentification.accountNumber) && Objects.equals((Object)this.accountType, (Object)caLocalAccountIdentification.accountType) && Objects.equals(this.institutionNumber, caLocalAccountIdentification.institutionNumber) && Objects.equals(this.transitNumber, caLocalAccountIdentification.transitNumber) && Objects.equals((Object)this.type, (Object)caLocalAccountIdentification.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.accountType, this.institutionNumber, this.transitNumber, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CALocalAccountIdentification {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    institutionNumber: ").append(this.toIndentedString(this.institutionNumber)).append("\n");
        sb.append("    transitNumber: ").append(this.toIndentedString(this.transitNumber)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CALocalAccountIdentification is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CALocalAccountIdentification` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accountNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `accountType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).toString()));
            }
            AccountTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_INSTITUTION_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_INSTITUTION_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `institutionNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INSTITUTION_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSIT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_TRANSIT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transitNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSIT_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static CALocalAccountIdentification fromJson(String jsonString) throws IOException {
        return (CALocalAccountIdentification)JSON.getGson().fromJson(jsonString, CALocalAccountIdentification.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_INSTITUTION_NUMBER);
        openapiFields.add(SERIALIZED_NAME_TRANSIT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_INSTITUTION_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_TRANSIT_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CALocalAccountIdentification.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CALocalAccountIdentification.class));
            return new TypeAdapter<CALocalAccountIdentification>(){

                public void write(JsonWriter out, CALocalAccountIdentification value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CALocalAccountIdentification read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CALocalAccountIdentification.validateJsonObject(jsonObj);
                    return (CALocalAccountIdentification)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        CALOCAL("caLocal");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AccountTypeEnum {
        CHECKING("checking"),
        SAVINGS("savings");

        private String value;

        private AccountTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccountTypeEnum fromValue(String value) {
            for (AccountTypeEnum b : AccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AccountTypeEnum> {
            public void write(JsonWriter jsonWriter, AccountTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AccountTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AccountTypeEnum.fromValue(value);
            }
        }
    }
}

