/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PaymentDetails {
    public static final String SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    @SerializedName(value="checkoutAttemptId")
    private String checkoutAttemptId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaymentDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public PaymentDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The payment method type.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentDetails paymentDetails = (PaymentDetails)o;
        return Objects.equals(this.checkoutAttemptId, paymentDetails.checkoutAttemptId) && Objects.equals((Object)this.type, (Object)paymentDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkoutAttemptId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentDetails {\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentDetails is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PaymentDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID) != null && !jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `checkoutAttemptId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static PaymentDetails fromJson(String jsonString) throws IOException {
        return (PaymentDetails)JSON.getGson().fromJson(jsonString, PaymentDetails.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentDetails.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentDetails.class));
            return new TypeAdapter<PaymentDetails>(){

                public void write(JsonWriter out, PaymentDetails value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentDetails read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentDetails.validateJsonObject(jsonObj);
                    return (PaymentDetails)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ALIPAY("alipay"),
        MULTIBANCO("multibanco"),
        BANKTRANSFER_IBAN("bankTransfer_IBAN"),
        PAYBRIGHT("paybright"),
        PAYNOW("paynow"),
        AFFIRM("affirm"),
        AFFIRM_POS("affirm_pos"),
        TRUSTLY("trustly"),
        TRUSTLYVECTOR("trustlyvector"),
        ONEY("oney"),
        FACILYPAY("facilypay"),
        FACILYPAY_3X("facilypay_3x"),
        FACILYPAY_4X("facilypay_4x"),
        FACILYPAY_6X("facilypay_6x"),
        FACILYPAY_10X("facilypay_10x"),
        FACILYPAY_12X("facilypay_12x"),
        UNIONPAY("unionpay"),
        KCP_BANKTRANSFER("kcp_banktransfer"),
        KCP_PAYCO("kcp_payco"),
        KCP_CREDITCARD("kcp_creditcard"),
        WECHATPAYSDK("wechatpaySDK"),
        WECHATPAYQR("wechatpayQR"),
        WECHATPAYWEB("wechatpayWeb"),
        MOLPAY_BOOST("molpay_boost"),
        WALLET_IN("wallet_IN"),
        PAYU_IN_CASHCARD("payu_IN_cashcard"),
        PAYU_IN_NB("payu_IN_nb"),
        UPI_QR("upi_qr"),
        PAYTM("paytm"),
        MOLPAY_EBANKING_VN("molpay_ebanking_VN"),
        PAYBYBANK("paybybank"),
        EBANKING_FI("ebanking_FI"),
        MOLPAY_EBANKING_MY("molpay_ebanking_MY"),
        MOLPAY_EBANKING_DIRECT_MY("molpay_ebanking_direct_MY"),
        SWISH("swish"),
        WALLEY("walley"),
        WALLEY_B2B("walley_b2b"),
        PIX("pix"),
        BIZUM("bizum"),
        ALMA("alma"),
        MOLPAY_FPX("molpay_fpx"),
        KONBINI("konbini"),
        DIRECTEBANKING("directEbanking"),
        BOLETOBANCARIO("boletobancario"),
        NETELLER("neteller"),
        DANA("dana"),
        PAYSAFECARD("paysafecard"),
        CASHTICKET("cashticket"),
        IKANO("ikano"),
        KARENMILLEN("karenmillen"),
        OASIS("oasis"),
        WAREHOUSE("warehouse"),
        PRIMEIROPAY_BOLETO("primeiropay_boleto"),
        MADA("mada"),
        BENEFIT("benefit"),
        KNET("knet"),
        OMANNET("omannet"),
        GOPAY_WALLET("gopay_wallet"),
        POLI("poli"),
        KCP_NAVERPAY("kcp_naverpay"),
        ONLINEBANKING_IN("onlinebanking_IN"),
        FAWRY("fawry"),
        ATOME("atome"),
        MONEYBOOKERS("moneybookers"),
        NAPS("naps"),
        NORDEA("nordea"),
        BOLETOBANCARIO_BRADESCO("boletobancario_bradesco"),
        BOLETOBANCARIO_ITAU("boletobancario_itau"),
        BOLETOBANCARIO_SANTANDER("boletobancario_santander"),
        BOLETOBANCARIO_BANCODOBRASIL("boletobancario_bancodobrasil"),
        BOLETOBANCARIO_HSBC("boletobancario_hsbc"),
        MOLPAY_MAYBANK2U("molpay_maybank2u"),
        MOLPAY_CIMB("molpay_cimb"),
        MOLPAY_RHB("molpay_rhb"),
        MOLPAY_AMB("molpay_amb"),
        MOLPAY_HLB("molpay_hlb"),
        MOLPAY_AFFIN_EPG("molpay_affin_epg"),
        MOLPAY_BANKISLAM("molpay_bankislam"),
        MOLPAY_PUBLICBANK("molpay_publicbank"),
        FPX_AGROBANK("fpx_agrobank"),
        TOUCHNGO("touchngo"),
        MAYBANK2U_MAE("maybank2u_mae"),
        DUITNOW("duitnow"),
        PROMPTPAY("promptpay"),
        ALIPAY_HK("alipay_hk"),
        ALIPAY_HK_WEB("alipay_hk_web"),
        ALIPAY_HK_WAP("alipay_hk_wap"),
        ALIPAY_WAP("alipay_wap"),
        BALANCEPLATFORM("balanceplatform");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

