/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.CardDetails;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.SubMerchant;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FundRecipient {
    public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
    @SerializedName(value="billingAddress")
    private Address billingAddress;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD = "paymentMethod";
    @SerializedName(value="paymentMethod")
    private CardDetails paymentMethod;
    public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
    @SerializedName(value="shopperEmail")
    private String shopperEmail;
    public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
    @SerializedName(value="shopperName")
    private Name shopperName;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static final String SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    @SerializedName(value="storedPaymentMethodId")
    private String storedPaymentMethodId;
    public static final String SERIALIZED_NAME_SUB_MERCHANT = "subMerchant";
    @SerializedName(value="subMerchant")
    private SubMerchant subMerchant;
    public static final String SERIALIZED_NAME_TELEPHONE_NUMBER = "telephoneNumber";
    @SerializedName(value="telephoneNumber")
    private String telephoneNumber;
    public static final String SERIALIZED_NAME_WALLET_IDENTIFIER = "walletIdentifier";
    @SerializedName(value="walletIdentifier")
    private String walletIdentifier;
    public static final String SERIALIZED_NAME_WALLET_OWNER_TAX_ID = "walletOwnerTaxId";
    @SerializedName(value="walletOwnerTaxId")
    private String walletOwnerTaxId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FundRecipient billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public FundRecipient paymentMethod(CardDetails paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="")
    public CardDetails getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(CardDetails paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public FundRecipient shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="the email address of the person")
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public FundRecipient shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public FundRecipient shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public FundRecipient storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public FundRecipient subMerchant(SubMerchant subMerchant) {
        this.subMerchant = subMerchant;
        return this;
    }

    @ApiModelProperty(value="")
    public SubMerchant getSubMerchant() {
        return this.subMerchant;
    }

    public void setSubMerchant(SubMerchant subMerchant) {
        this.subMerchant = subMerchant;
    }

    public FundRecipient telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="the telephone number of the person")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public FundRecipient walletIdentifier(String walletIdentifier) {
        this.walletIdentifier = walletIdentifier;
        return this;
    }

    @ApiModelProperty(value="indicates where the money is going")
    public String getWalletIdentifier() {
        return this.walletIdentifier;
    }

    public void setWalletIdentifier(String walletIdentifier) {
        this.walletIdentifier = walletIdentifier;
    }

    public FundRecipient walletOwnerTaxId(String walletOwnerTaxId) {
        this.walletOwnerTaxId = walletOwnerTaxId;
        return this;
    }

    @ApiModelProperty(value="indicates the tax identifier of the fund recepient")
    public String getWalletOwnerTaxId() {
        return this.walletOwnerTaxId;
    }

    public void setWalletOwnerTaxId(String walletOwnerTaxId) {
        this.walletOwnerTaxId = walletOwnerTaxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FundRecipient fundRecipient = (FundRecipient)o;
        return Objects.equals(this.billingAddress, fundRecipient.billingAddress) && Objects.equals(this.paymentMethod, fundRecipient.paymentMethod) && Objects.equals(this.shopperEmail, fundRecipient.shopperEmail) && Objects.equals(this.shopperName, fundRecipient.shopperName) && Objects.equals(this.shopperReference, fundRecipient.shopperReference) && Objects.equals(this.storedPaymentMethodId, fundRecipient.storedPaymentMethodId) && Objects.equals(this.subMerchant, fundRecipient.subMerchant) && Objects.equals(this.telephoneNumber, fundRecipient.telephoneNumber) && Objects.equals(this.walletIdentifier, fundRecipient.walletIdentifier) && Objects.equals(this.walletOwnerTaxId, fundRecipient.walletOwnerTaxId);
    }

    public int hashCode() {
        return Objects.hash(this.billingAddress, this.paymentMethod, this.shopperEmail, this.shopperName, this.shopperReference, this.storedPaymentMethodId, this.subMerchant, this.telephoneNumber, this.walletIdentifier, this.walletOwnerTaxId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FundRecipient {\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    subMerchant: ").append(this.toIndentedString(this.subMerchant)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    walletIdentifier: ").append(this.toIndentedString(this.walletIdentifier)).append("\n");
        sb.append("    walletOwnerTaxId: ").append(this.toIndentedString(this.walletOwnerTaxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FundRecipient is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FundRecipient` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYMENT_METHOD) != null) {
            CardDetails.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYMENT_METHOD));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID) != null && !jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `storedPaymentMethodId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SUB_MERCHANT) != null) {
            SubMerchant.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SUB_MERCHANT));
        }
        if (jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `telephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WALLET_IDENTIFIER) != null && !jsonObj.get(SERIALIZED_NAME_WALLET_IDENTIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `walletIdentifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WALLET_IDENTIFIER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_WALLET_OWNER_TAX_ID) != null && !jsonObj.get(SERIALIZED_NAME_WALLET_OWNER_TAX_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `walletOwnerTaxId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WALLET_OWNER_TAX_ID).toString()));
        }
    }

    public static FundRecipient fromJson(String jsonString) throws IOException {
        return (FundRecipient)JSON.getGson().fromJson(jsonString, FundRecipient.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BILLING_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_METHOD);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_EMAIL);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_NAME);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID);
        openapiFields.add(SERIALIZED_NAME_SUB_MERCHANT);
        openapiFields.add(SERIALIZED_NAME_TELEPHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_WALLET_IDENTIFIER);
        openapiFields.add(SERIALIZED_NAME_WALLET_OWNER_TAX_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FundRecipient.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FundRecipient.class));
            return new TypeAdapter<FundRecipient>(){

                public void write(JsonWriter out, FundRecipient value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FundRecipient read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FundRecipient.validateJsonObject(jsonObj);
                    return (FundRecipient)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

