/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Split;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CreatePaymentRefundRequest {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_LINE_ITEMS = "lineItems";
    @SerializedName(value="lineItems")
    private List<LineItem> lineItems = null;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_MERCHANT_REFUND_REASON = "merchantRefundReason";
    @SerializedName(value="merchantRefundReason")
    private MerchantRefundReasonEnum merchantRefundReason;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SPLITS = "splits";
    @SerializedName(value="splits")
    private List<Split> splits = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreatePaymentRefundRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CreatePaymentRefundRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public CreatePaymentRefundRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="Price and product information of the refunded items, required for [partial refunds](https://docs.adyen.com/online-payments/refund#refund-a-payment). > This field is required for partial refunds with 3x 4x Oney, Affirm, Afterpay, Atome, Clearpay, Klarna, Ratepay, Walley, and Zip.")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public CreatePaymentRefundRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account that is used to process the payment.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CreatePaymentRefundRequest merchantRefundReason(MerchantRefundReasonEnum merchantRefundReason) {
        this.merchantRefundReason = merchantRefundReason;
        return this;
    }

    @ApiModelProperty(value="Your reason for the refund request")
    public MerchantRefundReasonEnum getMerchantRefundReason() {
        return this.merchantRefundReason;
    }

    public void setMerchantRefundReason(MerchantRefundReasonEnum merchantRefundReason) {
        this.merchantRefundReason = merchantRefundReason;
    }

    public CreatePaymentRefundRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the refund request. Maximum length: 80 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public CreatePaymentRefundRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public CreatePaymentRefundRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="An array of objects specifying how the amount should be split between accounts when using Adyen for Platforms. For details, refer to [Providing split information](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information).")
    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePaymentRefundRequest createPaymentRefundRequest = (CreatePaymentRefundRequest)o;
        return Objects.equals(this.amount, createPaymentRefundRequest.amount) && Objects.equals(this.lineItems, createPaymentRefundRequest.lineItems) && Objects.equals(this.merchantAccount, createPaymentRefundRequest.merchantAccount) && Objects.equals((Object)this.merchantRefundReason, (Object)createPaymentRefundRequest.merchantRefundReason) && Objects.equals(this.reference, createPaymentRefundRequest.reference) && Objects.equals(this.splits, createPaymentRefundRequest.splits);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.lineItems, this.merchantAccount, this.merchantRefundReason, this.reference, this.splits});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePaymentRefundRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantRefundReason: ").append(this.toIndentedString((Object)this.merchantRefundReason)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraylineItems;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreatePaymentRefundRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreatePaymentRefundRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if ((jsonArraylineItems = jsonObj.getAsJsonArray(SERIALIZED_NAME_LINE_ITEMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_LINE_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `lineItems` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINE_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArraylineItems.size(); ++i) {
                LineItem.validateJsonObject(jsonArraylineItems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_REFUND_REASON) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MERCHANT_REFUND_REASON).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `merchantRefundReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_REFUND_REASON).toString()));
            }
            MerchantRefundReasonEnum.fromValue(jsonObj.get(SERIALIZED_NAME_MERCHANT_REFUND_REASON).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        JsonArray jsonArraysplits = jsonObj.getAsJsonArray(SERIALIZED_NAME_SPLITS);
        if (jsonArraysplits != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SPLITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `splits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPLITS).toString()));
            }
            for (int i = 0; i < jsonArraysplits.size(); ++i) {
                Split.validateJsonObject(jsonArraysplits.get(i).getAsJsonObject());
            }
        }
    }

    public static CreatePaymentRefundRequest fromJson(String jsonString) throws IOException {
        return (CreatePaymentRefundRequest)JSON.getGson().fromJson(jsonString, CreatePaymentRefundRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_LINE_ITEMS);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_REFUND_REASON);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SPLITS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreatePaymentRefundRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreatePaymentRefundRequest.class));
            return new TypeAdapter<CreatePaymentRefundRequest>(){

                public void write(JsonWriter out, CreatePaymentRefundRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreatePaymentRefundRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreatePaymentRefundRequest.validateJsonObject(jsonObj);
                    return (CreatePaymentRefundRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MerchantRefundReasonEnum {
        FRAUD("FRAUD"),
        CUSTOMER_REQUEST("CUSTOMER REQUEST"),
        RETURN("RETURN"),
        DUPLICATE("DUPLICATE"),
        OTHER("OTHER");

        private String value;

        private MerchantRefundReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MerchantRefundReasonEnum fromValue(String value) {
            for (MerchantRefundReasonEnum b : MerchantRefundReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<MerchantRefundReasonEnum> {
            public void write(JsonWriter jsonWriter, MerchantRefundReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MerchantRefundReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MerchantRefundReasonEnum.fromValue(value);
            }
        }
    }
}

