/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CheckoutCreateOrderResponse {
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private String expiresAt;
    public static final String SERIALIZED_NAME_FRAUD_RESULT = "fraudResult";
    @SerializedName(value="fraudResult")
    private FraudResult fraudResult;
    public static final String SERIALIZED_NAME_ORDER_DATA = "orderData";
    @SerializedName(value="orderData")
    private String orderData;
    public static final String SERIALIZED_NAME_PSP_REFERENCE = "pspReference";
    @SerializedName(value="pspReference")
    private String pspReference;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_REFUSAL_REASON = "refusalReason";
    @SerializedName(value="refusalReason")
    private String refusalReason;
    public static final String SERIALIZED_NAME_REMAINING_AMOUNT = "remainingAmount";
    @SerializedName(value="remainingAmount")
    private Amount remainingAmount;
    public static final String SERIALIZED_NAME_RESULT_CODE = "resultCode";
    @SerializedName(value="resultCode")
    private ResultCodeEnum resultCode;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CheckoutCreateOrderResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public CheckoutCreateOrderResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** > **Developers** > **Additional data**.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public CheckoutCreateOrderResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CheckoutCreateOrderResponse expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date that the order will expire.")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public CheckoutCreateOrderResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @ApiModelProperty(value="")
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public CheckoutCreateOrderResponse orderData(String orderData) {
        this.orderData = orderData;
        return this;
    }

    @ApiModelProperty(required=true, value="The encrypted data that will be used by merchant for adding payments to the order.")
    public String getOrderData() {
        return this.orderData;
    }

    public void setOrderData(String orderData) {
        this.orderData = orderData;
    }

    public CheckoutCreateOrderResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="Adyen's 16-character reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.")
    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public CheckoutCreateOrderResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="The reference provided by merchant for creating the order.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public CheckoutCreateOrderResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @ApiModelProperty(value="If the payment's authorisation is refused or an error occurs during authorisation, this field holds Adyen's mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes `resultCode` and `refusalReason` values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).")
    public String getRefusalReason() {
        return this.refusalReason;
    }

    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public CheckoutCreateOrderResponse remainingAmount(Amount remainingAmount) {
        this.remainingAmount = remainingAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getRemainingAmount() {
        return this.remainingAmount;
    }

    public void setRemainingAmount(Amount remainingAmount) {
        this.remainingAmount = remainingAmount;
    }

    public CheckoutCreateOrderResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The result of the order creation request.  The value is always **Success**.")
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutCreateOrderResponse checkoutCreateOrderResponse = (CheckoutCreateOrderResponse)o;
        return Objects.equals(this.additionalData, checkoutCreateOrderResponse.additionalData) && Objects.equals(this.amount, checkoutCreateOrderResponse.amount) && Objects.equals(this.expiresAt, checkoutCreateOrderResponse.expiresAt) && Objects.equals(this.fraudResult, checkoutCreateOrderResponse.fraudResult) && Objects.equals(this.orderData, checkoutCreateOrderResponse.orderData) && Objects.equals(this.pspReference, checkoutCreateOrderResponse.pspReference) && Objects.equals(this.reference, checkoutCreateOrderResponse.reference) && Objects.equals(this.refusalReason, checkoutCreateOrderResponse.refusalReason) && Objects.equals(this.remainingAmount, checkoutCreateOrderResponse.remainingAmount) && Objects.equals((Object)this.resultCode, (Object)checkoutCreateOrderResponse.resultCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.amount, this.expiresAt, this.fraudResult, this.orderData, this.pspReference, this.reference, this.refusalReason, this.remainingAmount, this.resultCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutCreateOrderResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    orderData: ").append(this.toIndentedString(this.orderData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    remainingAmount: ").append(this.toIndentedString(this.remainingAmount)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CheckoutCreateOrderResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CheckoutCreateOrderResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRES_AT) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRES_AT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expiresAt` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRES_AT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FRAUD_RESULT) != null) {
            FraudResult.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FRAUD_RESULT));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_DATA) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `orderData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `refusalReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_REMAINING_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_REMAINING_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESULT_CODE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESULT_CODE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `resultCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULT_CODE).toString()));
            }
            ResultCodeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_RESULT_CODE).getAsString());
        }
    }

    public static CheckoutCreateOrderResponse fromJson(String jsonString) throws IOException {
        return (CheckoutCreateOrderResponse)JSON.getGson().fromJson(jsonString, CheckoutCreateOrderResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_FRAUD_RESULT);
        openapiFields.add(SERIALIZED_NAME_ORDER_DATA);
        openapiFields.add(SERIALIZED_NAME_PSP_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFUSAL_REASON);
        openapiFields.add(SERIALIZED_NAME_REMAINING_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_RESULT_CODE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_ORDER_DATA);
        openapiRequiredFields.add(SERIALIZED_NAME_REMAINING_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_RESULT_CODE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CheckoutCreateOrderResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CheckoutCreateOrderResponse.class));
            return new TypeAdapter<CheckoutCreateOrderResponse>(){

                public void write(JsonWriter out, CheckoutCreateOrderResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CheckoutCreateOrderResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CheckoutCreateOrderResponse.validateJsonObject(jsonObj);
                    return (CheckoutCreateOrderResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResultCodeEnum {
        SUCCESS("Success");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ResultCodeEnum> {
            public void write(JsonWriter jsonWriter, ResultCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResultCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResultCodeEnum.fromValue(value);
            }
        }
    }
}

