/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.capital;

import com.adyen.model.capital.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RepaymentTerm {
    public static final String SERIALIZED_NAME_ESTIMATED_DAYS = "estimatedDays";
    @SerializedName(value="estimatedDays")
    private Integer estimatedDays;
    public static final String SERIALIZED_NAME_MAXIMUM_DAYS = "maximumDays";
    @SerializedName(value="maximumDays")
    private Integer maximumDays;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RepaymentTerm estimatedDays(Integer estimatedDays) {
        this.estimatedDays = estimatedDays;
        return this;
    }

    @ApiModelProperty(required=true, value="The estimated term for repaying the grant, in days.")
    public Integer getEstimatedDays() {
        return this.estimatedDays;
    }

    public void setEstimatedDays(Integer estimatedDays) {
        this.estimatedDays = estimatedDays;
    }

    public RepaymentTerm maximumDays(Integer maximumDays) {
        this.maximumDays = maximumDays;
        return this;
    }

    @ApiModelProperty(value="The maximum term for repaying the grant, in days. Only applies when `contractType` is **loan**.")
    public Integer getMaximumDays() {
        return this.maximumDays;
    }

    public void setMaximumDays(Integer maximumDays) {
        this.maximumDays = maximumDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepaymentTerm repaymentTerm = (RepaymentTerm)o;
        return Objects.equals(this.estimatedDays, repaymentTerm.estimatedDays) && Objects.equals(this.maximumDays, repaymentTerm.maximumDays);
    }

    public int hashCode() {
        return Objects.hash(this.estimatedDays, this.maximumDays);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RepaymentTerm {\n");
        sb.append("    estimatedDays: ").append(this.toIndentedString(this.estimatedDays)).append("\n");
        sb.append("    maximumDays: ").append(this.toIndentedString(this.maximumDays)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RepaymentTerm is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RepaymentTerm` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static RepaymentTerm fromJson(String jsonString) throws IOException {
        return (RepaymentTerm)JSON.getGson().fromJson(jsonString, RepaymentTerm.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ESTIMATED_DAYS);
        openapiFields.add(SERIALIZED_NAME_MAXIMUM_DAYS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ESTIMATED_DAYS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!RepaymentTerm.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RepaymentTerm.class));
            return new TypeAdapter<RepaymentTerm>(){

                public void write(JsonWriter out, RepaymentTerm value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public RepaymentTerm read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RepaymentTerm.validateJsonObject(jsonObj);
                    return (RepaymentTerm)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

