/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SweepCounterparty {
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT_ID = "balanceAccountId";
    @SerializedName(value="balanceAccountId")
    private String balanceAccountId;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
    @SerializedName(value="transferInstrumentId")
    private String transferInstrumentId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SweepCounterparty balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the destination or source [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).   You can only use this for periodic sweep schedules such as `schedule.type` **daily** or **monthly**.")
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public SweepCounterparty merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(value="The merchant account that will be the source of funds, if you are processing payments with Adyen. You can only use this with sweeps of `type` **pull** and `schedule.type` **balance**.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public SweepCounterparty transferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the destination or source [transfer instrument](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/transferInstruments__resParam_id).  You can also use this in combination with a `merchantAccount` and a `type` **pull** to start a direct debit request from the source transfer instrument. To use this feature, reach out to your Adyen contact.")
    public String getTransferInstrumentId() {
        return this.transferInstrumentId;
    }

    public void setTransferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SweepCounterparty sweepCounterparty = (SweepCounterparty)o;
        return Objects.equals(this.balanceAccountId, sweepCounterparty.balanceAccountId) && Objects.equals(this.merchantAccount, sweepCounterparty.merchantAccount) && Objects.equals(this.transferInstrumentId, sweepCounterparty.transferInstrumentId);
    }

    public int hashCode() {
        return Objects.hash(this.balanceAccountId, this.merchantAccount, this.transferInstrumentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SweepCounterparty {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    transferInstrumentId: ").append(this.toIndentedString(this.transferInstrumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SweepCounterparty is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SweepCounterparty` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `balanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transferInstrumentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID).toString()));
        }
    }

    public static SweepCounterparty fromJson(String jsonString) throws IOException {
        return (SweepCounterparty)JSON.getGson().fromJson(jsonString, SweepCounterparty.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SweepCounterparty.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SweepCounterparty.class));
            return new TypeAdapter<SweepCounterparty>(){

                public void write(JsonWriter out, SweepCounterparty value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SweepCounterparty read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SweepCounterparty.validateJsonObject(jsonObj);
                    return (SweepCounterparty)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

