/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Amount;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.SweepConfigurationV2Schedule;
import com.adyen.model.balanceplatform.SweepCounterparty;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SweepConfigurationV2 {
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
    @SerializedName(value="counterparty")
    private SweepCounterparty counterparty;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PRIORITIES = "priorities";
    @SerializedName(value="priorities")
    private List<PrioritiesEnum> priorities = null;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private ReasonEnum reason;
    public static final String SERIALIZED_NAME_SCHEDULE = "schedule";
    @SerializedName(value="schedule")
    private SweepConfigurationV2Schedule schedule;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_SWEEP_AMOUNT = "sweepAmount";
    @SerializedName(value="sweepAmount")
    private Amount sweepAmount;
    public static final String SERIALIZED_NAME_TARGET_AMOUNT = "targetAmount";
    @SerializedName(value="targetAmount")
    private Amount targetAmount;
    public static final String SERIALIZED_NAME_TRIGGER_AMOUNT = "triggerAmount";
    @SerializedName(value="triggerAmount")
    private Amount triggerAmount;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.PUSH;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SweepConfigurationV2() {
    }

    public SweepConfigurationV2(String id, ReasonEnum reason) {
        this();
        this.id = id;
        this.reason = reason;
    }

    public SweepConfigurationV2 category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="The type of transfer that results from the sweep.  Possible values:   - **bank**: Sweep to a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).  - **internal**: Transfer to another [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id) within your platform.  Required when setting `priorities`.")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public SweepConfigurationV2 counterparty(SweepCounterparty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public SweepCounterparty getCounterparty() {
        return this.counterparty;
    }

    public void setCounterparty(SweepCounterparty counterparty) {
        this.counterparty = counterparty;
    }

    public SweepConfigurationV2 currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="The three-character [ISO currency code](https://docs.adyen.com/development-resources/currency-codes) in uppercase. For example, **EUR**.  The sweep currency must match any of the [balances currencies](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/get/balanceAccounts/{id}__resParam_balances).")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public SweepConfigurationV2 description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The message that will be used in the sweep transfer's description body with a maximum length of 140 characters.  If the message is longer after replacing placeholders, the message will be cut off at 140 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the sweep.")
    public String getId() {
        return this.id;
    }

    public SweepConfigurationV2 priorities(List<PrioritiesEnum> priorities) {
        this.priorities = priorities;
        return this;
    }

    public SweepConfigurationV2 addPrioritiesItem(PrioritiesEnum prioritiesItem) {
        if (this.priorities == null) {
            this.priorities = new ArrayList<PrioritiesEnum>();
        }
        this.priorities.add(prioritiesItem);
        return this;
    }

    @ApiModelProperty(value="The list of priorities for the bank transfer. This sets the speed at which the transfer is sent and the fees that you have to pay. You can provide multiple priorities. Adyen will try to pay out using the priority listed first, and if that's not possible, it moves on to the next option in the order of provided priorities.  Possible values:  * **regular**: For normal, low-value transactions.  * **fast**: Faster way to transfer funds but has higher fees. Recommended for high-priority, low-value transactions.  * **wire**: Fastest way to transfer funds but has the highest fees. Recommended for high-priority, high-value transactions.  * **instant**: Instant way to transfer funds in [SEPA countries](https://www.ecb.europa.eu/paym/integration/retail/sepa/html/index.en.html).  * **crossBorder**: High-value transfer to a recipient in a different country.  * **internal**: Transfer to an Adyen-issued business bank account (by bank account number/IBAN).  Set `category` to **bank**. For more details, see [optional priorities setup](https://docs.adyen.com/marketplaces-and-platforms/payout-to-users/scheduled-payouts#optional-priorities-setup).")
    public List<PrioritiesEnum> getPriorities() {
        return this.priorities;
    }

    public void setPriorities(List<PrioritiesEnum> priorities) {
        this.priorities = priorities;
    }

    @ApiModelProperty(value="The reason for disabling the sweep.")
    public ReasonEnum getReason() {
        return this.reason;
    }

    public SweepConfigurationV2 schedule(SweepConfigurationV2Schedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public SweepConfigurationV2Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(SweepConfigurationV2Schedule schedule) {
        this.schedule = schedule;
    }

    public SweepConfigurationV2 status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the sweep. If not provided, by default, this is set to **active**.  Possible values:    * **active**:  the sweep is enabled and funds will be pulled in or pushed out based on the defined configuration.    * **inactive**: the sweep is disabled and cannot be triggered.   ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public SweepConfigurationV2 sweepAmount(Amount sweepAmount) {
        this.sweepAmount = sweepAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getSweepAmount() {
        return this.sweepAmount;
    }

    public void setSweepAmount(Amount sweepAmount) {
        this.sweepAmount = sweepAmount;
    }

    public SweepConfigurationV2 targetAmount(Amount targetAmount) {
        this.targetAmount = targetAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTargetAmount() {
        return this.targetAmount;
    }

    public void setTargetAmount(Amount targetAmount) {
        this.targetAmount = targetAmount;
    }

    public SweepConfigurationV2 triggerAmount(Amount triggerAmount) {
        this.triggerAmount = triggerAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getTriggerAmount() {
        return this.triggerAmount;
    }

    public void setTriggerAmount(Amount triggerAmount) {
        this.triggerAmount = triggerAmount;
    }

    public SweepConfigurationV2 type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The direction of sweep, whether pushing out or pulling in funds to the balance account. If not provided, by default, this is set to **push**.  Possible values:   * **push**: _push out funds_ to a destination balance account or transfer instrument.   * **pull**: _pull in funds_ from a source merchant account, transfer instrument, or balance account.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SweepConfigurationV2 sweepConfigurationV2 = (SweepConfigurationV2)o;
        return Objects.equals((Object)this.category, (Object)sweepConfigurationV2.category) && Objects.equals(this.counterparty, sweepConfigurationV2.counterparty) && Objects.equals(this.currency, sweepConfigurationV2.currency) && Objects.equals(this.description, sweepConfigurationV2.description) && Objects.equals(this.id, sweepConfigurationV2.id) && Objects.equals(this.priorities, sweepConfigurationV2.priorities) && Objects.equals((Object)this.reason, (Object)sweepConfigurationV2.reason) && Objects.equals(this.schedule, sweepConfigurationV2.schedule) && Objects.equals((Object)this.status, (Object)sweepConfigurationV2.status) && Objects.equals(this.sweepAmount, sweepConfigurationV2.sweepAmount) && Objects.equals(this.targetAmount, sweepConfigurationV2.targetAmount) && Objects.equals(this.triggerAmount, sweepConfigurationV2.triggerAmount) && Objects.equals((Object)this.type, (Object)sweepConfigurationV2.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.counterparty, this.currency, this.description, this.id, this.priorities, this.reason, this.schedule, this.status, this.sweepAmount, this.targetAmount, this.triggerAmount, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SweepConfigurationV2 {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    priorities: ").append(this.toIndentedString(this.priorities)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    sweepAmount: ").append(this.toIndentedString(this.sweepAmount)).append("\n");
        sb.append("    targetAmount: ").append(this.toIndentedString(this.targetAmount)).append("\n");
        sb.append("    triggerAmount: ").append(this.toIndentedString(this.triggerAmount)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SweepConfigurationV2 is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SweepConfigurationV2` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CATEGORY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CATEGORY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `category` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CATEGORY).toString()));
            }
            CategoryEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CATEGORY).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY) != null) {
            SweepCounterparty.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIORITIES) != null && !jsonObj.get(SERIALIZED_NAME_PRIORITIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `priorities` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIORITIES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
            }
            ReasonEnum.fromValue(jsonObj.get(SERIALIZED_NAME_REASON).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SCHEDULE) != null) {
            SweepConfigurationV2Schedule.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SCHEDULE));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SWEEP_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SWEEP_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TARGET_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TARGET_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TRIGGER_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TRIGGER_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static SweepConfigurationV2 fromJson(String jsonString) throws IOException {
        return (SweepConfigurationV2)JSON.getGson().fromJson(jsonString, SweepConfigurationV2.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CATEGORY);
        openapiFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_PRIORITIES);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_SCHEDULE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_SWEEP_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_TARGET_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_TRIGGER_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiRequiredFields.add(SERIALIZED_NAME_CURRENCY);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_SCHEDULE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SweepConfigurationV2.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SweepConfigurationV2.class));
            return new TypeAdapter<SweepConfigurationV2>(){

                public void write(JsonWriter out, SweepConfigurationV2 value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SweepConfigurationV2 read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SweepConfigurationV2.validateJsonObject(jsonObj);
                    return (SweepConfigurationV2)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PULL("pull"),
        PUSH("push");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReasonEnum {
        AMOUNTLIMITEXCEEDED("amountLimitExceeded"),
        APPROVED("approved"),
        COUNTERPARTYACCOUNTBLOCKED("counterpartyAccountBlocked"),
        COUNTERPARTYACCOUNTCLOSED("counterpartyAccountClosed"),
        COUNTERPARTYACCOUNTNOTFOUND("counterpartyAccountNotFound"),
        COUNTERPARTYADDRESSREQUIRED("counterpartyAddressRequired"),
        COUNTERPARTYBANKTIMEDOUT("counterpartyBankTimedOut"),
        COUNTERPARTYBANKUNAVAILABLE("counterpartyBankUnavailable"),
        ERROR("error"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        REFUSEDBYCOUNTERPARTYBANK("refusedByCounterpartyBank"),
        ROUTENOTFOUND("routeNotFound"),
        UNKNOWN("unknown");

        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReasonEnum> {
            public void write(JsonWriter jsonWriter, ReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReasonEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PrioritiesEnum {
        CROSSBORDER("crossBorder"),
        DIRECTDEBIT("directDebit"),
        FAST("fast"),
        INSTANT("instant"),
        INTERNAL("internal"),
        REGULAR("regular"),
        WIRE("wire");

        private String value;

        private PrioritiesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PrioritiesEnum fromValue(String value) {
            for (PrioritiesEnum b : PrioritiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PrioritiesEnum> {
            public void write(JsonWriter jsonWriter, PrioritiesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PrioritiesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PrioritiesEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        BANK("bank"),
        INTERNAL("internal"),
        PLATFORMPAYMENT("platformPayment");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }
}

