/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BulkAddress {
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_COMPANY = "company";
    @SerializedName(value="company")
    private String company;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME = "houseNumberOrName";
    @SerializedName(value="houseNumberOrName")
    private String houseNumberOrName;
    public static final String SERIALIZED_NAME_MOBILE = "mobile";
    @SerializedName(value="mobile")
    private String mobile;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postalCode";
    @SerializedName(value="postalCode")
    private String postalCode;
    public static final String SERIALIZED_NAME_STATE_OR_PROVINCE = "stateOrProvince";
    @SerializedName(value="stateOrProvince")
    private String stateOrProvince;
    public static final String SERIALIZED_NAME_STREET = "street";
    @SerializedName(value="street")
    private String street;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BulkAddress city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The name of the city.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public BulkAddress company(String company) {
        this.company = company;
        return this;
    }

    @ApiModelProperty(value="The name of the company.")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public BulkAddress country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-character ISO-3166-1 alpha-2 country code. For example, **US**.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public BulkAddress email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public BulkAddress houseNumberOrName(String houseNumberOrName) {
        this.houseNumberOrName = houseNumberOrName;
        return this;
    }

    @ApiModelProperty(value="The house number or name.")
    public String getHouseNumberOrName() {
        return this.houseNumberOrName;
    }

    public void setHouseNumberOrName(String houseNumberOrName) {
        this.houseNumberOrName = houseNumberOrName;
    }

    public BulkAddress mobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    @ApiModelProperty(value="The full telephone number.")
    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public BulkAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(value="The postal code.  Maximum length:  * 5 digits for addresses in the US.  * 10 characters for all other countries.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public BulkAddress stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @ApiModelProperty(value="The two-letter ISO 3166-2 state or province code.  Maximum length: 2 characters for addresses in the US.")
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public BulkAddress street(String street) {
        this.street = street;
        return this;
    }

    @ApiModelProperty(value="The streetname of the house.")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkAddress bulkAddress = (BulkAddress)o;
        return Objects.equals(this.city, bulkAddress.city) && Objects.equals(this.company, bulkAddress.company) && Objects.equals(this.country, bulkAddress.country) && Objects.equals(this.email, bulkAddress.email) && Objects.equals(this.houseNumberOrName, bulkAddress.houseNumberOrName) && Objects.equals(this.mobile, bulkAddress.mobile) && Objects.equals(this.postalCode, bulkAddress.postalCode) && Objects.equals(this.stateOrProvince, bulkAddress.stateOrProvince) && Objects.equals(this.street, bulkAddress.street);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.company, this.country, this.email, this.houseNumberOrName, this.mobile, this.postalCode, this.stateOrProvince, this.street);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkAddress {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    houseNumberOrName: ").append(this.toIndentedString(this.houseNumberOrName)).append("\n");
        sb.append("    mobile: ").append(this.toIndentedString(this.mobile)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BulkAddress is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BulkAddress` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CITY) != null && !jsonObj.get(SERIALIZED_NAME_CITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `city` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPANY) != null && !jsonObj.get(SERIALIZED_NAME_COMPANY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `company` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPANY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME) != null && !jsonObj.get(SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `houseNumberOrName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOBILE) != null && !jsonObj.get(SERIALIZED_NAME_MOBILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mobile` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOBILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_POSTAL_CODE) != null && !jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `postalCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POSTAL_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATE_OR_PROVINCE) != null && !jsonObj.get(SERIALIZED_NAME_STATE_OR_PROVINCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `stateOrProvince` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE_OR_PROVINCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STREET) != null && !jsonObj.get(SERIALIZED_NAME_STREET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `street` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STREET).toString()));
        }
    }

    public static BulkAddress fromJson(String jsonString) throws IOException {
        return (BulkAddress)JSON.getGson().fromJson(jsonString, BulkAddress.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CITY);
        openapiFields.add(SERIALIZED_NAME_COMPANY);
        openapiFields.add(SERIALIZED_NAME_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_HOUSE_NUMBER_OR_NAME);
        openapiFields.add(SERIALIZED_NAME_MOBILE);
        openapiFields.add(SERIALIZED_NAME_POSTAL_CODE);
        openapiFields.add(SERIALIZED_NAME_STATE_OR_PROVINCE);
        openapiFields.add(SERIALIZED_NAME_STREET);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTRY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BulkAddress.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BulkAddress.class));
            return new TypeAdapter<BulkAddress>(){

                public void write(JsonWriter out, BulkAddress value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BulkAddress read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BulkAddress.validateJsonObject(jsonObj);
                    return (BulkAddress)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

