/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balancecontrol;

import com.adyen.model.balancecontrol.Amount;
import com.adyen.model.balancecontrol.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BalanceTransferResponse {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_FROM_MERCHANT = "fromMerchant";
    @SerializedName(value="fromMerchant")
    private String fromMerchant;
    public static final String SERIALIZED_NAME_PSP_REFERENCE = "pspReference";
    @SerializedName(value="pspReference")
    private String pspReference;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TO_MERCHANT = "toMerchant";
    @SerializedName(value="toMerchant")
    private String toMerchant;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BalanceTransferResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public BalanceTransferResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date when the balance transfer was requested.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public BalanceTransferResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A human-readable description for the transfer. You can use alphanumeric characters and hyphens. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BalanceTransferResponse fromMerchant(String fromMerchant) {
        this.fromMerchant = fromMerchant;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the source merchant account from which funds are deducted.")
    public String getFromMerchant() {
        return this.fromMerchant;
    }

    public void setFromMerchant(String fromMerchant) {
        this.fromMerchant = fromMerchant;
    }

    public BalanceTransferResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="Adyen's 16-character string reference associated with the balance transfer.")
    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public BalanceTransferResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="A reference for the balance transfer. If you don't provide this in the request, Adyen generates a unique reference. Maximum length: 80 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public BalanceTransferResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the balance transfer. Possible values: **transferred**, **failed**, **error**, and **notEnoughBalance**.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public BalanceTransferResponse toMerchant(String toMerchant) {
        this.toMerchant = toMerchant;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the destination merchant account from which funds are transferred.")
    public String getToMerchant() {
        return this.toMerchant;
    }

    public void setToMerchant(String toMerchant) {
        this.toMerchant = toMerchant;
    }

    public BalanceTransferResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of balance transfer. Possible values: **tax**, **fee**, **terminalSale**, **credit**, **debit**, and **adjustment**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceTransferResponse balanceTransferResponse = (BalanceTransferResponse)o;
        return Objects.equals(this.amount, balanceTransferResponse.amount) && Objects.equals(this.createdAt, balanceTransferResponse.createdAt) && Objects.equals(this.description, balanceTransferResponse.description) && Objects.equals(this.fromMerchant, balanceTransferResponse.fromMerchant) && Objects.equals(this.pspReference, balanceTransferResponse.pspReference) && Objects.equals(this.reference, balanceTransferResponse.reference) && Objects.equals((Object)this.status, (Object)balanceTransferResponse.status) && Objects.equals(this.toMerchant, balanceTransferResponse.toMerchant) && Objects.equals((Object)this.type, (Object)balanceTransferResponse.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.createdAt, this.description, this.fromMerchant, this.pspReference, this.reference, this.status, this.toMerchant, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceTransferResponse {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fromMerchant: ").append(this.toIndentedString(this.fromMerchant)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    toMerchant: ").append(this.toIndentedString(this.toMerchant)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BalanceTransferResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BalanceTransferResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FROM_MERCHANT) != null && !jsonObj.get(SERIALIZED_NAME_FROM_MERCHANT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fromMerchant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM_MERCHANT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TO_MERCHANT) != null && !jsonObj.get(SERIALIZED_NAME_TO_MERCHANT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `toMerchant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO_MERCHANT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static BalanceTransferResponse fromJson(String jsonString) throws IOException {
        return (BalanceTransferResponse)JSON.getGson().fromJson(jsonString, BalanceTransferResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_FROM_MERCHANT);
        openapiFields.add(SERIALIZED_NAME_PSP_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TO_MERCHANT);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_FROM_MERCHANT);
        openapiRequiredFields.add(SERIALIZED_NAME_PSP_REFERENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_TO_MERCHANT);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BalanceTransferResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BalanceTransferResponse.class));
            return new TypeAdapter<BalanceTransferResponse>(){

                public void write(JsonWriter out, BalanceTransferResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BalanceTransferResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BalanceTransferResponse.validateJsonObject(jsonObj);
                    return (BalanceTransferResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        TAX("tax"),
        FEE("fee"),
        TERMINALSALE("terminalSale"),
        CREDIT("credit"),
        DEBIT("debit"),
        ADJUSTMENT("adjustment");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ERROR("error"),
        FAILED("failed"),
        NOTENOUGHBALANCE("notEnoughBalance"),
        TRANSFERRED("transferred");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

