/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.modification;

import com.adyen.model.Split;
import com.adyen.model.ThreeDSecureData;
import com.adyen.model.additionalData.InvoiceLine;
import com.adyen.model.additionalData.SplitPayment;
import com.adyen.model.additionalData.SplitPaymentItem;
import com.adyen.model.applicationinfo.ApplicationInfo;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AbstractModificationRequest<T extends AbstractModificationRequest<T>> {
    @SerializedName(value="reference")
    private String reference = null;
    @SerializedName(value="authorisationCode")
    private String authorisationCode = null;
    @SerializedName(value="originalReference")
    private String originalReference = null;
    @SerializedName(value="merchantAccount")
    private String merchantAccount = null;
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    @SerializedName(value="applicationInfo")
    private ApplicationInfo applicationInfo = new ApplicationInfo();
    @SerializedName(value="splits")
    private List<Split> splits = null;
    @SerializedName(value="mpiData")
    private ThreeDSecureData mpiData = null;

    public T reference(String reference) {
        this.reference = reference;
        return (T)this;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public T authorisationCode(String authorisationCode) {
        this.authorisationCode = authorisationCode;
        return (T)this;
    }

    public String getAuthorisationCode() {
        return this.authorisationCode;
    }

    public void setAuthorisationCode(String authorisationCode) {
        this.authorisationCode = authorisationCode;
    }

    public T originalReference(String originalReference) {
        this.originalReference = originalReference;
        return (T)this;
    }

    public String getOriginalReference() {
        return this.originalReference;
    }

    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
    }

    public T merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return (T)this;
    }

    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public Map<String, String> getOrCreateAdditionalData() {
        if (this.getAdditionalData() == null) {
            this.setAdditionalData(new HashMap<String, String>());
        }
        return this.getAdditionalData();
    }

    public T setInvoiceLines(List<InvoiceLine> invoiceLines) {
        Integer count = 1;
        for (InvoiceLine invoiceLine : invoiceLines) {
            StringBuilder sb = new StringBuilder();
            sb.append("openinvoicedata.line");
            sb.append(Integer.toString(count));
            String lineNumber = sb.toString();
            this.getOrCreateAdditionalData().put(lineNumber + ".currencyCode", invoiceLine.getCurrencyCode());
            this.getOrCreateAdditionalData().put(lineNumber + ".description", invoiceLine.getDescription());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemAmount", invoiceLine.getItemAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemVatAmount", invoiceLine.getItemVATAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemVatPercentage", invoiceLine.getItemVatPercentage().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".numberOfItems", Integer.toString(invoiceLine.getNumberOfItems()));
            this.getOrCreateAdditionalData().put(lineNumber + ".vatCategory", invoiceLine.getVatCategory().toString());
            if (invoiceLine.getItemId() != null && !invoiceLine.getItemId().isEmpty()) {
                this.getOrCreateAdditionalData().put(lineNumber + ".itemId", invoiceLine.getItemId());
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.getOrCreateAdditionalData().put("openinvoicedata.numberOfLines", Integer.toString(invoiceLines.size()));
        return (T)this;
    }

    public T setSplitPayment(SplitPayment splitPayment) {
        this.getOrCreateAdditionalData().put("split.api", splitPayment.getApi().toString());
        this.getOrCreateAdditionalData().put("split.totalAmount", splitPayment.getTotalAmount().toString());
        this.getOrCreateAdditionalData().put("split.currencyCode", splitPayment.getCurrencyCode());
        Integer count = 1;
        for (SplitPaymentItem splitPaymentItem : splitPayment.getSplitPaymentItems()) {
            StringBuilder sb = new StringBuilder();
            sb.append("split.item");
            sb.append(Integer.toString(count));
            String lineNumber = sb.toString();
            this.getOrCreateAdditionalData().put(lineNumber + ".amount", splitPaymentItem.getAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".type", splitPaymentItem.getType());
            this.getOrCreateAdditionalData().put(lineNumber + ".account", splitPaymentItem.getAccount());
            this.getOrCreateAdditionalData().put(lineNumber + ".reference", splitPaymentItem.getReference());
            this.getOrCreateAdditionalData().put(lineNumber + ".description", splitPaymentItem.getDescription());
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.getOrCreateAdditionalData().put("split.nrOfItems", Integer.toString(splitPayment.getSplitPaymentItems().size()));
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractModificationRequest modificationRequest = (AbstractModificationRequest)o;
        return Objects.equals(this.reference, modificationRequest.reference) && Objects.equals(this.authorisationCode, modificationRequest.authorisationCode) && Objects.equals(this.originalReference, modificationRequest.originalReference) && Objects.equals(this.merchantAccount, modificationRequest.merchantAccount) && Objects.equals(this.applicationInfo, modificationRequest.applicationInfo) && Objects.equals(this.additionalData, modificationRequest.additionalData) && Objects.equals(this.mpiData, modificationRequest.mpiData);
    }

    public int hashCode() {
        return Objects.hash(this.reference, this.authorisationCode, this.originalReference, this.merchantAccount, this.additionalData, this.applicationInfo, this.mpiData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    authorisationCode: ").append(this.toIndentedString(this.authorisationCode)).append("\n");
        sb.append("    originalReference: ").append(this.toIndentedString(this.originalReference)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

