/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.adyen.Util.Util;
import com.adyen.model.AbstractPaymentRequest;
import com.adyen.model.AccountInfo;
import com.adyen.model.Amount;
import com.adyen.model.BankAccount;
import com.adyen.model.Card;
import com.adyen.model.MerchantRiskIndicator;
import com.adyen.model.Split;
import com.adyen.model.ThreeDS2RequestData;
import com.adyen.model.ThreeDSecureData;
import com.adyen.model.additionalData.InvoiceLine;
import com.adyen.model.additionalData.SplitPayment;
import com.adyen.model.additionalData.SplitPaymentItem;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Objects;

public class PaymentRequest
extends AbstractPaymentRequest<PaymentRequest> {
    private static final String ADDITIONAL_DATA = "/authorise-3d-adyen-response";
    @SerializedName(value="accountInfo")
    private AccountInfo accountInfo = null;
    @SerializedName(value="card")
    private Card card = null;
    @SerializedName(value="mpiData")
    private ThreeDSecureData mpiData = null;
    @SerializedName(value="bankAccount")
    private BankAccount bankAccount = null;
    @SerializedName(value="store")
    private String store = null;
    @SerializedName(value="merchantRiskIndicator")
    private MerchantRiskIndicator merchantRiskIndicator = null;
    @SerializedName(value="splits")
    private List<Split> splits = null;
    @SerializedName(value="trustedShopper")
    private Boolean trustedShopper = null;
    @SerializedName(value="threeDS2RequestData")
    private ThreeDS2RequestData threeDS2RequestData = null;
    @SerializedName(value="recurringProcessingModel")
    private RecurringProcessingModelEnum recurringProcessingModel = null;

    public PaymentRequest setAmountData(String amount, String currency) {
        Amount amountData = Util.createAmount(amount, currency);
        this.setAmount(amountData);
        return this;
    }

    public PaymentRequest setCSEToken(String cseToken) {
        this.getOrCreateAdditionalData().put("card.encrypted.json", cseToken);
        return this;
    }

    public PaymentRequest setCardData(String cardNumber, String cardHolder, String expiryMonth, String expiryYear, String cvc) {
        Card card = new Card();
        card.setExpiryMonth(expiryMonth);
        card.setExpiryYear(expiryYear);
        card.setHolderName(cardHolder);
        card.setNumber(cardNumber);
        card.setCvc(cvc);
        this.setCard(card);
        return this;
    }

    public PaymentRequest setSecuredFieldsData(String encryptedCardNumber, String cardHolder, String encryptedExpiryMonth, String encryptedExpiryYear, String encryptedSecurityCode) {
        this.setCardHolder(cardHolder).setEncryptedCardNumber(encryptedCardNumber).setEncryptedExpiryMonth(encryptedExpiryMonth).setEncryptedExpiryYear(encryptedExpiryYear).setEncryptedSecurityCode(encryptedSecurityCode);
        return this;
    }

    public PaymentRequest setCardHolder(String cardHolder) {
        if (this.card == null) {
            this.card = new Card();
        }
        this.card.setHolderName(cardHolder);
        return this;
    }

    public PaymentRequest setEncryptedCardNumber(String encryptedCardNumber) {
        this.getOrCreateAdditionalData().put("encryptedCardNumber", encryptedCardNumber);
        return this;
    }

    public PaymentRequest setEncryptedExpiryMonth(String encryptedExpiryMonth) {
        this.getOrCreateAdditionalData().put("encryptedExpiryMonth", encryptedExpiryMonth);
        return this;
    }

    public PaymentRequest setEncryptedExpiryYear(String encryptedExpiryYear) {
        this.getOrCreateAdditionalData().put("encryptedExpiryYear", encryptedExpiryYear);
        return this;
    }

    public PaymentRequest setEncryptedSecurityCode(String encryptedSecurityCode) {
        this.getOrCreateAdditionalData().put("encryptedSecurityCode", encryptedSecurityCode);
        return this;
    }

    public PaymentRequest setPaymentToken(String paymentToken) {
        this.getOrCreateAdditionalData().put("payment.token", paymentToken);
        return this;
    }

    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    public PaymentRequest setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    public ThreeDS2RequestData getThreeDS2RequestData() {
        return this.threeDS2RequestData;
    }

    public void setThreeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
    }

    public PaymentRequest setInvoiceLines(List<InvoiceLine> invoiceLines) {
        Integer count = 1;
        for (InvoiceLine invoiceLine : invoiceLines) {
            StringBuilder sb = new StringBuilder();
            sb.append("openinvoicedata.line");
            sb.append(Integer.toString(count));
            String lineNumber = sb.toString();
            this.getOrCreateAdditionalData().put(lineNumber + ".currencyCode", invoiceLine.getCurrencyCode());
            this.getOrCreateAdditionalData().put(lineNumber + ".description", invoiceLine.getDescription());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemAmount", invoiceLine.getItemAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemVatAmount", invoiceLine.getItemVATAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemVatPercentage", invoiceLine.getItemVatPercentage().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".numberOfItems", Integer.toString(invoiceLine.getNumberOfItems()));
            this.getOrCreateAdditionalData().put(lineNumber + ".vatCategory", invoiceLine.getVatCategory().toString());
            if (invoiceLine.getItemId() != null && !invoiceLine.getItemId().isEmpty()) {
                this.getOrCreateAdditionalData().put(lineNumber + ".itemId", invoiceLine.getItemId());
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.getOrCreateAdditionalData().put("openinvoicedata.numberOfLines", Integer.toString(invoiceLines.size()));
        return this;
    }

    public PaymentRequest setSplitPayment(SplitPayment splitPayment) {
        this.getOrCreateAdditionalData().put("split.api", splitPayment.getApi().toString());
        this.getOrCreateAdditionalData().put("split.totalAmount", splitPayment.getTotalAmount().toString());
        this.getOrCreateAdditionalData().put("split.currencyCode", splitPayment.getCurrencyCode());
        Integer count = 1;
        for (SplitPaymentItem splitPaymentItem : splitPayment.getSplitPaymentItems()) {
            StringBuilder sb = new StringBuilder();
            sb.append("split.item");
            sb.append(Integer.toString(count));
            String lineNumber = sb.toString();
            this.getOrCreateAdditionalData().put(lineNumber + ".amount", splitPaymentItem.getAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".type", splitPaymentItem.getType());
            this.getOrCreateAdditionalData().put(lineNumber + ".account", splitPaymentItem.getAccount());
            this.getOrCreateAdditionalData().put(lineNumber + ".reference", splitPaymentItem.getReference());
            this.getOrCreateAdditionalData().put(lineNumber + ".description", splitPaymentItem.getDescription());
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.getOrCreateAdditionalData().put("split.nrOfItems", Integer.toString(splitPayment.getSplitPaymentItems().size()));
        return this;
    }

    public PaymentRequest card(Card card) {
        this.card = card;
        return this;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public PaymentRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public PaymentRequest bankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public PaymentRequest store(String store) {
        this.store = store;
        return this;
    }

    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public MerchantRiskIndicator getMerchantRiskIndicator() {
        return this.merchantRiskIndicator;
    }

    public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
    }

    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public Boolean getTrustedShopper() {
        return this.trustedShopper;
    }

    public void setTrustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRequest paymentRequest = (PaymentRequest)o;
        return Objects.equals(this.accountInfo, paymentRequest.accountInfo) && Objects.equals(this.bankAccount, paymentRequest.bankAccount) && Objects.equals(this.card, paymentRequest.card) && Objects.equals(this.merchantRiskIndicator, paymentRequest.merchantRiskIndicator) && Objects.equals(this.mpiData, paymentRequest.mpiData) && Objects.equals((Object)this.recurringProcessingModel, (Object)paymentRequest.recurringProcessingModel) && Objects.equals(this.splits, paymentRequest.splits) && Objects.equals(this.store, paymentRequest.store) && Objects.equals(this.threeDS2RequestData, paymentRequest.threeDS2RequestData) && Objects.equals(this.trustedShopper, paymentRequest.trustedShopper);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.card, this.mpiData, this.bankAccount, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRequest {\n");
        sb.append("    accountInfo: ").append(this.toIndentedString(this.accountInfo)).append("\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    merchantRiskIndicator: ").append(this.toIndentedString(this.merchantRiskIndicator)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    trustedShopper: ").append(this.toIndentedString(this.trustedShopper)).append("\n");
        sb.append("    threeDS2RequestData: ").append(this.toIndentedString(this.threeDS2RequestData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RecurringProcessingModelEnum {
        SUBSCRIPTION("Subscription"),
        CARD_ON_FILE("CardOnFile"),
        UNSCHEDULED_CARD_ON_FILE("UnscheduledCardOnFile");

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

