/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpay;

import com.adyen.model.marketpay.Account;
import com.adyen.model.marketpay.AccountContainer;
import com.adyen.model.marketpay.AccountHolderDetails;
import com.adyen.model.marketpay.AccountHolderStatus;
import com.adyen.model.marketpay.AccountStateRequirement;
import com.adyen.model.marketpay.KYCVerificationResult;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GetAccountHolderResponse {
    @SerializedName(value="verification")
    private KYCVerificationResult verification = null;
    @SerializedName(value="submittedAsync")
    private Boolean submittedAsync = null;
    @SerializedName(value="accountHolderCode")
    private String accountHolderCode = null;
    @SerializedName(value="requirementsForNextAccountState")
    private List<AccountStateRequirement> requirementsForNextAccountState = new ArrayList<AccountStateRequirement>();
    @SerializedName(value="accountHolderDetails")
    private AccountHolderDetails accountHolderDetails = null;
    @SerializedName(value="accountHolderStatus")
    private AccountHolderStatus accountHolderStatus = null;
    @SerializedName(value="accounts")
    private List<AccountContainer> accountContainers = null;
    private transient List<Account> accounts = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="pspReference")
    private String pspReference = null;
    @SerializedName(value="legalEntity")
    private LegalEntityEnum legalEntity = null;
    @SerializedName(value="primaryCurrency")
    private String primaryCurrency = null;

    public GetAccountHolderResponse verificationResult(KYCVerificationResult verificationResult) {
        this.verification = verificationResult;
        return this;
    }

    public KYCVerificationResult getVerificationResult() {
        return this.verification;
    }

    public KYCVerificationResult getVerification() {
        return this.verification;
    }

    public void setVerification(KYCVerificationResult verification) {
        this.verification = verification;
    }

    public GetAccountHolderResponse submittedAsync(Boolean submittedAsync) {
        this.submittedAsync = submittedAsync;
        return this;
    }

    public Boolean getSubmittedAsync() {
        return this.submittedAsync;
    }

    public void setSubmittedAsync(Boolean submittedAsync) {
        this.submittedAsync = submittedAsync;
    }

    public GetAccountHolderResponse accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public GetAccountHolderResponse requirementsForNextAccountState(List<AccountStateRequirement> requirementsForNextAccountState) {
        this.requirementsForNextAccountState = requirementsForNextAccountState;
        return this;
    }

    public GetAccountHolderResponse addRequirementsForNextAccountStateItem(AccountStateRequirement requirementsForNextAccountStateItem) {
        this.requirementsForNextAccountState.add(requirementsForNextAccountStateItem);
        return this;
    }

    public List<AccountStateRequirement> getRequirementsForNextAccountState() {
        return this.requirementsForNextAccountState;
    }

    public void setRequirementsForNextAccountState(List<AccountStateRequirement> requirementsForNextAccountState) {
        this.requirementsForNextAccountState = requirementsForNextAccountState;
    }

    public GetAccountHolderResponse accountHolderDetails(AccountHolderDetails accountHolderDetails) {
        this.accountHolderDetails = accountHolderDetails;
        return this;
    }

    public AccountHolderDetails getAccountHolderDetails() {
        return this.accountHolderDetails;
    }

    public void setAccountHolderDetails(AccountHolderDetails accountHolderDetails) {
        this.accountHolderDetails = accountHolderDetails;
    }

    public GetAccountHolderResponse accountHolderStatus(AccountHolderStatus accountHolderStatus) {
        this.accountHolderStatus = accountHolderStatus;
        return this;
    }

    public AccountHolderStatus getAccountHolderStatus() {
        return this.accountHolderStatus;
    }

    public void setAccountHolderStatus(AccountHolderStatus accountHolderStatus) {
        this.accountHolderStatus = accountHolderStatus;
    }

    public List<Account> getAccounts() {
        if (this.accounts == null) {
            this.accounts = new ArrayList<Account>();
            if (this.accountContainers != null && !this.accountContainers.isEmpty()) {
                for (AccountContainer accountContainer : this.accountContainers) {
                    this.accounts.add(accountContainer.getAccount());
                }
            }
        }
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
        this.accountContainers = new ArrayList<AccountContainer>();
        for (Account account : accounts) {
            AccountContainer accountContainer = new AccountContainer(account);
            this.accountContainers.add(accountContainer);
        }
    }

    public GetAccountHolderResponse addAccount(Account account) {
        AccountContainer accountContainer = new AccountContainer(account);
        if (this.accountContainers == null) {
            this.accountContainers = new ArrayList<AccountContainer>();
        }
        this.accountContainers.add(accountContainer);
        if (this.accounts == null) {
            this.accounts = new ArrayList<Account>();
        }
        this.accounts.add(account);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GetAccountHolderResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public GetAccountHolderResponse legalEntity(LegalEntityEnum legalEntity) {
        this.legalEntity = legalEntity;
        return this;
    }

    public LegalEntityEnum getLegalEntity() {
        return this.legalEntity;
    }

    public void setLegalEntity(LegalEntityEnum legalEntity) {
        this.legalEntity = legalEntity;
    }

    public String getPrimaryCurrency() {
        return this.primaryCurrency;
    }

    public void setPrimaryCurrency(String primaryCurrency) {
        this.primaryCurrency = primaryCurrency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAccountHolderResponse getAccountHolderResponse = (GetAccountHolderResponse)o;
        return Objects.equals(this.verification, getAccountHolderResponse.verification) && Objects.equals(this.submittedAsync, getAccountHolderResponse.submittedAsync) && Objects.equals(this.accountHolderCode, getAccountHolderResponse.accountHolderCode) && Objects.equals(this.requirementsForNextAccountState, getAccountHolderResponse.requirementsForNextAccountState) && Objects.equals(this.accountHolderDetails, getAccountHolderResponse.accountHolderDetails) && Objects.equals(this.accountHolderStatus, getAccountHolderResponse.accountHolderStatus) && Objects.equals(this.accountContainers, getAccountHolderResponse.accountContainers) && Objects.equals(this.description, getAccountHolderResponse.description) && Objects.equals(this.pspReference, getAccountHolderResponse.pspReference) && Objects.equals((Object)this.legalEntity, (Object)getAccountHolderResponse.legalEntity) && Objects.equals(this.primaryCurrency, getAccountHolderResponse.primaryCurrency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.verification, this.submittedAsync, this.accountHolderCode, this.requirementsForNextAccountState, this.accountHolderDetails, this.accountHolderStatus, this.accountContainers, this.description, this.pspReference, this.legalEntity, this.primaryCurrency});
    }

    public String toString() {
        this.getAccounts();
        StringBuilder sb = new StringBuilder();
        sb.append("class GetAccountHolderResponse {\n");
        sb.append("    verification: ").append(this.toIndentedString(this.verification)).append("\n");
        sb.append("    submittedAsync: ").append(this.toIndentedString(this.submittedAsync)).append("\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    requirementsForNextAccountState: ").append(this.toIndentedString(this.requirementsForNextAccountState)).append("\n");
        sb.append("    accountHolderDetails: ").append(this.toIndentedString(this.accountHolderDetails)).append("\n");
        sb.append("    accountHolderStatus: ").append(this.toIndentedString(this.accountHolderStatus)).append("\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    legalEntity: ").append(this.toIndentedString((Object)this.legalEntity)).append("\n");
        sb.append("    primaryCurrency: ").append(this.toIndentedString(this.primaryCurrency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LegalEntityEnum {
        BUSINESS("Business"),
        INDIVIDUAL("Individual");

        private String value;

        private LegalEntityEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

