/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.CreateCompanyWebhookRequest;
import com.adyen.model.management.GenerateHmacKeyResponse;
import com.adyen.model.management.JSON;
import com.adyen.model.management.ListWebhooksResponse;
import com.adyen.model.management.TestCompanyWebhookRequest;
import com.adyen.model.management.TestWebhookResponse;
import com.adyen.model.management.UpdateCompanyWebhookRequest;
import com.adyen.model.management.Webhook;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WebhooksCompanyLevel
extends ApiKeyAuthenticatedService {
    public WebhooksCompanyLevel(Client client) {
        super(client);
        new JSON();
    }

    public void removeWebhook(String companyId, String webhookId) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("webhookId", webhookId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/webhooks/{webhookId}");
        resource.request(requestBody, null, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public ListWebhooksResponse listAllWebhooks(String companyId, Map<String, String> queryParams) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/webhooks");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListWebhooksResponse.fromJson(jsonResult);
    }

    public Webhook getWebhook(String companyId, String webhookId) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("webhookId", webhookId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/webhooks/{webhookId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return Webhook.fromJson(jsonResult);
    }

    public Webhook updateWebhook(String companyId, String webhookId, UpdateCompanyWebhookRequest updateCompanyWebhookRequest) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("webhookId", webhookId);
        String requestBody = updateCompanyWebhookRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/webhooks/{webhookId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return Webhook.fromJson(jsonResult);
    }

    public Webhook setUpWebhook(String companyId, CreateCompanyWebhookRequest createCompanyWebhookRequest) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = createCompanyWebhookRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/webhooks");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return Webhook.fromJson(jsonResult);
    }

    public GenerateHmacKeyResponse generateHmacKey(String companyId, String webhookId) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("webhookId", webhookId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/webhooks/{webhookId}/generateHmac");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return GenerateHmacKeyResponse.fromJson(jsonResult);
    }

    public TestWebhookResponse testWebhook(String companyId, String webhookId, TestCompanyWebhookRequest testCompanyWebhookRequest) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("webhookId", webhookId);
        String requestBody = testCompanyWebhookRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/webhooks/{webhookId}/test");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return TestWebhookResponse.fromJson(jsonResult);
    }
}

