/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.CreateMerchantUserRequest;
import com.adyen.model.management.CreateUserResponse;
import com.adyen.model.management.JSON;
import com.adyen.model.management.ListMerchantUsersResponse;
import com.adyen.model.management.UpdateMerchantUserRequest;
import com.adyen.model.management.User;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UsersMerchantLevel
extends ApiKeyAuthenticatedService {
    public UsersMerchantLevel(Client client) {
        super(client);
        new JSON();
    }

    public ListMerchantUsersResponse listUsers(String merchantId, Map<String, String> queryParams) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/users");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListMerchantUsersResponse.fromJson(jsonResult);
    }

    public User getUserDetails(String merchantId, String userId) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("userId", userId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/users/{userId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return User.fromJson(jsonResult);
    }

    public User updateUser(String merchantId, String userId, UpdateMerchantUserRequest updateMerchantUserRequest) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("userId", userId);
        String requestBody = updateMerchantUserRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/users/{userId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return User.fromJson(jsonResult);
    }

    public CreateUserResponse createNewUser(String merchantId, CreateMerchantUserRequest createMerchantUserRequest) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = createMerchantUserRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/users");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return CreateUserResponse.fromJson(jsonResult);
    }
}

