/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.JSON;
import com.adyen.model.management.PayoutSettings;
import com.adyen.model.management.PayoutSettingsRequest;
import com.adyen.model.management.PayoutSettingsResponse;
import com.adyen.model.management.UpdatePayoutSettingsRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;

public class PayoutSettingsMerchantLevel
extends ApiKeyAuthenticatedService {
    public PayoutSettingsMerchantLevel(Client client) {
        super(client);
        new JSON();
    }

    public void deletePayoutSetting(String merchantId, String payoutSettingsId) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (payoutSettingsId == null) {
            throw new ApiException("Missing the required parameter 'payoutSettingsId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("payoutSettingsId", payoutSettingsId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/payoutSettings/{payoutSettingsId}");
        resource.request(requestBody, null, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public PayoutSettingsResponse listPayoutSettings(String merchantId) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/payoutSettings");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return PayoutSettingsResponse.fromJson(jsonResult);
    }

    public PayoutSettings getPayoutSetting(String merchantId, String payoutSettingsId) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (payoutSettingsId == null) {
            throw new ApiException("Missing the required parameter 'payoutSettingsId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("payoutSettingsId", payoutSettingsId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/payoutSettings/{payoutSettingsId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return PayoutSettings.fromJson(jsonResult);
    }

    public PayoutSettings updatePayoutSetting(String merchantId, String payoutSettingsId, UpdatePayoutSettingsRequest updatePayoutSettingsRequest) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (payoutSettingsId == null) {
            throw new ApiException("Missing the required parameter 'payoutSettingsId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("payoutSettingsId", payoutSettingsId);
        String requestBody = updatePayoutSettingsRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/payoutSettings/{payoutSettingsId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return PayoutSettings.fromJson(jsonResult);
    }

    public PayoutSettings addPayoutSetting(String merchantId, PayoutSettingsRequest payoutSettingsRequest) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = payoutSettingsRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/payoutSettings");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return PayoutSettings.fromJson(jsonResult);
    }
}

