/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.ApiCredential;
import com.adyen.model.management.CreateApiCredentialResponse;
import com.adyen.model.management.CreateMerchantApiCredentialRequest;
import com.adyen.model.management.JSON;
import com.adyen.model.management.ListMerchantApiCredentialsResponse;
import com.adyen.model.management.UpdateMerchantApiCredentialRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ApiCredentialsMerchantLevel
extends ApiKeyAuthenticatedService {
    public ApiCredentialsMerchantLevel(Client client) {
        super(client);
        new JSON();
    }

    public ListMerchantApiCredentialsResponse listApiCredentials(String merchantId, Map<String, String> queryParams) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/apiCredentials");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListMerchantApiCredentialsResponse.fromJson(jsonResult);
    }

    public ApiCredential getApiCredential(String merchantId, String apiCredentialId) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (apiCredentialId == null) {
            throw new ApiException("Missing the required parameter 'apiCredentialId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("apiCredentialId", apiCredentialId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/apiCredentials/{apiCredentialId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return ApiCredential.fromJson(jsonResult);
    }

    public ApiCredential updateApiCredential(String merchantId, String apiCredentialId, UpdateMerchantApiCredentialRequest updateMerchantApiCredentialRequest) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (apiCredentialId == null) {
            throw new ApiException("Missing the required parameter 'apiCredentialId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("apiCredentialId", apiCredentialId);
        String requestBody = updateMerchantApiCredentialRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/apiCredentials/{apiCredentialId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return ApiCredential.fromJson(jsonResult);
    }

    public CreateApiCredentialResponse createApiCredential(String merchantId, CreateMerchantApiCredentialRequest createMerchantApiCredentialRequest) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = createMerchantApiCredentialRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/apiCredentials");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return CreateApiCredentialResponse.fromJson(jsonResult);
    }
}

