/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.recurring;

import com.adyen.model.recurring.Address;
import com.adyen.model.recurring.Amount;
import com.adyen.model.recurring.BankAccount;
import com.adyen.model.recurring.Card;
import com.adyen.model.recurring.CreatePermitRequest;
import com.adyen.model.recurring.CreatePermitResult;
import com.adyen.model.recurring.DisablePermitRequest;
import com.adyen.model.recurring.DisablePermitResult;
import com.adyen.model.recurring.DisableRequest;
import com.adyen.model.recurring.DisableResult;
import com.adyen.model.recurring.Name;
import com.adyen.model.recurring.NotifyShopperRequest;
import com.adyen.model.recurring.NotifyShopperResult;
import com.adyen.model.recurring.Permit;
import com.adyen.model.recurring.PermitRestriction;
import com.adyen.model.recurring.PermitResult;
import com.adyen.model.recurring.Recurring;
import com.adyen.model.recurring.RecurringDetail;
import com.adyen.model.recurring.RecurringDetailsRequest;
import com.adyen.model.recurring.RecurringDetailsResult;
import com.adyen.model.recurring.ScheduleAccountUpdaterRequest;
import com.adyen.model.recurring.ScheduleAccountUpdaterResult;
import com.adyen.model.recurring.ServiceError;
import com.adyen.model.recurring.TokenDetails;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.GsonFireBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson;
    private static DateTypeAdapter dateTypeAdapter;
    private static SqlDateTypeAdapter sqlDateTypeAdapter;
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter;
    private static LocalDateTypeAdapter localDateTypeAdapter;
    private static ByteArrayAdapter byteArrayAdapter;

    public JSON() {
        GsonBuilder gsonBuilder = JSON.createGson();
        gsonBuilder.registerTypeAdapter(java.util.Date.class, (Object)dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(Date.class, (Object)sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, (Object)offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, (Object)byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Address.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Amount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new BankAccount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Card.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CreatePermitRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new CreatePermitResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new DisablePermitRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new DisablePermitResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new DisableRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new DisableResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Name.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new NotifyShopperRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new NotifyShopperResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Permit.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new PermitRestriction.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new PermitResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new Recurring.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new RecurringDetail.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new RecurringDetailsRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new RecurringDetailsResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ScheduleAccountUpdaterRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ScheduleAccountUpdaterResult.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ServiceError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new TokenDetails.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder();
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class)classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(body));
                jsonReader.setLenient(true);
                return (T)gson.fromJson(jsonReader, returnType);
            }
            return (T)gson.fromJson(body, returnType);
        }
        catch (JsonParseException e) {
            if (returnType.equals(String.class)) {
                return (T)body;
            }
            throw e;
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }

    static {
        isLenientOnJson = false;
        dateTypeAdapter = new DateTypeAdapter();
        sqlDateTypeAdapter = new SqlDateTypeAdapter();
        offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
        localDateTypeAdapter = new LocalDateTypeAdapter();
        byteArrayAdapter = new ByteArrayAdapter();
    }

    public static class DateTypeAdapter
    extends TypeAdapter<java.util.Date> {
        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, java.util.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format((java.util.Date)date, (boolean)true);
                out.value(value);
            }
        }

        public java.util.Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        public Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new Date(this.dateFormat.parse(date).getTime());
                }
                return new Date(ISO8601Utils.parse((String)date, (ParsePosition)new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }

    public static class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            return LocalDate.parse(date, this.formatter);
        }
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            if (date.endsWith("+0000")) {
                date = date.substring(0, date.length() - 5) + "Z";
            }
            return OffsetDateTime.parse(date, this.formatter);
        }
    }

    public static class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(new String(value));
            }
        }

        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String bytesAsBase64 = in.nextString();
            return Base64.decodeBase64((String)bytesAsBase64);
        }
    }
}

