/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Recurring {
    public static final String SERIALIZED_NAME_CONTRACT = "contract";
    @SerializedName(value="contract")
    private ContractEnum contract;
    public static final String SERIALIZED_NAME_RECURRING_DETAIL_NAME = "recurringDetailName";
    @SerializedName(value="recurringDetailName")
    private String recurringDetailName;
    public static final String SERIALIZED_NAME_RECURRING_EXPIRY = "recurringExpiry";
    @SerializedName(value="recurringExpiry")
    private OffsetDateTime recurringExpiry;
    public static final String SERIALIZED_NAME_RECURRING_FREQUENCY = "recurringFrequency";
    @SerializedName(value="recurringFrequency")
    private String recurringFrequency;
    public static final String SERIALIZED_NAME_TOKEN_SERVICE = "tokenService";
    @SerializedName(value="tokenService")
    private TokenServiceEnum tokenService;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Recurring contract(ContractEnum contract) {
        this.contract = contract;
        return this;
    }

    @ApiModelProperty(value="The type of recurring contract to be used. Possible values: * `ONECLICK` \u2013 Payment details can be used to initiate a one-click payment, where the shopper enters the [card security code (CVC/CVV)](https://docs.adyen.com/payments-fundamentals/payment-glossary#card-security-code-cvc-cvv-cid). * `RECURRING` \u2013 Payment details can be used without the card security code to initiate [card-not-present transactions](https://docs.adyen.com/payments-fundamentals/payment-glossary#card-not-present-cnp). * `ONECLICK,RECURRING` \u2013 Payment details can be used regardless of whether the shopper is on your site or not. * `PAYOUT` \u2013 Payment details can be used to [make a payout](https://docs.adyen.com/online-payments/online-payouts).")
    public ContractEnum getContract() {
        return this.contract;
    }

    public void setContract(ContractEnum contract) {
        this.contract = contract;
    }

    public Recurring recurringDetailName(String recurringDetailName) {
        this.recurringDetailName = recurringDetailName;
        return this;
    }

    @ApiModelProperty(value="A descriptive name for this detail.")
    public String getRecurringDetailName() {
        return this.recurringDetailName;
    }

    public void setRecurringDetailName(String recurringDetailName) {
        this.recurringDetailName = recurringDetailName;
    }

    public Recurring recurringExpiry(OffsetDateTime recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
        return this;
    }

    @ApiModelProperty(value="Date after which no further authorisations shall be performed. Only for 3D Secure 2.")
    public OffsetDateTime getRecurringExpiry() {
        return this.recurringExpiry;
    }

    public void setRecurringExpiry(OffsetDateTime recurringExpiry) {
        this.recurringExpiry = recurringExpiry;
    }

    public Recurring recurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
        return this;
    }

    @ApiModelProperty(value="Minimum number of days between authorisations. Only for 3D Secure 2.")
    public String getRecurringFrequency() {
        return this.recurringFrequency;
    }

    public void setRecurringFrequency(String recurringFrequency) {
        this.recurringFrequency = recurringFrequency;
    }

    public Recurring tokenService(TokenServiceEnum tokenService) {
        this.tokenService = tokenService;
        return this;
    }

    @ApiModelProperty(value="The name of the token service.")
    public TokenServiceEnum getTokenService() {
        return this.tokenService;
    }

    public void setTokenService(TokenServiceEnum tokenService) {
        this.tokenService = tokenService;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recurring recurring = (Recurring)o;
        return Objects.equals((Object)this.contract, (Object)recurring.contract) && Objects.equals(this.recurringDetailName, recurring.recurringDetailName) && Objects.equals(this.recurringExpiry, recurring.recurringExpiry) && Objects.equals(this.recurringFrequency, recurring.recurringFrequency) && Objects.equals((Object)this.tokenService, (Object)recurring.tokenService);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contract, this.recurringDetailName, this.recurringExpiry, this.recurringFrequency, this.tokenService});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recurring {\n");
        sb.append("    contract: ").append(this.toIndentedString((Object)this.contract)).append("\n");
        sb.append("    recurringDetailName: ").append(this.toIndentedString(this.recurringDetailName)).append("\n");
        sb.append("    recurringExpiry: ").append(this.toIndentedString(this.recurringExpiry)).append("\n");
        sb.append("    recurringFrequency: ").append(this.toIndentedString(this.recurringFrequency)).append("\n");
        sb.append("    tokenService: ").append(this.toIndentedString((Object)this.tokenService)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Recurring is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Recurring` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTRACT) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONTRACT).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `contract` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTRACT).toString()));
            }
            ContractEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CONTRACT).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_NAME) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recurringDetailName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recurringFrequency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_FREQUENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOKEN_SERVICE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TOKEN_SERVICE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `tokenService` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOKEN_SERVICE).toString()));
            }
            TokenServiceEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TOKEN_SERVICE).getAsString());
        }
    }

    public static Recurring fromJson(String jsonString) throws IOException {
        return (Recurring)JSON.getGson().fromJson(jsonString, Recurring.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTRACT);
        openapiFields.add(SERIALIZED_NAME_RECURRING_DETAIL_NAME);
        openapiFields.add(SERIALIZED_NAME_RECURRING_EXPIRY);
        openapiFields.add(SERIALIZED_NAME_RECURRING_FREQUENCY);
        openapiFields.add(SERIALIZED_NAME_TOKEN_SERVICE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Recurring.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Recurring.class));
            return new TypeAdapter<Recurring>(){

                public void write(JsonWriter out, Recurring value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Recurring read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Recurring.validateJsonObject(jsonObj);
                    return (Recurring)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TokenServiceEnum {
        VISATOKENSERVICE("VISATOKENSERVICE"),
        MCTOKENSERVICE("MCTOKENSERVICE");

        private String value;

        private TokenServiceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TokenServiceEnum fromValue(String value) {
            for (TokenServiceEnum b : TokenServiceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TokenServiceEnum> {
            public void write(JsonWriter jsonWriter, TokenServiceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TokenServiceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TokenServiceEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContractEnum {
        ONECLICK("ONECLICK"),
        RECURRING("RECURRING"),
        PAYOUT("PAYOUT");

        private String value;

        private ContractEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContractEnum fromValue(String value) {
            for (ContractEnum b : ContractEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ContractEnum> {
            public void write(JsonWriter jsonWriter, ContractEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ContractEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContractEnum.fromValue(value);
            }
        }
    }
}

