/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payments;

import com.adyen.model.payments.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AdditionalDataCommon {
    public static final String SERIALIZED_NAME_REQUESTED_TEST_ERROR_RESPONSE_CODE = "RequestedTestErrorResponseCode";
    @SerializedName(value="RequestedTestErrorResponseCode")
    private String requestedTestErrorResponseCode;
    public static final String SERIALIZED_NAME_ALLOW_PARTIAL_AUTH = "allowPartialAuth";
    @SerializedName(value="allowPartialAuth")
    private String allowPartialAuth;
    public static final String SERIALIZED_NAME_AUTHORISATION_TYPE = "authorisationType";
    @SerializedName(value="authorisationType")
    private String authorisationType;
    public static final String SERIALIZED_NAME_CUSTOM_ROUTING_FLAG = "customRoutingFlag";
    @SerializedName(value="customRoutingFlag")
    private String customRoutingFlag;
    public static final String SERIALIZED_NAME_INDUSTRY_USAGE = "industryUsage";
    @SerializedName(value="industryUsage")
    private IndustryUsageEnum industryUsage;
    public static final String SERIALIZED_NAME_MANUAL_CAPTURE = "manualCapture";
    @SerializedName(value="manualCapture")
    private String manualCapture;
    public static final String SERIALIZED_NAME_NETWORK_TX_REFERENCE = "networkTxReference";
    @SerializedName(value="networkTxReference")
    private String networkTxReference;
    public static final String SERIALIZED_NAME_OVERWRITE_BRAND = "overwriteBrand";
    @SerializedName(value="overwriteBrand")
    private String overwriteBrand;
    public static final String SERIALIZED_NAME_SUB_MERCHANT_CITY = "subMerchantCity";
    @SerializedName(value="subMerchantCity")
    private String subMerchantCity;
    public static final String SERIALIZED_NAME_SUB_MERCHANT_COUNTRY = "subMerchantCountry";
    @SerializedName(value="subMerchantCountry")
    private String subMerchantCountry;
    public static final String SERIALIZED_NAME_SUB_MERCHANT_I_D = "subMerchantID";
    @SerializedName(value="subMerchantID")
    private String subMerchantID;
    public static final String SERIALIZED_NAME_SUB_MERCHANT_NAME = "subMerchantName";
    @SerializedName(value="subMerchantName")
    private String subMerchantName;
    public static final String SERIALIZED_NAME_SUB_MERCHANT_POSTAL_CODE = "subMerchantPostalCode";
    @SerializedName(value="subMerchantPostalCode")
    private String subMerchantPostalCode;
    public static final String SERIALIZED_NAME_SUB_MERCHANT_STATE = "subMerchantState";
    @SerializedName(value="subMerchantState")
    private String subMerchantState;
    public static final String SERIALIZED_NAME_SUB_MERCHANT_STREET = "subMerchantStreet";
    @SerializedName(value="subMerchantStreet")
    private String subMerchantStreet;
    public static final String SERIALIZED_NAME_SUB_MERCHANT_TAX_ID = "subMerchantTaxId";
    @SerializedName(value="subMerchantTaxId")
    private String subMerchantTaxId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AdditionalDataCommon requestedTestErrorResponseCode(String requestedTestErrorResponseCode) {
        this.requestedTestErrorResponseCode = requestedTestErrorResponseCode;
        return this;
    }

    @ApiModelProperty(value="Triggers test scenarios that allow to replicate certain communication errors.  Allowed values: * **NO_CONNECTION_AVAILABLE** \u2013 There wasn't a connection available to service the outgoing communication. This is a transient, retriable error since no messaging could be initiated to an issuing system (or third-party acquiring system). Therefore, the header Transient-Error: true is returned in the response. A subsequent request using the same idempotency key will be processed as if it was the first request. * **IOEXCEPTION_RECEIVED** \u2013 Something went wrong during transmission of the message or receiving the response. This is a classified as non-transient because the message could have been received by the issuing party and been acted upon. No transient error header is returned. If using idempotency, the (error) response is stored as the final result for the idempotency key. Subsequent messages with the same idempotency key not be processed beyond returning the stored response.")
    public String getRequestedTestErrorResponseCode() {
        return this.requestedTestErrorResponseCode;
    }

    public void setRequestedTestErrorResponseCode(String requestedTestErrorResponseCode) {
        this.requestedTestErrorResponseCode = requestedTestErrorResponseCode;
    }

    public AdditionalDataCommon allowPartialAuth(String allowPartialAuth) {
        this.allowPartialAuth = allowPartialAuth;
        return this;
    }

    @ApiModelProperty(value="Set to true to authorise a part of the requested amount in case the cardholder does not have enough funds on their account.  If a payment was partially authorised, the response includes resultCode: PartiallyAuthorised and the authorised amount in additionalData.authorisedAmountValue. To enable this functionality, contact our Support Team.")
    public String getAllowPartialAuth() {
        return this.allowPartialAuth;
    }

    public void setAllowPartialAuth(String allowPartialAuth) {
        this.allowPartialAuth = allowPartialAuth;
    }

    public AdditionalDataCommon authorisationType(String authorisationType) {
        this.authorisationType = authorisationType;
        return this;
    }

    @ApiModelProperty(value="Flags a card payment request for either pre-authorisation or final authorisation. For more information, refer to [Authorisation types](https://docs.adyen.com/online-payments/adjust-authorisation#authorisation-types).  Allowed values: * **PreAuth** \u2013 flags the payment request to be handled as a pre-authorisation. * **FinalAuth** \u2013 flags the payment request to be handled as a final authorisation.")
    public String getAuthorisationType() {
        return this.authorisationType;
    }

    public void setAuthorisationType(String authorisationType) {
        this.authorisationType = authorisationType;
    }

    public AdditionalDataCommon customRoutingFlag(String customRoutingFlag) {
        this.customRoutingFlag = customRoutingFlag;
        return this;
    }

    @ApiModelProperty(value="Allows you to determine or override the acquirer account that should be used for the transaction.  If you need to process a payment with an acquirer different from a default one, you can set up a corresponding configuration on the Adyen payments platform. Then you can pass a custom routing flag in a payment request's additional data to target a specific acquirer.  To enable this functionality, contact [Support](https://www.adyen.help/hc/en-us/requests/new).")
    public String getCustomRoutingFlag() {
        return this.customRoutingFlag;
    }

    public void setCustomRoutingFlag(String customRoutingFlag) {
        this.customRoutingFlag = customRoutingFlag;
    }

    public AdditionalDataCommon industryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
        return this;
    }

    @ApiModelProperty(value="In case of [asynchronous authorisation adjustment](https://docs.adyen.com/online-payments/adjust-authorisation#adjust-authorisation), this field denotes why the additional payment is made.  Possible values:   * **NoShow**: An incremental charge is carried out because of a no-show for a guaranteed reservation.   * **DelayedCharge**: An incremental charge is carried out to process an additional payment after the original services have been rendered and the respective payment has been processed.")
    public IndustryUsageEnum getIndustryUsage() {
        return this.industryUsage;
    }

    public void setIndustryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
    }

    public AdditionalDataCommon manualCapture(String manualCapture) {
        this.manualCapture = manualCapture;
        return this;
    }

    @ApiModelProperty(value="Set to **true** to require [manual capture](https://docs.adyen.com/online-payments/capture) for the transaction.")
    public String getManualCapture() {
        return this.manualCapture;
    }

    public void setManualCapture(String manualCapture) {
        this.manualCapture = manualCapture;
    }

    public AdditionalDataCommon networkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
        return this;
    }

    @ApiModelProperty(value="Allows you to link the transaction to the original or previous one in a subscription/card-on-file chain. This field is required for token-based transactions where Adyen does not tokenize the card.  Transaction identifier from card schemes, for example, Mastercard Trace ID or the Visa Transaction ID.  Submit the original transaction ID of the contract in your payment request if you are not tokenizing card details with Adyen and are making a merchant-initiated transaction (MIT) for subsequent charges.  Make sure you are sending `shopperInteraction` **ContAuth** and `recurringProcessingModel` **Subscription** or **UnscheduledCardOnFile** to ensure that the transaction is classified as MIT.")
    public String getNetworkTxReference() {
        return this.networkTxReference;
    }

    public void setNetworkTxReference(String networkTxReference) {
        this.networkTxReference = networkTxReference;
    }

    public AdditionalDataCommon overwriteBrand(String overwriteBrand) {
        this.overwriteBrand = overwriteBrand;
        return this;
    }

    @ApiModelProperty(value="Boolean indicator that can be optionally used for performing debit transactions on combo cards (for example, combo cards in Brazil). This is not mandatory but we recommend that you set this to true if you want to use the `selectedBrand` value to specify how to process the transaction.")
    public String getOverwriteBrand() {
        return this.overwriteBrand;
    }

    public void setOverwriteBrand(String overwriteBrand) {
        this.overwriteBrand = overwriteBrand;
    }

    public AdditionalDataCommon subMerchantCity(String subMerchantCity) {
        this.subMerchantCity = subMerchantCity;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the city of the actual merchant's address. * Format: alpha-numeric. * Maximum length: 13 characters.")
    public String getSubMerchantCity() {
        return this.subMerchantCity;
    }

    public void setSubMerchantCity(String subMerchantCity) {
        this.subMerchantCity = subMerchantCity;
    }

    public AdditionalDataCommon subMerchantCountry(String subMerchantCountry) {
        this.subMerchantCountry = subMerchantCountry;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the three-letter country code of the actual merchant's address. * Format: alpha-numeric. * Fixed length: 3 characters.")
    public String getSubMerchantCountry() {
        return this.subMerchantCountry;
    }

    public void setSubMerchantCountry(String subMerchantCountry) {
        this.subMerchantCountry = subMerchantCountry;
    }

    public AdditionalDataCommon subMerchantID(String subMerchantID) {
        this.subMerchantID = subMerchantID;
        return this;
    }

    @ApiModelProperty(value="This field contains an identifier of the actual merchant when a transaction is submitted via a payment facilitator. The payment facilitator must send in this unique ID.  A unique identifier per submerchant that is required if the transaction is performed by a registered payment facilitator. * Format: alpha-numeric. * Fixed length: 15 characters.")
    public String getSubMerchantID() {
        return this.subMerchantID;
    }

    public void setSubMerchantID(String subMerchantID) {
        this.subMerchantID = subMerchantID;
    }

    public AdditionalDataCommon subMerchantName(String subMerchantName) {
        this.subMerchantName = subMerchantName;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the name of the actual merchant. * Format: alpha-numeric. * Maximum length: 22 characters.")
    public String getSubMerchantName() {
        return this.subMerchantName;
    }

    public void setSubMerchantName(String subMerchantName) {
        this.subMerchantName = subMerchantName;
    }

    public AdditionalDataCommon subMerchantPostalCode(String subMerchantPostalCode) {
        this.subMerchantPostalCode = subMerchantPostalCode;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the postal code of the actual merchant's address. * Format: alpha-numeric. * Maximum length: 10 characters.")
    public String getSubMerchantPostalCode() {
        return this.subMerchantPostalCode;
    }

    public void setSubMerchantPostalCode(String subMerchantPostalCode) {
        this.subMerchantPostalCode = subMerchantPostalCode;
    }

    public AdditionalDataCommon subMerchantState(String subMerchantState) {
        this.subMerchantState = subMerchantState;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator, and if applicable to the country. This field must contain the state code of the actual merchant's address. * Format: alpha-numeric. * Maximum length: 3 characters.")
    public String getSubMerchantState() {
        return this.subMerchantState;
    }

    public void setSubMerchantState(String subMerchantState) {
        this.subMerchantState = subMerchantState;
    }

    public AdditionalDataCommon subMerchantStreet(String subMerchantStreet) {
        this.subMerchantStreet = subMerchantStreet;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the street of the actual merchant's address. * Format: alpha-numeric. * Maximum length: 60 characters.")
    public String getSubMerchantStreet() {
        return this.subMerchantStreet;
    }

    public void setSubMerchantStreet(String subMerchantStreet) {
        this.subMerchantStreet = subMerchantStreet;
    }

    public AdditionalDataCommon subMerchantTaxId(String subMerchantTaxId) {
        this.subMerchantTaxId = subMerchantTaxId;
        return this;
    }

    @ApiModelProperty(value="This field is required if the transaction is performed by a registered payment facilitator. This field must contain the tax ID of the actual merchant. * Format: alpha-numeric. * Fixed length: 11 or 14 characters.")
    public String getSubMerchantTaxId() {
        return this.subMerchantTaxId;
    }

    public void setSubMerchantTaxId(String subMerchantTaxId) {
        this.subMerchantTaxId = subMerchantTaxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalDataCommon additionalDataCommon = (AdditionalDataCommon)o;
        return Objects.equals(this.requestedTestErrorResponseCode, additionalDataCommon.requestedTestErrorResponseCode) && Objects.equals(this.allowPartialAuth, additionalDataCommon.allowPartialAuth) && Objects.equals(this.authorisationType, additionalDataCommon.authorisationType) && Objects.equals(this.customRoutingFlag, additionalDataCommon.customRoutingFlag) && Objects.equals((Object)this.industryUsage, (Object)additionalDataCommon.industryUsage) && Objects.equals(this.manualCapture, additionalDataCommon.manualCapture) && Objects.equals(this.networkTxReference, additionalDataCommon.networkTxReference) && Objects.equals(this.overwriteBrand, additionalDataCommon.overwriteBrand) && Objects.equals(this.subMerchantCity, additionalDataCommon.subMerchantCity) && Objects.equals(this.subMerchantCountry, additionalDataCommon.subMerchantCountry) && Objects.equals(this.subMerchantID, additionalDataCommon.subMerchantID) && Objects.equals(this.subMerchantName, additionalDataCommon.subMerchantName) && Objects.equals(this.subMerchantPostalCode, additionalDataCommon.subMerchantPostalCode) && Objects.equals(this.subMerchantState, additionalDataCommon.subMerchantState) && Objects.equals(this.subMerchantStreet, additionalDataCommon.subMerchantStreet) && Objects.equals(this.subMerchantTaxId, additionalDataCommon.subMerchantTaxId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestedTestErrorResponseCode, this.allowPartialAuth, this.authorisationType, this.customRoutingFlag, this.industryUsage, this.manualCapture, this.networkTxReference, this.overwriteBrand, this.subMerchantCity, this.subMerchantCountry, this.subMerchantID, this.subMerchantName, this.subMerchantPostalCode, this.subMerchantState, this.subMerchantStreet, this.subMerchantTaxId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalDataCommon {\n");
        sb.append("    requestedTestErrorResponseCode: ").append(this.toIndentedString(this.requestedTestErrorResponseCode)).append("\n");
        sb.append("    allowPartialAuth: ").append(this.toIndentedString(this.allowPartialAuth)).append("\n");
        sb.append("    authorisationType: ").append(this.toIndentedString(this.authorisationType)).append("\n");
        sb.append("    customRoutingFlag: ").append(this.toIndentedString(this.customRoutingFlag)).append("\n");
        sb.append("    industryUsage: ").append(this.toIndentedString((Object)this.industryUsage)).append("\n");
        sb.append("    manualCapture: ").append(this.toIndentedString(this.manualCapture)).append("\n");
        sb.append("    networkTxReference: ").append(this.toIndentedString(this.networkTxReference)).append("\n");
        sb.append("    overwriteBrand: ").append(this.toIndentedString(this.overwriteBrand)).append("\n");
        sb.append("    subMerchantCity: ").append(this.toIndentedString(this.subMerchantCity)).append("\n");
        sb.append("    subMerchantCountry: ").append(this.toIndentedString(this.subMerchantCountry)).append("\n");
        sb.append("    subMerchantID: ").append(this.toIndentedString(this.subMerchantID)).append("\n");
        sb.append("    subMerchantName: ").append(this.toIndentedString(this.subMerchantName)).append("\n");
        sb.append("    subMerchantPostalCode: ").append(this.toIndentedString(this.subMerchantPostalCode)).append("\n");
        sb.append("    subMerchantState: ").append(this.toIndentedString(this.subMerchantState)).append("\n");
        sb.append("    subMerchantStreet: ").append(this.toIndentedString(this.subMerchantStreet)).append("\n");
        sb.append("    subMerchantTaxId: ").append(this.toIndentedString(this.subMerchantTaxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AdditionalDataCommon is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AdditionalDataCommon` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUESTED_TEST_ERROR_RESPONSE_CODE) != null && !jsonObj.get(SERIALIZED_NAME_REQUESTED_TEST_ERROR_RESPONSE_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `RequestedTestErrorResponseCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUESTED_TEST_ERROR_RESPONSE_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOW_PARTIAL_AUTH) != null && !jsonObj.get(SERIALIZED_NAME_ALLOW_PARTIAL_AUTH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowPartialAuth` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOW_PARTIAL_AUTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AUTHORISATION_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_AUTHORISATION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `authorisationType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUTHORISATION_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOM_ROUTING_FLAG) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOM_ROUTING_FLAG).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `customRoutingFlag` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOM_ROUTING_FLAG).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INDUSTRY_USAGE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INDUSTRY_USAGE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `industryUsage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INDUSTRY_USAGE).toString()));
            }
            IndustryUsageEnum.fromValue(jsonObj.get(SERIALIZED_NAME_INDUSTRY_USAGE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_MANUAL_CAPTURE) != null && !jsonObj.get(SERIALIZED_NAME_MANUAL_CAPTURE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `manualCapture` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MANUAL_CAPTURE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_TX_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_TX_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `networkTxReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_TX_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OVERWRITE_BRAND) != null && !jsonObj.get(SERIALIZED_NAME_OVERWRITE_BRAND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `overwriteBrand` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OVERWRITE_BRAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_CITY) != null && !jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_CITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subMerchantCity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subMerchantCountry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_I_D) != null && !jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subMerchantID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_NAME) != null && !jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subMerchantName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_POSTAL_CODE) != null && !jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_POSTAL_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subMerchantPostalCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_POSTAL_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_STATE) != null && !jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subMerchantState` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_STATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_STREET) != null && !jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_STREET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subMerchantStreet` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_STREET).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_TAX_ID) != null && !jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_TAX_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subMerchantTaxId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_MERCHANT_TAX_ID).toString()));
        }
    }

    public static AdditionalDataCommon fromJson(String jsonString) throws IOException {
        return (AdditionalDataCommon)JSON.getGson().fromJson(jsonString, AdditionalDataCommon.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_REQUESTED_TEST_ERROR_RESPONSE_CODE);
        openapiFields.add(SERIALIZED_NAME_ALLOW_PARTIAL_AUTH);
        openapiFields.add(SERIALIZED_NAME_AUTHORISATION_TYPE);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_ROUTING_FLAG);
        openapiFields.add(SERIALIZED_NAME_INDUSTRY_USAGE);
        openapiFields.add(SERIALIZED_NAME_MANUAL_CAPTURE);
        openapiFields.add(SERIALIZED_NAME_NETWORK_TX_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_OVERWRITE_BRAND);
        openapiFields.add(SERIALIZED_NAME_SUB_MERCHANT_CITY);
        openapiFields.add(SERIALIZED_NAME_SUB_MERCHANT_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_SUB_MERCHANT_I_D);
        openapiFields.add(SERIALIZED_NAME_SUB_MERCHANT_NAME);
        openapiFields.add(SERIALIZED_NAME_SUB_MERCHANT_POSTAL_CODE);
        openapiFields.add(SERIALIZED_NAME_SUB_MERCHANT_STATE);
        openapiFields.add(SERIALIZED_NAME_SUB_MERCHANT_STREET);
        openapiFields.add(SERIALIZED_NAME_SUB_MERCHANT_TAX_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AdditionalDataCommon.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AdditionalDataCommon.class));
            return new TypeAdapter<AdditionalDataCommon>(){

                public void write(JsonWriter out, AdditionalDataCommon value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AdditionalDataCommon read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AdditionalDataCommon.validateJsonObject(jsonObj);
                    return (AdditionalDataCommon)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IndustryUsageEnum {
        NOSHOW("NoShow"),
        DELAYEDCHARGE("DelayedCharge");

        private String value;

        private IndustryUsageEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IndustryUsageEnum fromValue(String value) {
            for (IndustryUsageEnum b : IndustryUsageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<IndustryUsageEnum> {
            public void write(JsonWriter jsonWriter, IndustryUsageEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IndustryUsageEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IndustryUsageEnum.fromValue(value);
            }
        }
    }
}

