/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.ModelConfiguration;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Surcharge {
    public static final String SERIALIZED_NAME_ASK_CONFIRMATION = "askConfirmation";
    @SerializedName(value="askConfirmation")
    private Boolean askConfirmation;
    public static final String SERIALIZED_NAME_CONFIGURATIONS = "configurations";
    @SerializedName(value="configurations")
    private List<ModelConfiguration> configurations = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Surcharge askConfirmation(Boolean askConfirmation) {
        this.askConfirmation = askConfirmation;
        return this;
    }

    @ApiModelProperty(value="Show the surcharge details on the terminal, so the shopper can confirm.")
    public Boolean getAskConfirmation() {
        return this.askConfirmation;
    }

    public void setAskConfirmation(Boolean askConfirmation) {
        this.askConfirmation = askConfirmation;
    }

    public Surcharge configurations(List<ModelConfiguration> configurations) {
        this.configurations = configurations;
        return this;
    }

    public Surcharge addConfigurationsItem(ModelConfiguration configurationsItem) {
        if (this.configurations == null) {
            this.configurations = new ArrayList<ModelConfiguration>();
        }
        this.configurations.add(configurationsItem);
        return this;
    }

    @ApiModelProperty(value="Surcharge fees or percentages for specific payment methods, funding sources (credit or debit), and currencies.")
    public List<ModelConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<ModelConfiguration> configurations) {
        this.configurations = configurations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Surcharge surcharge = (Surcharge)o;
        return Objects.equals(this.askConfirmation, surcharge.askConfirmation) && Objects.equals(this.configurations, surcharge.configurations);
    }

    public int hashCode() {
        return Objects.hash(this.askConfirmation, this.configurations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Surcharge {\n");
        sb.append("    askConfirmation: ").append(this.toIndentedString(this.askConfirmation)).append("\n");
        sb.append("    configurations: ").append(this.toIndentedString(this.configurations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Surcharge is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Surcharge` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        JsonArray jsonArrayconfigurations = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONFIGURATIONS);
        if (jsonArrayconfigurations != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONFIGURATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `configurations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIGURATIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconfigurations.size(); ++i) {
                ModelConfiguration.validateJsonObject(jsonArrayconfigurations.get(i).getAsJsonObject());
            }
        }
    }

    public static Surcharge fromJson(String jsonString) throws IOException {
        return (Surcharge)JSON.getGson().fromJson(jsonString, Surcharge.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ASK_CONFIRMATION);
        openapiFields.add(SERIALIZED_NAME_CONFIGURATIONS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Surcharge.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Surcharge.class));
            return new TypeAdapter<Surcharge>(){

                public void write(JsonWriter out, Surcharge value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Surcharge read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Surcharge.validateJsonObject(jsonObj);
                    return (Surcharge)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

