/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.Links;
import com.adyen.model.management.StoreLocation;
import com.adyen.model.management.StoreSplitConfiguration;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Store {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    private Links links;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private StoreLocation address;
    public static final String SERIALIZED_NAME_BUSINESS_LINE_IDS = "businessLineIds";
    @SerializedName(value="businessLineIds")
    private List<String> businessLineIds = null;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EXTERNAL_REFERENCE_ID = "externalReferenceId";
    @SerializedName(value="externalReferenceId")
    private String externalReferenceId;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_MERCHANT_ID = "merchantId";
    @SerializedName(value="merchantId")
    private String merchantId;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phoneNumber";
    @SerializedName(value="phoneNumber")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SHOPPER_STATEMENT = "shopperStatement";
    @SerializedName(value="shopperStatement")
    private String shopperStatement;
    public static final String SERIALIZED_NAME_SPLIT_CONFIGURATION = "splitConfiguration";
    @SerializedName(value="splitConfiguration")
    private StoreSplitConfiguration splitConfiguration;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Store links(Links links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public Store address(StoreLocation address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    public StoreLocation getAddress() {
        return this.address;
    }

    public void setAddress(StoreLocation address) {
        this.address = address;
    }

    public Store businessLineIds(List<String> businessLineIds) {
        this.businessLineIds = businessLineIds;
        return this;
    }

    public Store addBusinessLineIdsItem(String businessLineIdsItem) {
        if (this.businessLineIds == null) {
            this.businessLineIds = new ArrayList<String>();
        }
        this.businessLineIds.add(businessLineIdsItem);
        return this;
    }

    @ApiModelProperty(value="The unique identifiers of the [business lines](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/businesslines__resParam_id) that the store is associated with.  If not specified, the business line of the merchant account is used. Required when there are multiple business lines under the merchant account.")
    public List<String> getBusinessLineIds() {
        return this.businessLineIds;
    }

    public void setBusinessLineIds(List<String> businessLineIds) {
        this.businessLineIds = businessLineIds;
    }

    public Store description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The description of the store.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Store externalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
        return this;
    }

    @ApiModelProperty(value="When using the Zip payment method: The location ID that Zip has assigned to your store.")
    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public Store id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the store. This value is generated by Adyen.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Store merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the merchant account that the store belongs to.")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public Store phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number of the store, including '+' and country code.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Store reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="A reference to recognize the store by. Also known as the store code.  Allowed characters: Lowercase and uppercase letters without diacritics, numbers 0 through 9, hyphen (-), and underscore (_)")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Store shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @ApiModelProperty(value="The store name shown on the shopper's bank or credit card statement and on the shopper receipt.")
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public Store splitConfiguration(StoreSplitConfiguration splitConfiguration) {
        this.splitConfiguration = splitConfiguration;
        return this;
    }

    @ApiModelProperty(value="")
    public StoreSplitConfiguration getSplitConfiguration() {
        return this.splitConfiguration;
    }

    public void setSplitConfiguration(StoreSplitConfiguration splitConfiguration) {
        this.splitConfiguration = splitConfiguration;
    }

    public Store status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the store. Possible values are:  - **active**. This value is assigned automatically when a store is created.  - **inactive**. The terminals under the store are blocked from accepting new transactions, but capturing outstanding transactions is still possible. - **closed**. This status is irreversible. The terminals under the store are reassigned to the merchant inventory.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Store store = (Store)o;
        return Objects.equals(this.links, store.links) && Objects.equals(this.address, store.address) && Objects.equals(this.businessLineIds, store.businessLineIds) && Objects.equals(this.description, store.description) && Objects.equals(this.externalReferenceId, store.externalReferenceId) && Objects.equals(this.id, store.id) && Objects.equals(this.merchantId, store.merchantId) && Objects.equals(this.phoneNumber, store.phoneNumber) && Objects.equals(this.reference, store.reference) && Objects.equals(this.shopperStatement, store.shopperStatement) && Objects.equals(this.splitConfiguration, store.splitConfiguration) && Objects.equals((Object)this.status, (Object)store.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.links, this.address, this.businessLineIds, this.description, this.externalReferenceId, this.id, this.merchantId, this.phoneNumber, this.reference, this.shopperStatement, this.splitConfiguration, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Store {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    businessLineIds: ").append(this.toIndentedString(this.businessLineIds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    externalReferenceId: ").append(this.toIndentedString(this.externalReferenceId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    splitConfiguration: ").append(this.toIndentedString(this.splitConfiguration)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Store is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Store` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS) != null) {
            Links.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_LINKS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS) != null) {
            StoreLocation.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_IDS) != null && !jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `businessLineIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID) != null && !jsonObj.get(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `externalReferenceId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ID) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperStatement` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SPLIT_CONFIGURATION) != null) {
            StoreSplitConfiguration.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SPLIT_CONFIGURATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
    }

    public static Store fromJson(String jsonString) throws IOException {
        return (Store)JSON.getGson().fromJson(jsonString, Store.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LINKS);
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_BUSINESS_LINE_IDS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_EXTERNAL_REFERENCE_ID);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ID);
        openapiFields.add(SERIALIZED_NAME_PHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_STATEMENT);
        openapiFields.add(SERIALIZED_NAME_SPLIT_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Store.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Store.class));
            return new TypeAdapter<Store>(){

                public void write(JsonWriter out, Store value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Store read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Store.validateJsonObject(jsonObj);
                    return (Store)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        CLOSED("closed"),
        INACTIVE("inactive");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

