/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Address;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.PhoneNumber;
import com.adyen.model.legalentitymanagement.StockData;
import com.adyen.model.legalentitymanagement.TaxInformation;
import com.adyen.model.legalentitymanagement.TaxReportingClassification;
import com.adyen.model.legalentitymanagement.WebData;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Organization {
    public static final String SERIALIZED_NAME_DATE_OF_INCORPORATION = "dateOfIncorporation";
    @SerializedName(value="dateOfIncorporation")
    private String dateOfIncorporation;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DOING_BUSINESS_AS = "doingBusinessAs";
    @SerializedName(value="doingBusinessAs")
    private String doingBusinessAs;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_LEGAL_NAME = "legalName";
    @SerializedName(value="legalName")
    private String legalName;
    public static final String SERIALIZED_NAME_PHONE = "phone";
    @SerializedName(value="phone")
    private PhoneNumber phone;
    public static final String SERIALIZED_NAME_PRINCIPAL_PLACE_OF_BUSINESS = "principalPlaceOfBusiness";
    @SerializedName(value="principalPlaceOfBusiness")
    private Address principalPlaceOfBusiness;
    public static final String SERIALIZED_NAME_REGISTERED_ADDRESS = "registeredAddress";
    @SerializedName(value="registeredAddress")
    private Address registeredAddress;
    public static final String SERIALIZED_NAME_REGISTRATION_NUMBER = "registrationNumber";
    @SerializedName(value="registrationNumber")
    private String registrationNumber;
    public static final String SERIALIZED_NAME_STOCK_DATA = "stockData";
    @SerializedName(value="stockData")
    private StockData stockData;
    public static final String SERIALIZED_NAME_TAX_INFORMATION = "taxInformation";
    @SerializedName(value="taxInformation")
    private List<TaxInformation> taxInformation = null;
    public static final String SERIALIZED_NAME_TAX_REPORTING_CLASSIFICATION = "taxReportingClassification";
    @SerializedName(value="taxReportingClassification")
    private TaxReportingClassification taxReportingClassification;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_VAT_ABSENCE_REASON = "vatAbsenceReason";
    @SerializedName(value="vatAbsenceReason")
    private VatAbsenceReasonEnum vatAbsenceReason;
    public static final String SERIALIZED_NAME_VAT_NUMBER = "vatNumber";
    @SerializedName(value="vatNumber")
    private String vatNumber;
    public static final String SERIALIZED_NAME_WEB_DATA = "webData";
    @SerializedName(value="webData")
    private WebData webData;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Organization dateOfIncorporation(String dateOfIncorporation) {
        this.dateOfIncorporation = dateOfIncorporation;
        return this;
    }

    @ApiModelProperty(value="The date when the organization was incorporated in YYYY-MM-DD format.")
    public String getDateOfIncorporation() {
        return this.dateOfIncorporation;
    }

    public void setDateOfIncorporation(String dateOfIncorporation) {
        this.dateOfIncorporation = dateOfIncorporation;
    }

    public Organization description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the organization.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Organization doingBusinessAs(String doingBusinessAs) {
        this.doingBusinessAs = doingBusinessAs;
        return this;
    }

    @ApiModelProperty(value="The organization's trading name, if different from the registered legal name.")
    public String getDoingBusinessAs() {
        return this.doingBusinessAs;
    }

    public void setDoingBusinessAs(String doingBusinessAs) {
        this.doingBusinessAs = doingBusinessAs;
    }

    public Organization email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the legal entity.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Organization legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @ApiModelProperty(required=true, value="The organization's legal name.")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public Organization phone(PhoneNumber phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="")
    public PhoneNumber getPhone() {
        return this.phone;
    }

    public void setPhone(PhoneNumber phone) {
        this.phone = phone;
    }

    public Organization principalPlaceOfBusiness(Address principalPlaceOfBusiness) {
        this.principalPlaceOfBusiness = principalPlaceOfBusiness;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getPrincipalPlaceOfBusiness() {
        return this.principalPlaceOfBusiness;
    }

    public void setPrincipalPlaceOfBusiness(Address principalPlaceOfBusiness) {
        this.principalPlaceOfBusiness = principalPlaceOfBusiness;
    }

    public Organization registeredAddress(Address registeredAddress) {
        this.registeredAddress = registeredAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getRegisteredAddress() {
        return this.registeredAddress;
    }

    public void setRegisteredAddress(Address registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public Organization registrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
        return this;
    }

    @ApiModelProperty(value="The organization's registration number.")
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public Organization stockData(StockData stockData) {
        this.stockData = stockData;
        return this;
    }

    @ApiModelProperty(value="")
    public StockData getStockData() {
        return this.stockData;
    }

    public void setStockData(StockData stockData) {
        this.stockData = stockData;
    }

    public Organization taxInformation(List<TaxInformation> taxInformation) {
        this.taxInformation = taxInformation;
        return this;
    }

    public Organization addTaxInformationItem(TaxInformation taxInformationItem) {
        if (this.taxInformation == null) {
            this.taxInformation = new ArrayList<TaxInformation>();
        }
        this.taxInformation.add(taxInformationItem);
        return this;
    }

    @ApiModelProperty(value="The tax information of the organization.")
    public List<TaxInformation> getTaxInformation() {
        return this.taxInformation;
    }

    public void setTaxInformation(List<TaxInformation> taxInformation) {
        this.taxInformation = taxInformation;
    }

    public Organization taxReportingClassification(TaxReportingClassification taxReportingClassification) {
        this.taxReportingClassification = taxReportingClassification;
        return this;
    }

    @ApiModelProperty(value="")
    public TaxReportingClassification getTaxReportingClassification() {
        return this.taxReportingClassification;
    }

    public void setTaxReportingClassification(TaxReportingClassification taxReportingClassification) {
        this.taxReportingClassification = taxReportingClassification;
    }

    public Organization type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of organization.   Possible values: **associationIncorporated**, **governmentalOrganization**, **listedPublicCompany**, **nonProfit**, **partnershipIncorporated**, **privateCompany**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Organization vatAbsenceReason(VatAbsenceReasonEnum vatAbsenceReason) {
        this.vatAbsenceReason = vatAbsenceReason;
        return this;
    }

    @ApiModelProperty(value="The reason the organization has not provided a VAT number.  Possible values: **industryExemption**, **belowTaxThreshold**.")
    public VatAbsenceReasonEnum getVatAbsenceReason() {
        return this.vatAbsenceReason;
    }

    public void setVatAbsenceReason(VatAbsenceReasonEnum vatAbsenceReason) {
        this.vatAbsenceReason = vatAbsenceReason;
    }

    public Organization vatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
        return this;
    }

    @ApiModelProperty(value="The organization's VAT number.")
    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public Organization webData(WebData webData) {
        this.webData = webData;
        return this;
    }

    @ApiModelProperty(value="")
    public WebData getWebData() {
        return this.webData;
    }

    public void setWebData(WebData webData) {
        this.webData = webData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Organization organization = (Organization)o;
        return Objects.equals(this.dateOfIncorporation, organization.dateOfIncorporation) && Objects.equals(this.description, organization.description) && Objects.equals(this.doingBusinessAs, organization.doingBusinessAs) && Objects.equals(this.email, organization.email) && Objects.equals(this.legalName, organization.legalName) && Objects.equals(this.phone, organization.phone) && Objects.equals(this.principalPlaceOfBusiness, organization.principalPlaceOfBusiness) && Objects.equals(this.registeredAddress, organization.registeredAddress) && Objects.equals(this.registrationNumber, organization.registrationNumber) && Objects.equals(this.stockData, organization.stockData) && Objects.equals(this.taxInformation, organization.taxInformation) && Objects.equals(this.taxReportingClassification, organization.taxReportingClassification) && Objects.equals((Object)this.type, (Object)organization.type) && Objects.equals((Object)this.vatAbsenceReason, (Object)organization.vatAbsenceReason) && Objects.equals(this.vatNumber, organization.vatNumber) && Objects.equals(this.webData, organization.webData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateOfIncorporation, this.description, this.doingBusinessAs, this.email, this.legalName, this.phone, this.principalPlaceOfBusiness, this.registeredAddress, this.registrationNumber, this.stockData, this.taxInformation, this.taxReportingClassification, this.type, this.vatAbsenceReason, this.vatNumber, this.webData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Organization {\n");
        sb.append("    dateOfIncorporation: ").append(this.toIndentedString(this.dateOfIncorporation)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    doingBusinessAs: ").append(this.toIndentedString(this.doingBusinessAs)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    principalPlaceOfBusiness: ").append(this.toIndentedString(this.principalPlaceOfBusiness)).append("\n");
        sb.append("    registeredAddress: ").append(this.toIndentedString(this.registeredAddress)).append("\n");
        sb.append("    registrationNumber: ").append(this.toIndentedString(this.registrationNumber)).append("\n");
        sb.append("    stockData: ").append(this.toIndentedString(this.stockData)).append("\n");
        sb.append("    taxInformation: ").append(this.toIndentedString(this.taxInformation)).append("\n");
        sb.append("    taxReportingClassification: ").append(this.toIndentedString(this.taxReportingClassification)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    vatAbsenceReason: ").append(this.toIndentedString((Object)this.vatAbsenceReason)).append("\n");
        sb.append("    vatNumber: ").append(this.toIndentedString(this.vatNumber)).append("\n");
        sb.append("    webData: ").append(this.toIndentedString(this.webData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraytaxInformation;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Organization is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Organization` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATE_OF_INCORPORATION) != null && !jsonObj.get(SERIALIZED_NAME_DATE_OF_INCORPORATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `dateOfIncorporation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATE_OF_INCORPORATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOING_BUSINESS_AS) != null && !jsonObj.get(SERIALIZED_NAME_DOING_BUSINESS_AS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `doingBusinessAs` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOING_BUSINESS_AS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LEGAL_NAME) != null && !jsonObj.get(SERIALIZED_NAME_LEGAL_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `legalName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LEGAL_NAME).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PHONE) != null) {
            PhoneNumber.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PHONE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PRINCIPAL_PLACE_OF_BUSINESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PRINCIPAL_PLACE_OF_BUSINESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_REGISTERED_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_REGISTERED_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_REGISTRATION_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_REGISTRATION_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `registrationNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REGISTRATION_NUMBER).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_STOCK_DATA) != null) {
            StockData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STOCK_DATA));
        }
        if ((jsonArraytaxInformation = jsonObj.getAsJsonArray(SERIALIZED_NAME_TAX_INFORMATION)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TAX_INFORMATION).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `taxInformation` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAX_INFORMATION).toString()));
            }
            for (int i = 0; i < jsonArraytaxInformation.size(); ++i) {
                TaxInformation.validateJsonObject(jsonArraytaxInformation.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_TAX_REPORTING_CLASSIFICATION) != null) {
            TaxReportingClassification.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_TAX_REPORTING_CLASSIFICATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_VAT_ABSENCE_REASON) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VAT_ABSENCE_REASON).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `vatAbsenceReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VAT_ABSENCE_REASON).toString()));
            }
            VatAbsenceReasonEnum.fromValue(jsonObj.get(SERIALIZED_NAME_VAT_ABSENCE_REASON).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_VAT_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_VAT_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `vatNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VAT_NUMBER).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WEB_DATA) != null) {
            WebData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WEB_DATA));
        }
    }

    public static Organization fromJson(String jsonString) throws IOException {
        return (Organization)JSON.getGson().fromJson(jsonString, Organization.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DATE_OF_INCORPORATION);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_DOING_BUSINESS_AS);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_LEGAL_NAME);
        openapiFields.add(SERIALIZED_NAME_PHONE);
        openapiFields.add(SERIALIZED_NAME_PRINCIPAL_PLACE_OF_BUSINESS);
        openapiFields.add(SERIALIZED_NAME_REGISTERED_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_REGISTRATION_NUMBER);
        openapiFields.add(SERIALIZED_NAME_STOCK_DATA);
        openapiFields.add(SERIALIZED_NAME_TAX_INFORMATION);
        openapiFields.add(SERIALIZED_NAME_TAX_REPORTING_CLASSIFICATION);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_VAT_ABSENCE_REASON);
        openapiFields.add(SERIALIZED_NAME_VAT_NUMBER);
        openapiFields.add(SERIALIZED_NAME_WEB_DATA);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LEGAL_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_REGISTERED_ADDRESS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Organization.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Organization.class));
            return new TypeAdapter<Organization>(){

                public void write(JsonWriter out, Organization value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Organization read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Organization.validateJsonObject(jsonObj);
                    return (Organization)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VatAbsenceReasonEnum {
        INDUSTRYEXEMPTION("industryExemption"),
        BELOWTAXTHRESHOLD("belowTaxThreshold");

        private String value;

        private VatAbsenceReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VatAbsenceReasonEnum fromValue(String value) {
            for (VatAbsenceReasonEnum b : VatAbsenceReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VatAbsenceReasonEnum> {
            public void write(JsonWriter jsonWriter, VatAbsenceReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VatAbsenceReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VatAbsenceReasonEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ASSOCIATIONINCORPORATED("associationIncorporated"),
        GOVERNMENTALORGANIZATION("governmentalOrganization"),
        LISTEDPUBLICCOMPANY("listedPublicCompany"),
        NONPROFIT("nonProfit"),
        PARTNERSHIPINCORPORATED("partnershipIncorporated"),
        PRIVATECOMPANY("privateCompany");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

