/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CheckoutOrder {
    public static final String SERIALIZED_NAME_ORDER_DATA = "orderData";
    @SerializedName(value="orderData")
    private String orderData;
    public static final String SERIALIZED_NAME_PSP_REFERENCE = "pspReference";
    @SerializedName(value="pspReference")
    private String pspReference;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CheckoutOrder orderData(String orderData) {
        this.orderData = orderData;
        return this;
    }

    @ApiModelProperty(required=true, value="The encrypted order data.")
    public String getOrderData() {
        return this.orderData;
    }

    public void setOrderData(String orderData) {
        this.orderData = orderData;
    }

    public CheckoutOrder pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The `pspReference` that belongs to the order.")
    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutOrder checkoutOrder = (CheckoutOrder)o;
        return Objects.equals(this.orderData, checkoutOrder.orderData) && Objects.equals(this.pspReference, checkoutOrder.pspReference);
    }

    public int hashCode() {
        return Objects.hash(this.orderData, this.pspReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutOrder {\n");
        sb.append("    orderData: ").append(this.toIndentedString(this.orderData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CheckoutOrder is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CheckoutOrder` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_DATA) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `orderData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORDER_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).toString()));
        }
    }

    public static CheckoutOrder fromJson(String jsonString) throws IOException {
        return (CheckoutOrder)JSON.getGson().fromJson(jsonString, CheckoutOrder.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ORDER_DATA);
        openapiFields.add(SERIALIZED_NAME_PSP_REFERENCE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ORDER_DATA);
        openapiRequiredFields.add(SERIALIZED_NAME_PSP_REFERENCE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CheckoutOrder.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CheckoutOrder.class));
            return new TypeAdapter<CheckoutOrder>(){

                public void write(JsonWriter out, CheckoutOrder value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CheckoutOrder read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CheckoutOrder.validateJsonObject(jsonObj);
                    return (CheckoutOrder)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

