/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.JSON;
import com.adyen.model.management.Logo;
import com.adyen.model.management.TerminalSettings;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TerminalSettingsStoreLevel
extends ApiKeyAuthenticatedService {
    public TerminalSettingsStoreLevel(Client client) {
        super(client);
        new JSON();
    }

    public Logo getTheTerminalLogo(String merchantId, String reference, Map<String, String> queryParams) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (reference == null) {
            throw new ApiException("Missing the required parameter 'reference'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("reference", reference);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/stores/{reference}/terminalLogos");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings getTerminalSettings(String merchantId, String reference) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (reference == null) {
            throw new ApiException("Missing the required parameter 'reference'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("reference", reference);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/stores/{reference}/terminalSettings");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    public Logo getTheTerminalLogo(String storeId, Map<String, String> queryParams) throws ApiException, IOException {
        if (storeId == null) {
            throw new ApiException("Missing the required parameter 'storeId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("storeId", storeId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/stores/{storeId}/terminalLogos");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings getTerminalSettings(String storeId) throws ApiException, IOException {
        if (storeId == null) {
            throw new ApiException("Missing the required parameter 'storeId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("storeId", storeId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/stores/{storeId}/terminalSettings");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    public Logo updateTheTerminalLogo(String merchantId, String reference, Logo logo, Map<String, String> queryParams) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (reference == null) {
            throw new ApiException("Missing the required parameter 'reference'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("reference", reference);
        String requestBody = logo.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/stores/{reference}/terminalLogos");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings updateTerminalSettings(String merchantId, String reference, TerminalSettings terminalSettings) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (reference == null) {
            throw new ApiException("Missing the required parameter 'reference'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("reference", reference);
        String requestBody = terminalSettings.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/stores/{reference}/terminalSettings");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }

    public Logo updateTheTerminalLogo(String storeId, Logo logo, Map<String, String> queryParams) throws ApiException, IOException {
        if (storeId == null) {
            throw new ApiException("Missing the required parameter 'storeId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("storeId", storeId);
        String requestBody = logo.toJson();
        ManagementResource resource = new ManagementResource(this, "/stores/{storeId}/terminalLogos");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams, queryParams);
        return Logo.fromJson(jsonResult);
    }

    public TerminalSettings updateTerminalSettings(String storeId, TerminalSettings terminalSettings) throws ApiException, IOException {
        if (storeId == null) {
            throw new ApiException("Missing the required parameter 'storeId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("storeId", storeId);
        String requestBody = terminalSettings.toJson();
        ManagementResource resource = new ManagementResource(this, "/stores/{storeId}/terminalSettings");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalSettings.fromJson(jsonResult);
    }
}

