/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.BillingEntitiesResponse;
import com.adyen.model.management.JSON;
import com.adyen.model.management.ShippingLocation;
import com.adyen.model.management.ShippingLocationsResponse;
import com.adyen.model.management.TerminalModelsResponse;
import com.adyen.model.management.TerminalOrder;
import com.adyen.model.management.TerminalOrderRequest;
import com.adyen.model.management.TerminalOrdersResponse;
import com.adyen.model.management.TerminalProductsResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TerminalOrdersCompanyLevel
extends ApiKeyAuthenticatedService {
    public TerminalOrdersCompanyLevel(Client client) {
        super(client);
        new JSON();
    }

    public BillingEntitiesResponse listBillingEntities(String companyId, Map<String, String> queryParams) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/billingEntities");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return BillingEntitiesResponse.fromJson(jsonResult);
    }

    public ShippingLocationsResponse listShippingLocations(String companyId, Map<String, String> queryParams) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/shippingLocations");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ShippingLocationsResponse.fromJson(jsonResult);
    }

    public TerminalModelsResponse listTerminalModels(String companyId) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/terminalModels");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalModelsResponse.fromJson(jsonResult);
    }

    public TerminalOrdersResponse listOrders(String companyId, Map<String, String> queryParams) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/terminalOrders");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return TerminalOrdersResponse.fromJson(jsonResult);
    }

    public TerminalOrder getOrder(String companyId, String orderId) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("orderId", orderId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/terminalOrders/{orderId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }

    public TerminalProductsResponse listTerminalProducts(String companyId, Map<String, String> queryParams) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/terminalProducts");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return TerminalProductsResponse.fromJson(jsonResult);
    }

    public TerminalOrder updateOrder(String companyId, String orderId, TerminalOrderRequest terminalOrderRequest) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("orderId", orderId);
        String requestBody = terminalOrderRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/terminalOrders/{orderId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }

    public ShippingLocation createShippingLocation(String companyId, ShippingLocation shippingLocation) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = shippingLocation.toJson();
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/shippingLocations");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return ShippingLocation.fromJson(jsonResult);
    }

    public TerminalOrder createOrder(String companyId, TerminalOrderRequest terminalOrderRequest) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = terminalOrderRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/terminalOrders");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }

    public TerminalOrder cancelOrder(String companyId, String orderId) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("orderId", orderId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/terminalOrders/{orderId}/cancel");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return TerminalOrder.fromJson(jsonResult);
    }
}

