/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.ApplePayInfo;
import com.adyen.model.management.JSON;
import com.adyen.model.management.PaymentMethod;
import com.adyen.model.management.PaymentMethodResponse;
import com.adyen.model.management.PaymentMethodSetupInfo;
import com.adyen.model.management.UpdatePaymentMethodInfo;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PaymentMethodsMerchantLevel
extends ApiKeyAuthenticatedService {
    public PaymentMethodsMerchantLevel(Client client) {
        super(client);
        new JSON();
    }

    public PaymentMethodResponse getAllPaymentMethods(String merchantId, Map<String, String> queryParams) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/paymentMethodSettings");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return PaymentMethodResponse.fromJson(jsonResult);
    }

    public PaymentMethod getPaymentMethodDetails(String merchantId, String paymentMethodId) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("paymentMethodId", paymentMethodId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return PaymentMethod.fromJson(jsonResult);
    }

    public ApplePayInfo getApplePayDomains(String merchantId, String paymentMethodId) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("paymentMethodId", paymentMethodId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}/getApplePayDomains");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return ApplePayInfo.fromJson(jsonResult);
    }

    public PaymentMethod updatePaymentMethod(String merchantId, String paymentMethodId, UpdatePaymentMethodInfo updatePaymentMethodInfo) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("paymentMethodId", paymentMethodId);
        String requestBody = updatePaymentMethodInfo.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return PaymentMethod.fromJson(jsonResult);
    }

    public PaymentMethod requestPaymentMethod(String merchantId, PaymentMethodSetupInfo paymentMethodSetupInfo) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        String requestBody = paymentMethodSetupInfo.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/paymentMethodSettings");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return PaymentMethod.fromJson(jsonResult);
    }

    public void addApplePayDomain(String merchantId, String paymentMethodId, ApplePayInfo applePayInfo) throws ApiException, IOException {
        if (merchantId == null) {
            throw new ApiException("Missing the required parameter 'merchantId'", 400);
        }
        if (paymentMethodId == null) {
            throw new ApiException("Missing the required parameter 'paymentMethodId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("merchantId", merchantId);
        pathParams.put("paymentMethodId", paymentMethodId);
        String requestBody = applePayInfo.toJson();
        ManagementResource resource = new ManagementResource(this, "/merchants/{merchantId}/paymentMethodSettings/{paymentMethodId}/addApplePayDomains");
        resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
    }
}

