/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.CounterpartyV3;
import com.adyen.model.transfers.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Transaction {
    public static final String SERIALIZED_NAME_ACCOUNT_HOLDER_ID = "accountHolderId";
    @SerializedName(value="accountHolderId")
    private String accountHolderId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT_ID = "balanceAccountId";
    @SerializedName(value="balanceAccountId")
    private String balanceAccountId;
    public static final String SERIALIZED_NAME_BALANCE_PLATFORM = "balancePlatform";
    @SerializedName(value="balancePlatform")
    private String balancePlatform;
    public static final String SERIALIZED_NAME_BOOKING_DATE = "bookingDate";
    @SerializedName(value="bookingDate")
    private OffsetDateTime bookingDate;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private CategoryEnum category;
    public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
    @SerializedName(value="counterparty")
    private CounterpartyV3 counterparty;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INSTRUCTED_AMOUNT = "instructedAmount";
    @SerializedName(value="instructedAmount")
    private Amount instructedAmount;
    public static final String SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID = "paymentInstrumentId";
    @SerializedName(value="paymentInstrumentId")
    private String paymentInstrumentId;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    @SerializedName(value="referenceForBeneficiary")
    private String referenceForBeneficiary;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_TRANSFER_ID = "transferId";
    @SerializedName(value="transferId")
    private String transferId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_VALUE_DATE = "valueDate";
    @SerializedName(value="valueDate")
    private OffsetDateTime valueDate;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Transaction accountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the account holder.")
    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public Transaction amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public Transaction balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the balance account.")
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public Transaction balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the balance platform.")
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public Transaction bookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the transaction was booked to the balance account.")
    public OffsetDateTime getBookingDate() {
        return this.bookingDate;
    }

    public void setBookingDate(OffsetDateTime bookingDate) {
        this.bookingDate = bookingDate;
    }

    public Transaction category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(value="The category of the transaction indicating the type of activity.   Possible values:  * **platformPayment**: The transaction is a payment or payment modification made with an Adyen merchant account.  * **internal**: The transaction resulted from an internal adjustment such as a deposit correction or invoice deduction.  * **bank**: The transaction is a bank-related activity, such as sending a payout or receiving funds.  * **issuedCard**: The transaction is a card-related activity, such as using an Adyen-issued card to pay online.  ")
    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public Transaction counterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public CounterpartyV3 getCounterparty() {
        return this.counterparty;
    }

    public void setCounterparty(CounterpartyV3 counterparty) {
        this.counterparty = counterparty;
    }

    public Transaction createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the transaction was created.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Transaction description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The `description` from the `/transfers` request.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Transaction id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the transaction.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Transaction instructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public Transaction paymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the payment instrument that was used for the transaction.")
    public String getPaymentInstrumentId() {
        return this.paymentInstrumentId;
    }

    public void setPaymentInstrumentId(String paymentInstrumentId) {
        this.paymentInstrumentId = paymentInstrumentId;
    }

    public Transaction reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="The [`reference`](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__reqParam_reference) from the `/transfers` request. If you haven't provided any, Adyen generates a unique reference.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Transaction referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        return this;
    }

    @ApiModelProperty(value="The reference sent to or received from the counterparty.  * For outgoing funds, this is the [`referenceForBeneficiary`](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__resParam_referenceForBeneficiary) from the  [`/transfers`](https://docs.adyen.com/api-explorer/#/transfers/latest/post/transfers__reqParam_referenceForBeneficiary) request.   * For incoming funds, this is the reference from the sender.")
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
    }

    public Transaction status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="The status of the transaction.   Possible values:  * **pending**: The transaction is still pending.  * **booked**: The transaction has been booked to the balance account.  ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Transaction transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the related transfer.")
    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public Transaction type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the transaction.   Possible values: **payment**, **capture**, **captureReversal**, **refund** **refundReversal**, **chargeback**, **chargebackReversal**, **secondChargeback**, **atmWithdrawal**, **atmWithdrawalReversal**, **internalTransfer**, **manualCorrection**, **invoiceDeduction**, **depositCorrection**, **bankTransfer**, **miscCost**, **paymentCost**, **fee**")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Transaction valueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date the transfer amount becomes available in the balance account.")
    public OffsetDateTime getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(OffsetDateTime valueDate) {
        this.valueDate = valueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction transaction = (Transaction)o;
        return Objects.equals(this.accountHolderId, transaction.accountHolderId) && Objects.equals(this.amount, transaction.amount) && Objects.equals(this.balanceAccountId, transaction.balanceAccountId) && Objects.equals(this.balancePlatform, transaction.balancePlatform) && Objects.equals(this.bookingDate, transaction.bookingDate) && Objects.equals((Object)this.category, (Object)transaction.category) && Objects.equals(this.counterparty, transaction.counterparty) && Objects.equals(this.createdAt, transaction.createdAt) && Objects.equals(this.description, transaction.description) && Objects.equals(this.id, transaction.id) && Objects.equals(this.instructedAmount, transaction.instructedAmount) && Objects.equals(this.paymentInstrumentId, transaction.paymentInstrumentId) && Objects.equals(this.reference, transaction.reference) && Objects.equals(this.referenceForBeneficiary, transaction.referenceForBeneficiary) && Objects.equals((Object)this.status, (Object)transaction.status) && Objects.equals(this.transferId, transaction.transferId) && Objects.equals((Object)this.type, (Object)transaction.type) && Objects.equals(this.valueDate, transaction.valueDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderId, this.amount, this.balanceAccountId, this.balancePlatform, this.bookingDate, this.category, this.counterparty, this.createdAt, this.description, this.id, this.instructedAmount, this.paymentInstrumentId, this.reference, this.referenceForBeneficiary, this.status, this.transferId, this.type, this.valueDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transaction {\n");
        sb.append("    accountHolderId: ").append(this.toIndentedString(this.accountHolderId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    bookingDate: ").append(this.toIndentedString(this.bookingDate)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    paymentInstrumentId: ").append(this.toIndentedString(this.paymentInstrumentId)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    valueDate: ").append(this.toIndentedString(this.valueDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Transaction is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Transaction` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_HOLDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_HOLDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accountHolderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_HOLDER_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `balanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `balancePlatform` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CATEGORY) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CATEGORY).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `category` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CATEGORY).toString()));
            }
            CategoryEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CATEGORY).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY) != null) {
            CounterpartyV3.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_COUNTERPARTY));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INSTRUCTED_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INSTRUCTED_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `paymentInstrumentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `referenceForBeneficiary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSFER_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSFER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transferId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSFER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static Transaction fromJson(String jsonString) throws IOException {
        return (Transaction)JSON.getGson().fromJson(jsonString, Transaction.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_HOLDER_ID);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_BALANCE_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_BOOKING_DATE);
        openapiFields.add(SERIALIZED_NAME_CATEGORY);
        openapiFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INSTRUCTED_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_INSTRUMENT_ID);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFERENCE_FOR_BENEFICIARY);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TRANSFER_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_VALUE_DATE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_HOLDER_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_BALANCE_PLATFORM);
        openapiRequiredFields.add(SERIALIZED_NAME_BOOKING_DATE);
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTERPARTY);
        openapiRequiredFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_REFERENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_VALUE_DATE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Transaction.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Transaction.class));
            return new TypeAdapter<Transaction>(){

                public void write(JsonWriter out, Transaction value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Transaction read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Transaction.validateJsonObject(jsonObj);
                    return (Transaction)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALREVERSAL("atmWithdrawalReversal"),
        BALANCEADJUSTMENT("balanceAdjustment"),
        BALANCEROLLOVER("balanceRollover"),
        BANKTRANSFER("bankTransfer"),
        CAPTURE("capture"),
        CAPTUREREVERSAL("captureReversal"),
        CHARGEBACK("chargeback"),
        CHARGEBACKREVERSAL("chargebackReversal"),
        DEPOSITCORRECTION("depositCorrection"),
        FEE("fee"),
        GRANT("grant"),
        INTERNALTRANSFER("internalTransfer"),
        INVOICEDEDUCTION("invoiceDeduction"),
        LEFTOVER("leftover"),
        MANUALCORRECTION("manualCorrection"),
        MISCCOST("miscCost"),
        PAYMENT("payment"),
        PAYMENTCOST("paymentCost"),
        REFUND("refund"),
        REFUNDREVERSAL("refundReversal"),
        REPAYMENT("repayment"),
        RESERVEADJUSTMENT("reserveAdjustment"),
        SECONDCHARGEBACK("secondChargeback");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        BOOKED("booked"),
        PENDING("pending");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CategoryEnum {
        BANK("bank"),
        GRANTS("grants"),
        INTERNAL("internal"),
        ISSUEDCARD("issuedCard"),
        PLATFORMPAYMENT("platformPayment");

        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CategoryEnum> {
            public void write(JsonWriter jsonWriter, CategoryEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CategoryEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CategoryEnum.fromValue(value);
            }
        }
    }
}

