/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.BankAccountV3;
import com.adyen.model.transfers.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CounterpartyInfoV3 {
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT_ID = "balanceAccountId";
    @SerializedName(value="balanceAccountId")
    private String balanceAccountId;
    public static final String SERIALIZED_NAME_BANK_ACCOUNT = "bankAccount";
    @SerializedName(value="bankAccount")
    private BankAccountV3 bankAccount;
    public static final String SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID = "transferInstrumentId";
    @SerializedName(value="transferInstrumentId")
    private String transferInstrumentId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CounterpartyInfoV3 balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the [balance account](https://docs.adyen.com/api-explorer/#/balanceplatform/latest/post/balanceAccounts__resParam_id).")
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public CounterpartyInfoV3 bankAccount(BankAccountV3 bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @ApiModelProperty(value="")
    public BankAccountV3 getBankAccount() {
        return this.bankAccount;
    }

    public void setBankAccount(BankAccountV3 bankAccount) {
        this.bankAccount = bankAccount;
    }

    public CounterpartyInfoV3 transferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).")
    public String getTransferInstrumentId() {
        return this.transferInstrumentId;
    }

    public void setTransferInstrumentId(String transferInstrumentId) {
        this.transferInstrumentId = transferInstrumentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterpartyInfoV3 counterpartyInfoV3 = (CounterpartyInfoV3)o;
        return Objects.equals(this.balanceAccountId, counterpartyInfoV3.balanceAccountId) && Objects.equals(this.bankAccount, counterpartyInfoV3.bankAccount) && Objects.equals(this.transferInstrumentId, counterpartyInfoV3.transferInstrumentId);
    }

    public int hashCode() {
        return Objects.hash(this.balanceAccountId, this.bankAccount, this.transferInstrumentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CounterpartyInfoV3 {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    transferInstrumentId: ").append(this.toIndentedString(this.transferInstrumentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CounterpartyInfoV3 is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CounterpartyInfoV3` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `balanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BANK_ACCOUNT) != null) {
            BankAccountV3.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BANK_ACCOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `transferInstrumentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID).toString()));
        }
    }

    public static CounterpartyInfoV3 fromJson(String jsonString) throws IOException {
        return (CounterpartyInfoV3)JSON.getGson().fromJson(jsonString, CounterpartyInfoV3.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_BANK_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_TRANSFER_INSTRUMENT_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CounterpartyInfoV3.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CounterpartyInfoV3.class));
            return new TypeAdapter<CounterpartyInfoV3>(){

                public void write(JsonWriter out, CounterpartyInfoV3 value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CounterpartyInfoV3 read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CounterpartyInfoV3.validateJsonObject(jsonObj);
                    return (CounterpartyInfoV3)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

