/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.Amount;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CustomNotification {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_EVENT_CODE = "eventCode";
    @SerializedName(value="eventCode")
    private String eventCode;
    public static final String SERIALIZED_NAME_EVENT_DATE = "eventDate";
    @SerializedName(value="eventDate")
    private OffsetDateTime eventDate;
    public static final String SERIALIZED_NAME_MERCHANT_REFERENCE = "merchantReference";
    @SerializedName(value="merchantReference")
    private String merchantReference;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD = "paymentMethod";
    @SerializedName(value="paymentMethod")
    private String paymentMethod;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_SUCCESS = "success";
    @SerializedName(value="success")
    private Boolean success;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CustomNotification amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CustomNotification eventCode(String eventCode) {
        this.eventCode = eventCode;
        return this;
    }

    @ApiModelProperty(value="The event that caused the notification to be sent.Currently supported values: * **AUTHORISATION** * **CANCELLATION** * **REFUND** * **CAPTURE** * **DEACTIVATE_RECURRING** * **REPORT_AVAILABLE** * **CHARGEBACK** * **REQUEST_FOR_INFORMATION** * **NOTIFICATION_OF_CHARGEBACK** * **NOTIFICATIONTEST** * **ORDER_OPENED** * **ORDER_CLOSED** * **CHARGEBACK_REVERSED** * **REFUNDED_REVERSED** * **REFUND_WITH_DATA**")
    public String getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }

    public CustomNotification eventDate(OffsetDateTime eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @ApiModelProperty(value="The time of the event. Format: [ISO 8601](http://www.w3.org/TR/NOTE-datetime), YYYY-MM-DDThh:mm:ssTZD.")
    public OffsetDateTime getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(OffsetDateTime eventDate) {
        this.eventDate = eventDate;
    }

    public CustomNotification merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the custom test notification.")
    public String getMerchantReference() {
        return this.merchantReference;
    }

    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public CustomNotification paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="The payment method for the payment that the notification is about. Possible values: * **amex** * **visa** * **mc** * **maestro** * **bcmc** * **paypal**  * **sms**  * **bankTransfer_NL** * **bankTransfer_DE** * **bankTransfer_BE** * **ideal** * **elv** * **sepadirectdebit** ")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public CustomNotification reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="A descripton of what caused the notification.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public CustomNotification success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(value="The outcome of the event which the notification is about. Set to either **true** or **false**. ")
    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomNotification customNotification = (CustomNotification)o;
        return Objects.equals(this.amount, customNotification.amount) && Objects.equals(this.eventCode, customNotification.eventCode) && Objects.equals(this.eventDate, customNotification.eventDate) && Objects.equals(this.merchantReference, customNotification.merchantReference) && Objects.equals(this.paymentMethod, customNotification.paymentMethod) && Objects.equals(this.reason, customNotification.reason) && Objects.equals(this.success, customNotification.success);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.eventCode, this.eventDate, this.merchantReference, this.paymentMethod, this.reason, this.success);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomNotification {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    eventCode: ").append(this.toIndentedString(this.eventCode)).append("\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CustomNotification is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CustomNotification` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_EVENT_CODE) != null && !jsonObj.get(SERIALIZED_NAME_EVENT_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `eventCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `paymentMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
        }
    }

    public static CustomNotification fromJson(String jsonString) throws IOException {
        return (CustomNotification)JSON.getGson().fromJson(jsonString, CustomNotification.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_EVENT_CODE);
        openapiFields.add(SERIALIZED_NAME_EVENT_DATE);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_METHOD);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_SUCCESS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CustomNotification.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CustomNotification.class));
            return new TypeAdapter<CustomNotification>(){

                public void write(JsonWriter out, CustomNotification value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CustomNotification read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CustomNotification.validateJsonObject(jsonObj);
                    return (CustomNotification)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

