/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.DocumentReference;
import com.adyen.model.legalentitymanagement.EntityReference;
import com.adyen.model.legalentitymanagement.Individual;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.LegalEntityAssociation;
import com.adyen.model.legalentitymanagement.LegalEntityCapability;
import com.adyen.model.legalentitymanagement.Organization;
import com.adyen.model.legalentitymanagement.SoleProprietorship;
import com.adyen.model.legalentitymanagement.TransferInstrumentReference;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LegalEntity {
    public static final String SERIALIZED_NAME_CAPABILITIES = "capabilities";
    @SerializedName(value="capabilities")
    private Map<String, LegalEntityCapability> capabilities = null;
    public static final String SERIALIZED_NAME_DOCUMENT_DETAILS = "documentDetails";
    @SerializedName(value="documentDetails")
    private List<DocumentReference> documentDetails = null;
    public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
    @SerializedName(value="documents")
    private List<EntityReference> documents = null;
    public static final String SERIALIZED_NAME_ENTITY_ASSOCIATIONS = "entityAssociations";
    @SerializedName(value="entityAssociations")
    private List<LegalEntityAssociation> entityAssociations = null;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INDIVIDUAL = "individual";
    @SerializedName(value="individual")
    private Individual individual;
    public static final String SERIALIZED_NAME_ORGANIZATION = "organization";
    @SerializedName(value="organization")
    private Organization organization;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SOLE_PROPRIETORSHIP = "soleProprietorship";
    @SerializedName(value="soleProprietorship")
    private SoleProprietorship soleProprietorship;
    public static final String SERIALIZED_NAME_TRANSFER_INSTRUMENTS = "transferInstruments";
    @SerializedName(value="transferInstruments")
    private List<TransferInstrumentReference> transferInstruments = null;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LegalEntity() {
    }

    public LegalEntity(Map<String, LegalEntityCapability> capabilities, String id) {
        this();
        this.capabilities = capabilities;
        this.id = id;
    }

    @ApiModelProperty(value="Contains key-value pairs that specify the actions that the legal entity can do in your platform.The key is a capability required for your integration. For example, **issueCard** for Issuing.The value is an object containing the settings for the capability.")
    public Map<String, LegalEntityCapability> getCapabilities() {
        return this.capabilities;
    }

    public LegalEntity documentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
        return this;
    }

    public LegalEntity addDocumentDetailsItem(DocumentReference documentDetailsItem) {
        if (this.documentDetails == null) {
            this.documentDetails = new ArrayList<DocumentReference>();
        }
        this.documentDetails.add(documentDetailsItem);
        return this;
    }

    @ApiModelProperty(value="List of documents uploaded for the legal entity.")
    public List<DocumentReference> getDocumentDetails() {
        return this.documentDetails;
    }

    public void setDocumentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
    }

    public LegalEntity documents(List<EntityReference> documents) {
        this.documents = documents;
        return this;
    }

    public LegalEntity addDocumentsItem(EntityReference documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<EntityReference>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="List of documents uploaded for the legal entity.")
    public List<EntityReference> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<EntityReference> documents) {
        this.documents = documents;
    }

    public LegalEntity entityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
        return this;
    }

    public LegalEntity addEntityAssociationsItem(LegalEntityAssociation entityAssociationsItem) {
        if (this.entityAssociations == null) {
            this.entityAssociations = new ArrayList<LegalEntityAssociation>();
        }
        this.entityAssociations.add(entityAssociationsItem);
        return this;
    }

    @ApiModelProperty(value="List of legal entities associated with the current legal entity. For example, ultimate beneficial owners associated with an organization through ownership or control, or as signatories.")
    public List<LegalEntityAssociation> getEntityAssociations() {
        return this.entityAssociations;
    }

    public void setEntityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the legal entity.")
    public String getId() {
        return this.id;
    }

    public LegalEntity individual(Individual individual) {
        this.individual = individual;
        return this;
    }

    @ApiModelProperty(value="")
    public Individual getIndividual() {
        return this.individual;
    }

    public void setIndividual(Individual individual) {
        this.individual = individual;
    }

    public LegalEntity organization(Organization organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(value="")
    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public LegalEntity reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the legal entity, maximum 150 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public LegalEntity soleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
        return this;
    }

    @ApiModelProperty(value="")
    public SoleProprietorship getSoleProprietorship() {
        return this.soleProprietorship;
    }

    public void setSoleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
    }

    public LegalEntity transferInstruments(List<TransferInstrumentReference> transferInstruments) {
        this.transferInstruments = transferInstruments;
        return this;
    }

    public LegalEntity addTransferInstrumentsItem(TransferInstrumentReference transferInstrumentsItem) {
        if (this.transferInstruments == null) {
            this.transferInstruments = new ArrayList<TransferInstrumentReference>();
        }
        this.transferInstruments.add(transferInstrumentsItem);
        return this;
    }

    @ApiModelProperty(value="List of transfer instruments owned by the legal entity.")
    public List<TransferInstrumentReference> getTransferInstruments() {
        return this.transferInstruments;
    }

    public void setTransferInstruments(List<TransferInstrumentReference> transferInstruments) {
        this.transferInstruments = transferInstruments;
    }

    public LegalEntity type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of legal entity.   Possible values: **individual**, **organization**, or **soleProprietorship**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntity legalEntity = (LegalEntity)o;
        return Objects.equals(this.capabilities, legalEntity.capabilities) && Objects.equals(this.documentDetails, legalEntity.documentDetails) && Objects.equals(this.documents, legalEntity.documents) && Objects.equals(this.entityAssociations, legalEntity.entityAssociations) && Objects.equals(this.id, legalEntity.id) && Objects.equals(this.individual, legalEntity.individual) && Objects.equals(this.organization, legalEntity.organization) && Objects.equals(this.reference, legalEntity.reference) && Objects.equals(this.soleProprietorship, legalEntity.soleProprietorship) && Objects.equals(this.transferInstruments, legalEntity.transferInstruments) && Objects.equals((Object)this.type, (Object)legalEntity.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.documentDetails, this.documents, this.entityAssociations, this.id, this.individual, this.organization, this.reference, this.soleProprietorship, this.transferInstruments, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntity {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    documentDetails: ").append(this.toIndentedString(this.documentDetails)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("    entityAssociations: ").append(this.toIndentedString(this.entityAssociations)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    individual: ").append(this.toIndentedString(this.individual)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    soleProprietorship: ").append(this.toIndentedString(this.soleProprietorship)).append("\n");
        sb.append("    transferInstruments: ").append(this.toIndentedString(this.transferInstruments)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraytransferInstruments;
        JsonArray jsonArrayentityAssociations;
        JsonArray jsonArraydocuments;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in LegalEntity is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `LegalEntity` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArraydocumentDetails = jsonObj.getAsJsonArray(SERIALIZED_NAME_DOCUMENT_DETAILS);
        if (jsonArraydocumentDetails != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DOCUMENT_DETAILS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `documentDetails` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENT_DETAILS).toString()));
            }
            for (int i = 0; i < jsonArraydocumentDetails.size(); ++i) {
                DocumentReference.validateJsonObject(jsonArraydocumentDetails.get(i).getAsJsonObject());
            }
        }
        if ((jsonArraydocuments = jsonObj.getAsJsonArray(SERIALIZED_NAME_DOCUMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DOCUMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `documents` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOCUMENTS).toString()));
            }
            for (int i = 0; i < jsonArraydocuments.size(); ++i) {
                EntityReference.validateJsonObject(jsonArraydocuments.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayentityAssociations = jsonObj.getAsJsonArray(SERIALIZED_NAME_ENTITY_ASSOCIATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ENTITY_ASSOCIATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `entityAssociations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTITY_ASSOCIATIONS).toString()));
            }
            for (int i = 0; i < jsonArrayentityAssociations.size(); ++i) {
                LegalEntityAssociation.validateJsonObject(jsonArrayentityAssociations.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_INDIVIDUAL) != null) {
            Individual.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_INDIVIDUAL));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ORGANIZATION) != null) {
            Organization.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ORGANIZATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SOLE_PROPRIETORSHIP) != null) {
            SoleProprietorship.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SOLE_PROPRIETORSHIP));
        }
        if ((jsonArraytransferInstruments = jsonObj.getAsJsonArray(SERIALIZED_NAME_TRANSFER_INSTRUMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `transferInstruments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TRANSFER_INSTRUMENTS).toString()));
            }
            for (int i = 0; i < jsonArraytransferInstruments.size(); ++i) {
                TransferInstrumentReference.validateJsonObject(jsonArraytransferInstruments.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static LegalEntity fromJson(String jsonString) throws IOException {
        return (LegalEntity)JSON.getGson().fromJson(jsonString, LegalEntity.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CAPABILITIES);
        openapiFields.add(SERIALIZED_NAME_DOCUMENT_DETAILS);
        openapiFields.add(SERIALIZED_NAME_DOCUMENTS);
        openapiFields.add(SERIALIZED_NAME_ENTITY_ASSOCIATIONS);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INDIVIDUAL);
        openapiFields.add(SERIALIZED_NAME_ORGANIZATION);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SOLE_PROPRIETORSHIP);
        openapiFields.add(SERIALIZED_NAME_TRANSFER_INSTRUMENTS);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LegalEntity.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LegalEntity.class));
            return new TypeAdapter<LegalEntity>(){

                public void write(JsonWriter out, LegalEntity value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LegalEntity read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    LegalEntity.validateJsonObject(jsonObj);
                    return (LegalEntity)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        INDIVIDUAL("individual"),
        ORGANIZATION("organization"),
        SOLEPROPRIETORSHIP("soleProprietorship"),
        TRUST("trust"),
        UNINCORPORATEDPARTNERSHIP("unincorporatedPartnership");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

