/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Address;
import com.adyen.model.legalentitymanagement.BirthData;
import com.adyen.model.legalentitymanagement.IdentificationData;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.Name;
import com.adyen.model.legalentitymanagement.PhoneNumber;
import com.adyen.model.legalentitymanagement.TaxInformation;
import com.adyen.model.legalentitymanagement.WebData;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Individual {
    public static final String SERIALIZED_NAME_BIRTH_DATA = "birthData";
    @SerializedName(value="birthData")
    private BirthData birthData;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_IDENTIFICATION_DATA = "identificationData";
    @SerializedName(value="identificationData")
    private IdentificationData identificationData;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private Name name;
    public static final String SERIALIZED_NAME_NATIONALITY = "nationality";
    @SerializedName(value="nationality")
    private String nationality;
    public static final String SERIALIZED_NAME_PHONE = "phone";
    @SerializedName(value="phone")
    private PhoneNumber phone;
    public static final String SERIALIZED_NAME_RESIDENTIAL_ADDRESS = "residentialAddress";
    @SerializedName(value="residentialAddress")
    private Address residentialAddress;
    public static final String SERIALIZED_NAME_TAX_INFORMATION = "taxInformation";
    @SerializedName(value="taxInformation")
    private List<TaxInformation> taxInformation = null;
    public static final String SERIALIZED_NAME_WEB_DATA = "webData";
    @SerializedName(value="webData")
    private WebData webData;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Individual birthData(BirthData birthData) {
        this.birthData = birthData;
        return this;
    }

    @ApiModelProperty(value="")
    public BirthData getBirthData() {
        return this.birthData;
    }

    public void setBirthData(BirthData birthData) {
        this.birthData = birthData;
    }

    public Individual email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the legal entity.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Individual identificationData(IdentificationData identificationData) {
        this.identificationData = identificationData;
        return this;
    }

    @ApiModelProperty(value="")
    public IdentificationData getIdentificationData() {
        return this.identificationData;
    }

    public void setIdentificationData(IdentificationData identificationData) {
        this.identificationData = identificationData;
    }

    public Individual name(Name name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public Individual nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @ApiModelProperty(value="The individual's nationality.")
    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public Individual phone(PhoneNumber phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="")
    public PhoneNumber getPhone() {
        return this.phone;
    }

    public void setPhone(PhoneNumber phone) {
        this.phone = phone;
    }

    public Individual residentialAddress(Address residentialAddress) {
        this.residentialAddress = residentialAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getResidentialAddress() {
        return this.residentialAddress;
    }

    public void setResidentialAddress(Address residentialAddress) {
        this.residentialAddress = residentialAddress;
    }

    public Individual taxInformation(List<TaxInformation> taxInformation) {
        this.taxInformation = taxInformation;
        return this;
    }

    public Individual addTaxInformationItem(TaxInformation taxInformationItem) {
        if (this.taxInformation == null) {
            this.taxInformation = new ArrayList<TaxInformation>();
        }
        this.taxInformation.add(taxInformationItem);
        return this;
    }

    @ApiModelProperty(value="The tax information of the individual.")
    public List<TaxInformation> getTaxInformation() {
        return this.taxInformation;
    }

    public void setTaxInformation(List<TaxInformation> taxInformation) {
        this.taxInformation = taxInformation;
    }

    public Individual webData(WebData webData) {
        this.webData = webData;
        return this;
    }

    @ApiModelProperty(value="")
    public WebData getWebData() {
        return this.webData;
    }

    public void setWebData(WebData webData) {
        this.webData = webData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Individual individual = (Individual)o;
        return Objects.equals(this.birthData, individual.birthData) && Objects.equals(this.email, individual.email) && Objects.equals(this.identificationData, individual.identificationData) && Objects.equals(this.name, individual.name) && Objects.equals(this.nationality, individual.nationality) && Objects.equals(this.phone, individual.phone) && Objects.equals(this.residentialAddress, individual.residentialAddress) && Objects.equals(this.taxInformation, individual.taxInformation) && Objects.equals(this.webData, individual.webData);
    }

    public int hashCode() {
        return Objects.hash(this.birthData, this.email, this.identificationData, this.name, this.nationality, this.phone, this.residentialAddress, this.taxInformation, this.webData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Individual {\n");
        sb.append("    birthData: ").append(this.toIndentedString(this.birthData)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    identificationData: ").append(this.toIndentedString(this.identificationData)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    residentialAddress: ").append(this.toIndentedString(this.residentialAddress)).append("\n");
        sb.append("    taxInformation: ").append(this.toIndentedString(this.taxInformation)).append("\n");
        sb.append("    webData: ").append(this.toIndentedString(this.webData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraytaxInformation;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Individual is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Individual` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BIRTH_DATA) != null) {
            BirthData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BIRTH_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_IDENTIFICATION_DATA) != null) {
            IdentificationData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_IDENTIFICATION_DATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_NATIONALITY) != null && !jsonObj.get(SERIALIZED_NAME_NATIONALITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nationality` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NATIONALITY).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PHONE) != null) {
            PhoneNumber.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PHONE));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RESIDENTIAL_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RESIDENTIAL_ADDRESS));
        }
        if ((jsonArraytaxInformation = jsonObj.getAsJsonArray(SERIALIZED_NAME_TAX_INFORMATION)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TAX_INFORMATION).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `taxInformation` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAX_INFORMATION).toString()));
            }
            for (int i = 0; i < jsonArraytaxInformation.size(); ++i) {
                TaxInformation.validateJsonObject(jsonArraytaxInformation.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WEB_DATA) != null) {
            WebData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WEB_DATA));
        }
    }

    public static Individual fromJson(String jsonString) throws IOException {
        return (Individual)JSON.getGson().fromJson(jsonString, Individual.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BIRTH_DATA);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_IDENTIFICATION_DATA);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NATIONALITY);
        openapiFields.add(SERIALIZED_NAME_PHONE);
        openapiFields.add(SERIALIZED_NAME_RESIDENTIAL_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_TAX_INFORMATION);
        openapiFields.add(SERIALIZED_NAME_WEB_DATA);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_RESIDENTIAL_ADDRESS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Individual.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Individual.class));
            return new TypeAdapter<Individual>(){

                public void write(JsonWriter out, Individual value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Individual read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Individual.validateJsonObject(jsonObj);
                    return (Individual)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

