/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Attachment;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.OwnerEntity;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Document {
    public static final String SERIALIZED_NAME_ATTACHMENT = "attachment";
    @SerializedName(value="attachment")
    private Attachment attachment;
    public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
    @SerializedName(value="attachments")
    private List<Attachment> attachments = new ArrayList<Attachment>();
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private OffsetDateTime creationDate;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EXPIRY_DATE = "expiryDate";
    @SerializedName(value="expiryDate")
    private String expiryDate;
    public static final String SERIALIZED_NAME_FILE_NAME = "fileName";
    @SerializedName(value="fileName")
    private String fileName;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_ISSUER_COUNTRY = "issuerCountry";
    @SerializedName(value="issuerCountry")
    private String issuerCountry;
    public static final String SERIALIZED_NAME_ISSUER_STATE = "issuerState";
    @SerializedName(value="issuerState")
    private String issuerState;
    public static final String SERIALIZED_NAME_MODIFICATION_DATE = "modificationDate";
    @SerializedName(value="modificationDate")
    private OffsetDateTime modificationDate;
    public static final String SERIALIZED_NAME_NUMBER = "number";
    @SerializedName(value="number")
    private String number;
    public static final String SERIALIZED_NAME_OWNER = "owner";
    @SerializedName(value="owner")
    private OwnerEntity owner;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Document() {
    }

    public Document(OffsetDateTime creationDate, String id, OffsetDateTime modificationDate) {
        this();
        this.creationDate = creationDate;
        this.id = id;
        this.modificationDate = modificationDate;
    }

    public Document attachment(Attachment attachment) {
        this.attachment = attachment;
        return this;
    }

    @ApiModelProperty(value="")
    public Attachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public Document attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Document addAttachmentsItem(Attachment attachmentsItem) {
        this.attachments.add(attachmentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array that contains the document. The array supports multiple attachments for uploading different sides or pages of a document.")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    @ApiModelProperty(value="The creation date of the document.")
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public Document description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="Your description for the document.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Document expiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The expiry date of the document, in YYYY-MM-DD format.")
    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Document fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(value="The filename of the document.")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the document.")
    public String getId() {
        return this.id;
    }

    public Document issuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the document was issued. For example, **US**.")
    public String getIssuerCountry() {
        return this.issuerCountry;
    }

    public void setIssuerCountry(String issuerCountry) {
        this.issuerCountry = issuerCountry;
    }

    public Document issuerState(String issuerState) {
        this.issuerState = issuerState;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The state or province where the document was issued (AU only).")
    public String getIssuerState() {
        return this.issuerState;
    }

    public void setIssuerState(String issuerState) {
        this.issuerState = issuerState;
    }

    @ApiModelProperty(value="The modification date of the document.")
    public OffsetDateTime getModificationDate() {
        return this.modificationDate;
    }

    public Document number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(value="The number in the document.")
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Document owner(OwnerEntity owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public OwnerEntity getOwner() {
        return this.owner;
    }

    public void setOwner(OwnerEntity owner) {
        this.owner = owner;
    }

    public Document type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of document, used when providing an ID number or uploading a document. The possible values depend on the legal entity type.  When providing ID numbers: * For **individual**, the `type` values can be **driversLicense**, **identityCard**, **nationalIdNumber**, or **passport**.  When uploading documents: * For **organization**, the `type` values can be **proofOfAddress**, **registrationDocument**, **vatDocument**, **proofOfOrganizationTaxInfo**, **proofOfOwnership**, or **proofOfIndustry**.   * For **individual**, the `type` values can be **identityCard**, **driversLicense**, **passport**, **proofOfNationalIdNumber**, **proofOfResidency**, **proofOfIndustry**, or **proofOfIndividualTaxId**.  * For **soleProprietorship**, the `type` values can be **constitutionalDocument**, **proofOfAddress**, or **proofOfIndustry**.  * Use **bankStatement** to upload documents for a [transfer instrument](https://docs.adyen.com/api-explorer/#/legalentity/latest/post/transferInstruments__resParam_id).")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.attachment, document.attachment) && Objects.equals(this.attachments, document.attachments) && Objects.equals(this.creationDate, document.creationDate) && Objects.equals(this.description, document.description) && Objects.equals(this.expiryDate, document.expiryDate) && Objects.equals(this.fileName, document.fileName) && Objects.equals(this.id, document.id) && Objects.equals(this.issuerCountry, document.issuerCountry) && Objects.equals(this.issuerState, document.issuerState) && Objects.equals(this.modificationDate, document.modificationDate) && Objects.equals(this.number, document.number) && Objects.equals(this.owner, document.owner) && Objects.equals((Object)this.type, (Object)document.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachment, this.attachments, this.creationDate, this.description, this.expiryDate, this.fileName, this.id, this.issuerCountry, this.issuerState, this.modificationDate, this.number, this.owner, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Document {\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issuerCountry: ").append(this.toIndentedString(this.issuerCountry)).append("\n");
        sb.append("    issuerState: ").append(this.toIndentedString(this.issuerState)).append("\n");
        sb.append("    modificationDate: ").append(this.toIndentedString(this.modificationDate)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayattachments;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Document is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Document` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ATTACHMENT) != null) {
            Attachment.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ATTACHMENT));
        }
        if ((jsonArrayattachments = jsonObj.getAsJsonArray(SERIALIZED_NAME_ATTACHMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ATTACHMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `attachments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTACHMENTS).toString()));
            }
            for (int i = 0; i < jsonArrayattachments.size(); ++i) {
                Attachment.validateJsonObject(jsonArrayattachments.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRY_DATE) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRY_DATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expiryDate` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRY_DATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FILE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FILE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fileName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FILE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuerCountry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER_STATE) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuerState` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER_STATE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NUMBER).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_OWNER) != null) {
            OwnerEntity.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_OWNER));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static Document fromJson(String jsonString) throws IOException {
        return (Document)JSON.getGson().fromJson(jsonString, Document.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ATTACHMENT);
        openapiFields.add(SERIALIZED_NAME_ATTACHMENTS);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_EXPIRY_DATE);
        openapiFields.add(SERIALIZED_NAME_FILE_NAME);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_ISSUER_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_ISSUER_STATE);
        openapiFields.add(SERIALIZED_NAME_MODIFICATION_DATE);
        openapiFields.add(SERIALIZED_NAME_NUMBER);
        openapiFields.add(SERIALIZED_NAME_OWNER);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ATTACHMENTS);
        openapiRequiredFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_OWNER);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Document.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Document.class));
            return new TypeAdapter<Document>(){

                public void write(JsonWriter out, Document value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Document read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Document.validateJsonObject(jsonObj);
                    return (Document)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BANKSTATEMENT("bankStatement"),
        DRIVERSLICENSE("driversLicense"),
        IDENTITYCARD("identityCard"),
        NATIONALIDNUMBER("nationalIdNumber"),
        PASSPORT("passport"),
        PROOFOFADDRESS("proofOfAddress"),
        PROOFOFNATIONALIDNUMBER("proofOfNationalIdNumber"),
        PROOFOFRESIDENCY("proofOfResidency"),
        REGISTRATIONDOCUMENT("registrationDocument"),
        VATDOCUMENT("vatDocument"),
        PROOFOFORGANIZATIONTAXINFO("proofOfOrganizationTaxInfo"),
        PROOFOFINDUSTRY("proofOfIndustry"),
        CONSTITUTIONALDOCUMENT("constitutionalDocument");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

