/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Amount;
import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CapabilitySettings {
    public static final String SERIALIZED_NAME_AMOUNT_PER_INDUSTRY = "amountPerIndustry";
    @SerializedName(value="amountPerIndustry")
    private Map<String, Amount> amountPerIndustry = null;
    public static final String SERIALIZED_NAME_AUTHORIZED_CARD_USERS = "authorizedCardUsers";
    @SerializedName(value="authorizedCardUsers")
    private Boolean authorizedCardUsers;
    public static final String SERIALIZED_NAME_FUNDING_SOURCE = "fundingSource";
    @SerializedName(value="fundingSource")
    private List<FundingSourceEnum> fundingSource = null;
    public static final String SERIALIZED_NAME_INTERVAL = "interval";
    @SerializedName(value="interval")
    private IntervalEnum interval;
    public static final String SERIALIZED_NAME_MAX_AMOUNT = "maxAmount";
    @SerializedName(value="maxAmount")
    private Amount maxAmount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CapabilitySettings amountPerIndustry(Map<String, Amount> amountPerIndustry) {
        this.amountPerIndustry = amountPerIndustry;
        return this;
    }

    public CapabilitySettings putAmountPerIndustryItem(String key, Amount amountPerIndustryItem) {
        if (this.amountPerIndustry == null) {
            this.amountPerIndustry = new HashMap<String, Amount>();
        }
        this.amountPerIndustry.put(key, amountPerIndustryItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, Amount> getAmountPerIndustry() {
        return this.amountPerIndustry;
    }

    public void setAmountPerIndustry(Map<String, Amount> amountPerIndustry) {
        this.amountPerIndustry = amountPerIndustry;
    }

    public CapabilitySettings authorizedCardUsers(Boolean authorizedCardUsers) {
        this.authorizedCardUsers = authorizedCardUsers;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getAuthorizedCardUsers() {
        return this.authorizedCardUsers;
    }

    public void setAuthorizedCardUsers(Boolean authorizedCardUsers) {
        this.authorizedCardUsers = authorizedCardUsers;
    }

    public CapabilitySettings fundingSource(List<FundingSourceEnum> fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    public CapabilitySettings addFundingSourceItem(FundingSourceEnum fundingSourceItem) {
        if (this.fundingSource == null) {
            this.fundingSource = new ArrayList<FundingSourceEnum>();
        }
        this.fundingSource.add(fundingSourceItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<FundingSourceEnum> getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(List<FundingSourceEnum> fundingSource) {
        this.fundingSource = fundingSource;
    }

    public CapabilitySettings interval(IntervalEnum interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(value="")
    public IntervalEnum getInterval() {
        return this.interval;
    }

    public void setInterval(IntervalEnum interval) {
        this.interval = interval;
    }

    public CapabilitySettings maxAmount(Amount maxAmount) {
        this.maxAmount = maxAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(Amount maxAmount) {
        this.maxAmount = maxAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapabilitySettings capabilitySettings = (CapabilitySettings)o;
        return Objects.equals(this.amountPerIndustry, capabilitySettings.amountPerIndustry) && Objects.equals(this.authorizedCardUsers, capabilitySettings.authorizedCardUsers) && Objects.equals(this.fundingSource, capabilitySettings.fundingSource) && Objects.equals((Object)this.interval, (Object)capabilitySettings.interval) && Objects.equals(this.maxAmount, capabilitySettings.maxAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amountPerIndustry, this.authorizedCardUsers, this.fundingSource, this.interval, this.maxAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapabilitySettings {\n");
        sb.append("    amountPerIndustry: ").append(this.toIndentedString(this.amountPerIndustry)).append("\n");
        sb.append("    authorizedCardUsers: ").append(this.toIndentedString(this.authorizedCardUsers)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString(this.fundingSource)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString((Object)this.interval)).append("\n");
        sb.append("    maxAmount: ").append(this.toIndentedString(this.maxAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CapabilitySettings is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CapabilitySettings` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `fundingSource` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTERVAL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INTERVAL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `interval` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INTERVAL).toString()));
            }
            IntervalEnum.fromValue(jsonObj.get(SERIALIZED_NAME_INTERVAL).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MAX_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MAX_AMOUNT));
        }
    }

    public static CapabilitySettings fromJson(String jsonString) throws IOException {
        return (CapabilitySettings)JSON.getGson().fromJson(jsonString, CapabilitySettings.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT_PER_INDUSTRY);
        openapiFields.add(SERIALIZED_NAME_AUTHORIZED_CARD_USERS);
        openapiFields.add(SERIALIZED_NAME_FUNDING_SOURCE);
        openapiFields.add(SERIALIZED_NAME_INTERVAL);
        openapiFields.add(SERIALIZED_NAME_MAX_AMOUNT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CapabilitySettings.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CapabilitySettings.class));
            return new TypeAdapter<CapabilitySettings>(){

                public void write(JsonWriter out, CapabilitySettings value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CapabilitySettings read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CapabilitySettings.validateJsonObject(jsonObj);
                    return (CapabilitySettings)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IntervalEnum {
        DAILY("daily"),
        MONTHLY("monthly"),
        WEEKLY("weekly");

        private String value;

        private IntervalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IntervalEnum fromValue(String value) {
            for (IntervalEnum b : IntervalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<IntervalEnum> {
            public void write(JsonWriter jsonWriter, IntervalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IntervalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IntervalEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        CREDIT("credit"),
        DEBIT("debit"),
        PREPAID("prepaid");

        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(value);
            }
        }
    }
}

