/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RiskData {
    public static final String SERIALIZED_NAME_CLIENT_DATA = "clientData";
    @SerializedName(value="clientData")
    private String clientData;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "customFields";
    @SerializedName(value="customFields")
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_FRAUD_OFFSET = "fraudOffset";
    @SerializedName(value="fraudOffset")
    private Integer fraudOffset;
    public static final String SERIALIZED_NAME_PROFILE_REFERENCE = "profileReference";
    @SerializedName(value="profileReference")
    private String profileReference;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RiskData clientData(String clientData) {
        this.clientData = clientData;
        return this;
    }

    @ApiModelProperty(value="Contains client-side data, like the device fingerprint, cookies, and specific browser settings.")
    public String getClientData() {
        return this.clientData;
    }

    public void setClientData(String clientData) {
        this.clientData = clientData;
    }

    public RiskData customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public RiskData putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Any custom fields used as part of the input to configured risk rules.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public RiskData fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    @ApiModelProperty(value="An integer value that is added to the normal fraud score. The value can be either positive or negative.")
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public RiskData profileReference(String profileReference) {
        this.profileReference = profileReference;
        return this;
    }

    @ApiModelProperty(value="The risk profile to assign to this payment. When left empty, the merchant-level account's default risk profile will be applied.")
    public String getProfileReference() {
        return this.profileReference;
    }

    public void setProfileReference(String profileReference) {
        this.profileReference = profileReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiskData riskData = (RiskData)o;
        return Objects.equals(this.clientData, riskData.clientData) && Objects.equals(this.customFields, riskData.customFields) && Objects.equals(this.fraudOffset, riskData.fraudOffset) && Objects.equals(this.profileReference, riskData.profileReference);
    }

    public int hashCode() {
        return Objects.hash(this.clientData, this.customFields, this.fraudOffset, this.profileReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiskData {\n");
        sb.append("    clientData: ").append(this.toIndentedString(this.clientData)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    profileReference: ").append(this.toIndentedString(this.profileReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RiskData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RiskData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_DATA) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `clientData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLIENT_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROFILE_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PROFILE_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `profileReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROFILE_REFERENCE).toString()));
        }
    }

    public static RiskData fromJson(String jsonString) throws IOException {
        return (RiskData)JSON.getGson().fromJson(jsonString, RiskData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLIENT_DATA);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_FIELDS);
        openapiFields.add(SERIALIZED_NAME_FRAUD_OFFSET);
        openapiFields.add(SERIALIZED_NAME_PROFILE_REFERENCE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!RiskData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RiskData.class));
            return new TypeAdapter<RiskData>(){

                public void write(JsonWriter out, RiskData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public RiskData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RiskData.validateJsonObject(jsonObj);
                    return (RiskData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

