/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LineItem {
    public static final String SERIALIZED_NAME_AMOUNT_EXCLUDING_TAX = "amountExcludingTax";
    @SerializedName(value="amountExcludingTax")
    private Long amountExcludingTax;
    public static final String SERIALIZED_NAME_AMOUNT_INCLUDING_TAX = "amountIncludingTax";
    @SerializedName(value="amountIncludingTax")
    private Long amountIncludingTax;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_IMAGE_URL = "imageUrl";
    @SerializedName(value="imageUrl")
    private String imageUrl;
    public static final String SERIALIZED_NAME_ITEM_CATEGORY = "itemCategory";
    @SerializedName(value="itemCategory")
    private String itemCategory;
    public static final String SERIALIZED_NAME_PRODUCT_URL = "productUrl";
    @SerializedName(value="productUrl")
    private String productUrl;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Long quantity;
    public static final String SERIALIZED_NAME_TAX_AMOUNT = "taxAmount";
    @SerializedName(value="taxAmount")
    private Long taxAmount;
    public static final String SERIALIZED_NAME_TAX_PERCENTAGE = "taxPercentage";
    @SerializedName(value="taxPercentage")
    private Long taxPercentage;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LineItem amountExcludingTax(Long amountExcludingTax) {
        this.amountExcludingTax = amountExcludingTax;
        return this;
    }

    @ApiModelProperty(value="Item amount excluding the tax, in minor units.")
    public Long getAmountExcludingTax() {
        return this.amountExcludingTax;
    }

    public void setAmountExcludingTax(Long amountExcludingTax) {
        this.amountExcludingTax = amountExcludingTax;
    }

    public LineItem amountIncludingTax(Long amountIncludingTax) {
        this.amountIncludingTax = amountIncludingTax;
        return this;
    }

    @ApiModelProperty(value="Item amount including the tax, in minor units.")
    public Long getAmountIncludingTax() {
        return this.amountIncludingTax;
    }

    public void setAmountIncludingTax(Long amountIncludingTax) {
        this.amountIncludingTax = amountIncludingTax;
    }

    public LineItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Description of the line item.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LineItem id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="ID of the line item.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LineItem imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @ApiModelProperty(value="Link to the picture of the purchased item.")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public LineItem itemCategory(String itemCategory) {
        this.itemCategory = itemCategory;
        return this;
    }

    @ApiModelProperty(value="Item category, used by the RatePay payment method.")
    public String getItemCategory() {
        return this.itemCategory;
    }

    public void setItemCategory(String itemCategory) {
        this.itemCategory = itemCategory;
    }

    public LineItem productUrl(String productUrl) {
        this.productUrl = productUrl;
        return this;
    }

    @ApiModelProperty(value="Link to the purchased item.")
    public String getProductUrl() {
        return this.productUrl;
    }

    public void setProductUrl(String productUrl) {
        this.productUrl = productUrl;
    }

    public LineItem quantity(Long quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="Number of items.")
    public Long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public LineItem taxAmount(Long taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty(value="Tax amount, in minor units.")
    public Long getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Long taxAmount) {
        this.taxAmount = taxAmount;
    }

    public LineItem taxPercentage(Long taxPercentage) {
        this.taxPercentage = taxPercentage;
        return this;
    }

    @ApiModelProperty(value="Tax percentage, in minor units.")
    public Long getTaxPercentage() {
        return this.taxPercentage;
    }

    public void setTaxPercentage(Long taxPercentage) {
        this.taxPercentage = taxPercentage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineItem lineItem = (LineItem)o;
        return Objects.equals(this.amountExcludingTax, lineItem.amountExcludingTax) && Objects.equals(this.amountIncludingTax, lineItem.amountIncludingTax) && Objects.equals(this.description, lineItem.description) && Objects.equals(this.id, lineItem.id) && Objects.equals(this.imageUrl, lineItem.imageUrl) && Objects.equals(this.itemCategory, lineItem.itemCategory) && Objects.equals(this.productUrl, lineItem.productUrl) && Objects.equals(this.quantity, lineItem.quantity) && Objects.equals(this.taxAmount, lineItem.taxAmount) && Objects.equals(this.taxPercentage, lineItem.taxPercentage);
    }

    public int hashCode() {
        return Objects.hash(this.amountExcludingTax, this.amountIncludingTax, this.description, this.id, this.imageUrl, this.itemCategory, this.productUrl, this.quantity, this.taxAmount, this.taxPercentage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineItem {\n");
        sb.append("    amountExcludingTax: ").append(this.toIndentedString(this.amountExcludingTax)).append("\n");
        sb.append("    amountIncludingTax: ").append(this.toIndentedString(this.amountIncludingTax)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    itemCategory: ").append(this.toIndentedString(this.itemCategory)).append("\n");
        sb.append("    productUrl: ").append(this.toIndentedString(this.productUrl)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    taxPercentage: ").append(this.toIndentedString(this.taxPercentage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in LineItem is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `LineItem` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_URL) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `imageUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ITEM_CATEGORY) != null && !jsonObj.get(SERIALIZED_NAME_ITEM_CATEGORY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `itemCategory` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ITEM_CATEGORY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRODUCT_URL) != null && !jsonObj.get(SERIALIZED_NAME_PRODUCT_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `productUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRODUCT_URL).toString()));
        }
    }

    public static LineItem fromJson(String jsonString) throws IOException {
        return (LineItem)JSON.getGson().fromJson(jsonString, LineItem.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT_EXCLUDING_TAX);
        openapiFields.add(SERIALIZED_NAME_AMOUNT_INCLUDING_TAX);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_IMAGE_URL);
        openapiFields.add(SERIALIZED_NAME_ITEM_CATEGORY);
        openapiFields.add(SERIALIZED_NAME_PRODUCT_URL);
        openapiFields.add(SERIALIZED_NAME_QUANTITY);
        openapiFields.add(SERIALIZED_NAME_TAX_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_TAX_PERCENTAGE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LineItem.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LineItem.class));
            return new TypeAdapter<LineItem>(){

                public void write(JsonWriter out, LineItem value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LineItem read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    LineItem.validateJsonObject(jsonObj);
                    return (LineItem)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

