/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CreateApplePaySessionRequest {
    public static final String SERIALIZED_NAME_DISPLAY_NAME = "displayName";
    @SerializedName(value="displayName")
    private String displayName;
    public static final String SERIALIZED_NAME_DOMAIN_NAME = "domainName";
    @SerializedName(value="domainName")
    private String domainName;
    public static final String SERIALIZED_NAME_MERCHANT_IDENTIFIER = "merchantIdentifier";
    @SerializedName(value="merchantIdentifier")
    private String merchantIdentifier;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateApplePaySessionRequest displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(required=true, value="This is the name that your shoppers will see in the Apple Pay interface.  The value returned as `configuration.merchantName` field from the [`/paymentMethods`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods) response.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CreateApplePaySessionRequest domainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    @ApiModelProperty(required=true, value="The domain name you provided when you added Apple Pay in your Customer Area.  This must match the `window.location.hostname` of the web shop.")
    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public CreateApplePaySessionRequest merchantIdentifier(String merchantIdentifier) {
        this.merchantIdentifier = merchantIdentifier;
        return this;
    }

    @ApiModelProperty(required=true, value="Your merchant identifier registered with Apple Pay.  Use the value of the `configuration.merchantId` field from the [`/paymentMethods`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/paymentMethods) response.")
    public String getMerchantIdentifier() {
        return this.merchantIdentifier;
    }

    public void setMerchantIdentifier(String merchantIdentifier) {
        this.merchantIdentifier = merchantIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateApplePaySessionRequest createApplePaySessionRequest = (CreateApplePaySessionRequest)o;
        return Objects.equals(this.displayName, createApplePaySessionRequest.displayName) && Objects.equals(this.domainName, createApplePaySessionRequest.domainName) && Objects.equals(this.merchantIdentifier, createApplePaySessionRequest.merchantIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.domainName, this.merchantIdentifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateApplePaySessionRequest {\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    merchantIdentifier: ").append(this.toIndentedString(this.merchantIdentifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateApplePaySessionRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateApplePaySessionRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DISPLAY_NAME) != null && !jsonObj.get(SERIALIZED_NAME_DISPLAY_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `displayName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DISPLAY_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DOMAIN_NAME) != null && !jsonObj.get(SERIALIZED_NAME_DOMAIN_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `domainName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DOMAIN_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_IDENTIFIER) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_IDENTIFIER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantIdentifier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_IDENTIFIER).toString()));
        }
    }

    public static CreateApplePaySessionRequest fromJson(String jsonString) throws IOException {
        return (CreateApplePaySessionRequest)JSON.getGson().fromJson(jsonString, CreateApplePaySessionRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DISPLAY_NAME);
        openapiFields.add(SERIALIZED_NAME_DOMAIN_NAME);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_IDENTIFIER);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DISPLAY_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_DOMAIN_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_IDENTIFIER);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateApplePaySessionRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateApplePaySessionRequest.class));
            return new TypeAdapter<CreateApplePaySessionRequest>(){

                public void write(JsonWriter out, CreateApplePaySessionRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateApplePaySessionRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateApplePaySessionRequest.validateJsonObject(jsonObj);
                    return (CreateApplePaySessionRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

