/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PhoneNumber {
    public static final String SERIALIZED_NAME_PHONE_COUNTRY_CODE = "phoneCountryCode";
    @SerializedName(value="phoneCountryCode")
    private String phoneCountryCode;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phoneNumber";
    @SerializedName(value="phoneNumber")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_PHONE_TYPE = "phoneType";
    @SerializedName(value="phoneType")
    private PhoneTypeEnum phoneType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PhoneNumber phoneCountryCode(String phoneCountryCode) {
        this.phoneCountryCode = phoneCountryCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-character ISO-3166-1 alpha-2 country code of the phone number. For example, **US** or **NL**.")
    public String getPhoneCountryCode() {
        return this.phoneCountryCode;
    }

    public void setPhoneCountryCode(String phoneCountryCode) {
        this.phoneCountryCode = phoneCountryCode;
    }

    public PhoneNumber phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The phone number. The inclusion of the phone number country code is not necessary.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public PhoneNumber phoneType(PhoneTypeEnum phoneType) {
        this.phoneType = phoneType;
        return this;
    }

    @ApiModelProperty(value="The type of the phone number. Possible values: **Landline**, **Mobile**, **SIP**, **Fax**.")
    public PhoneTypeEnum getPhoneType() {
        return this.phoneType;
    }

    public void setPhoneType(PhoneTypeEnum phoneType) {
        this.phoneType = phoneType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber phoneNumber = (PhoneNumber)o;
        return Objects.equals(this.phoneCountryCode, phoneNumber.phoneCountryCode) && Objects.equals(this.phoneNumber, phoneNumber.phoneNumber) && Objects.equals((Object)this.phoneType, (Object)phoneNumber.phoneType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.phoneCountryCode, this.phoneNumber, this.phoneType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhoneNumber {\n");
        sb.append("    phoneCountryCode: ").append(this.toIndentedString(this.phoneCountryCode)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    phoneType: ").append(this.toIndentedString((Object)this.phoneType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PhoneNumber is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PhoneNumber` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHONE_COUNTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_PHONE_COUNTRY_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phoneCountryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHONE_COUNTRY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHONE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHONE_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PHONE_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `phoneType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHONE_TYPE).toString()));
            }
            PhoneTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_PHONE_TYPE).getAsString());
        }
    }

    public static PhoneNumber fromJson(String jsonString) throws IOException {
        return (PhoneNumber)JSON.getGson().fromJson(jsonString, PhoneNumber.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PHONE_COUNTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_PHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_PHONE_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PHONE_COUNTRY_CODE);
        openapiRequiredFields.add(SERIALIZED_NAME_PHONE_NUMBER);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PhoneNumber.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PhoneNumber.class));
            return new TypeAdapter<PhoneNumber>(){

                public void write(JsonWriter out, PhoneNumber value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PhoneNumber read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PhoneNumber.validateJsonObject(jsonObj);
                    return (PhoneNumber)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PhoneTypeEnum {
        FAX("Fax"),
        LANDLINE("Landline"),
        MOBILE("Mobile"),
        SIP("SIP");

        private String value;

        private PhoneTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PhoneTypeEnum fromValue(String value) {
            for (PhoneTypeEnum b : PhoneTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PhoneTypeEnum> {
            public void write(JsonWriter jsonWriter, PhoneTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PhoneTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PhoneTypeEnum.fromValue(value);
            }
        }
    }
}

